/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.client.screen;

import java.util.List;
import java.util.Objects;
import mod.azure.azurelib.client.DisplayAdapter;
import mod.azure.azurelib.client.screen.AbstractConfigScreen;
import mod.azure.azurelib.client.screen.ConfigScreen;
import mod.azure.azurelib.client.widget.ConfigEntryWidget;
import mod.azure.azurelib.config.ConfigHolder;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_6382;

public class ConfigGroupScreen
extends class_437 {
    protected final class_437 last;
    protected final String groupId;
    protected final List<ConfigHolder<?>> configHolders;
    protected int index;
    protected int pageSize;

    public ConfigGroupScreen(class_437 last, String groupId, List<ConfigHolder<?>> configHolders) {
        super((class_2561)class_2561.method_43471((String)"text.azurelib.screen.select_config"));
        this.last = last;
        this.groupId = groupId;
        this.configHolders = configHolders;
    }

    protected void method_25426() {
        int viewportMin = 35;
        int viewportHeight = this.field_22790 - 35 - 30;
        this.pageSize = (viewportHeight - 20) / 25;
        this.correctScrollingIndex(this.configHolders.size());
        int errorOffset = viewportHeight - 20 - (this.pageSize * 25 - 5);
        int offset = 0;
        int posX = 30;
        int componentWidth = this.field_22789 - 2 * posX;
        for (int i = this.index; i < this.index + this.pageSize; ++i) {
            int j = i - this.index;
            if (i >= this.configHolders.size()) break;
            int correct = errorOffset / (this.pageSize - j);
            errorOffset -= correct;
            ConfigHolder<?> value = this.configHolders.get(i);
            int y = 45 + j * 25 + (offset += correct);
            String configId = value.getConfigId();
            this.method_37063((class_364)new LeftAlignedLabel(posX, y, componentWidth, 20, (class_2561)class_2561.method_43471((String)("config.screen." + configId)), this.field_22793));
            this.method_37063((class_364)new class_4185(DisplayAdapter.getValueX(posX, componentWidth), y, DisplayAdapter.getValueWidth(componentWidth), 20, ConfigEntryWidget.EDIT, btn -> {
                ConfigScreen screen = new ConfigScreen(configId, configId, value.getValueMap(), (class_437)this);
                this.field_22787.method_1507((class_437)screen);
            }));
        }
        this.initFooter();
    }

    public void method_25394(class_4587 stack, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(stack);
        int titleWidth = this.field_22793.method_27525((class_5348)this.field_22785);
        float f = (float)(this.field_22789 - titleWidth) / 2.0f;
        Objects.requireNonNull(this.field_22793);
        this.field_22793.method_30883(stack, this.field_22785, f, (float)(35 - 9) / 2.0f, 0xFFFFFF);
        ConfigGroupScreen.method_25294((class_4587)stack, (int)0, (int)35, (int)this.field_22789, (int)(this.field_22790 - 30), (int)-1728053248);
        AbstractConfigScreen.renderScrollbar(stack, this.field_22789 - 5, 35, 5, this.field_22790 - 30 - 35, this.index, this.configHolders.size(), this.pageSize);
        super.method_25394(stack, mouseX, mouseY, partialTicks);
    }

    protected void initFooter() {
        int centerY = this.field_22790 - 30 + 5;
        this.method_37063((class_364)new class_4185(20, centerY, 50, 20, ConfigEntryWidget.BACK, btn -> this.field_22787.method_1507(this.last)));
    }

    protected void correctScrollingIndex(int count) {
        if (this.index + this.pageSize > count) {
            this.index = Math.max(count - this.pageSize, 0);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int scale = (int)(-amount);
        int next = this.index + scale;
        if (next >= 0 && next + this.pageSize <= this.configHolders.size()) {
            this.index = next;
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
            return true;
        }
        return false;
    }

    protected static final class LeftAlignedLabel
    extends class_339 {
        private final class_327 font;

        public LeftAlignedLabel(int x, int y, int width, int height, class_2561 label, class_327 font) {
            super(x, y, width, height, label);
            this.font = font;
        }

        public void method_25359(class_4587 stack, int mouseX, int mouseY, float partialTicks) {
            class_2561 class_25612 = this.method_25369();
            float f = this.field_22760;
            float f2 = this.field_22761;
            Objects.requireNonNull(this.font);
            this.font.method_30883(stack, class_25612, f, f2 + (float)(this.field_22759 - 9) / 2.0f, 0xAAAAAA);
        }

        protected boolean method_25351(int p_230987_1_) {
            return false;
        }

        public void method_37020(class_6382 p_169152_) {
        }
    }
}

