/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.client.widget;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mod.azure.azurelib.client.WidgetAdder;
import mod.azure.azurelib.client.widget.ContainerWidget;
import mod.azure.azurelib.config.validate.NotificationSeverity;
import mod.azure.azurelib.config.validate.ValidationResult;
import mod.azure.azurelib.config.value.ConfigValue;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class ConfigEntryWidget
extends ContainerWidget
implements WidgetAdder {
    public static final class_2561 EDIT = class_2561.method_43471((String)"text.azurelib.value.edit");
    public static final class_2561 BACK = class_2561.method_43471((String)"text.azurelib.value.back");
    public static final class_2561 REVERT_DEFAULTS = class_2561.method_43471((String)"text.azurelib.value.revert.default");
    public static final class_2561 REVERT_DEFAULTS_DIALOG_TEXT = class_2561.method_43471((String)"text.azurelib.value.revert.default.dialog");
    public static final class_2561 REVERT_CHANGES = class_2561.method_43471((String)"text.azurelib.value.revert.changes");
    public static final class_2561 REVERT_CHANGES_DIALOG_TEXT = class_2561.method_43471((String)"text.azurelib.value.revert.changes.dialog");
    private final String configId;
    private final List<class_2561> description;
    private ValidationResult result = ValidationResult.ok();
    private IDescriptionRenderer renderer;
    private boolean lastHoverState;
    private long hoverTimeStart;

    public ConfigEntryWidget(int x, int y, int w, int h, ConfigValue<?> value, String configId) {
        super(x, y, w, h, (class_2561)class_2561.method_43471((String)("config." + configId + ".option." + value.getId())));
        this.configId = configId;
        this.description = Arrays.stream(value.getDescription()).map(text -> class_2561.method_43470((String)text).method_27692(class_124.field_1080)).collect(Collectors.toList());
    }

    public void setDescriptionRenderer(IDescriptionRenderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public class_2561 getComponentName() {
        return this.method_25369();
    }

    public void method_37020(@NotNull class_6382 narrationElementOutput) {
    }

    @Override
    public void method_25359(@NotNull class_4587 stack, int mouseX, int mouseY, float partialTicks) {
        class_327 font = class_310.method_1551().field_1772;
        if (!this.lastHoverState && this.field_22762) {
            this.hoverTimeStart = System.currentTimeMillis();
        }
        boolean isError = !this.result.isOk();
        class_2561 class_25612 = this.method_25369();
        float f = this.field_22760;
        float f2 = this.field_22761;
        Objects.requireNonNull(font);
        font.method_30883(stack, class_25612, f, f2 + (float)(this.field_22759 - 9) / 2.0f, 0xAAAAAA);
        super.method_25359(stack, mouseX, mouseY, partialTicks);
        if ((isError || this.field_22762) && this.renderer != null) {
            long totalHoverTime = System.currentTimeMillis() - this.hoverTimeStart;
            if (isError || totalHoverTime >= 750L) {
                NotificationSeverity severity = this.result.severity();
                class_5250 textComponent = this.result.text().method_27692(severity.getExtraFormatting());
                List<class_5250> desc = isError ? Collections.singletonList(textComponent) : this.description;
                List<class_5481> split = desc.stream().flatMap(text -> font.method_1728((class_5348)text, this.field_22758 / 2).stream()).collect(Collectors.toList());
                this.renderer.drawDescription(stack, this, severity, split);
            }
        }
        this.lastHoverState = this.field_22762;
    }

    @Override
    public void setValidationResult(ValidationResult result) {
        this.result = result;
    }

    @Override
    public <W extends class_339> W addConfigWidget(WidgetAdder.ToWidgetFunction<W> function) {
        W widget = function.asWidget(this.field_22760, this.field_22761, this.field_22758, this.field_22759, this.configId);
        return this.addRenderableWidget(widget);
    }

    @FunctionalInterface
    public static interface IDescriptionRenderer {
        public void drawDescription(class_4587 var1, class_339 var2, NotificationSeverity var3, List<class_5481> var4);
    }
}

