/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.render.entity;

import java.util.UUID;
import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.render.AzLayerRenderer;
import mod.azure.azurelib.render.AzModelRenderer;
import mod.azure.azurelib.render.AzRendererConfig;
import mod.azure.azurelib.render.AzRendererPipeline;
import mod.azure.azurelib.render.AzRendererPipelineContext;
import mod.azure.azurelib.render.entity.AzEntityLayerRenderer;
import mod.azure.azurelib.render.entity.AzEntityLeashRenderUtil;
import mod.azure.azurelib.render.entity.AzEntityRenderer;
import mod.azure.azurelib.render.entity.AzEntityRendererConfig;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class AzEntityRendererPipeline<T extends class_1297>
extends AzRendererPipeline<UUID, T> {
    private final AzEntityRenderer<T> entityRenderer;
    protected class_1159 entityRenderTranslations = new class_1159();
    protected class_1159 modelRenderTranslations = new class_1159();

    public AzEntityRendererPipeline(AzEntityRendererConfig<T> config, AzEntityRenderer<T> entityRenderer) {
        super(config);
        this.entityRenderer = entityRenderer;
    }

    @Override
    protected AzRendererPipelineContext<UUID, T> createContext(AzRendererPipeline<UUID, T> rendererPipeline) {
        return this.config.pipelineContext(this);
    }

    @Override
    protected AzModelRenderer<UUID, T> createModelRenderer(AzLayerRenderer<UUID, T> layerRenderer) {
        return this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<UUID, T> createLayerRenderer(AzRendererConfig<UUID, T> config) {
        return new AzEntityLayerRenderer(config::renderLayers);
    }

    @Override
    public void updateAnimatedTextureFrame(T entity) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(this.context().currentEntity(), entity));
    }

    @Override
    public void preRender(AzRendererPipelineContext<UUID, T> context, boolean isReRender) {
        class_4587 poseStack = context.poseStack();
        this.entityRenderTranslations.method_35434(poseStack.method_23760().method_23761());
        AzEntityRendererConfig<Object> config = this.entityRenderer.config();
        float scaleWidth = config.scaleWidth((class_1297)context.animatable());
        float scaleHeight = config.scaleHeight((class_1297)context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (config.alpha((class_1297)context.animatable()) < 1.0f || ((class_1297)context.animatable()).method_5767()) {
            float setAlpha = ((class_1297)context.animatable()).method_5767() ? (((class_1297)context.animatable()).method_5756((class_1657)class_310.method_1551().field_1724) ? 0.0f : 0.38f) : config.alpha((class_1297)context.animatable());
            context.setAlpha(setAlpha);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<UUID, T> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    @Override
    public void renderFinal(AzRendererPipelineContext<UUID, T> context) {
        class_4597 bufferSource = context.multiBufferSource();
        class_1297 entity = (class_1297)context.animatable();
        int packedLight = context.packedLight();
        float partialTick = context.partialTick();
        class_4587 poseStack = context.poseStack();
        this.entityRenderer.superRender(entity, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        if (!(entity instanceof class_1308)) {
            return;
        }
        class_1308 mob = (class_1308)entity;
        class_1297 leashHolder = mob.method_5933();
        if (leashHolder == null) {
            return;
        }
        AzEntityLeashRenderUtil.renderLeash(this.entityRenderer, mob, partialTick, poseStack, bufferSource, leashHolder);
    }

    @Override
    protected void doPostRenderCleanup(AzRendererPipelineContext<UUID, T> context) {
        context.setCurrentEntity(null);
    }

    public AzEntityRenderer<T> getRenderer() {
        return this.entityRenderer;
    }
}

