/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.model.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import mod.azure.azurelib.common.internal.common.loading.FileLoader;
import mod.azure.azurelib.common.internal.common.loading.json.raw.Model;
import mod.azure.azurelib.common.internal.common.loading.object.GeometryTree;
import mod.azure.azurelib.rewrite.AzResourceCache;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.factory.registry.AzBakedModelFactoryRegistry;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

public class AzBakedModelCache
extends AzResourceCache {
    private static final AzBakedModelCache INSTANCE = new AzBakedModelCache();
    private final Map<class_2960, AzBakedModel> bakedModels = new Object2ObjectOpenHashMap();

    public static AzBakedModelCache getInstance() {
        return INSTANCE;
    }

    private AzBakedModelCache() {
    }

    public CompletableFuture<Void> loadModels(Executor backgroundExecutor, class_3300 resourceManager) {
        return this.loadResources(backgroundExecutor, resourceManager, "geo", resource -> {
            Model model = FileLoader.loadModelFile(resource, resourceManager);
            return AzBakedModelFactoryRegistry.getForNamespace(resource.method_12836()).constructGeoModel(GeometryTree.fromModel(model));
        }, this.bakedModels::put);
    }

    @Nullable
    public AzBakedModel getNullable(class_2960 resourceLocation) {
        return this.bakedModels.get(resourceLocation);
    }
}

