/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.item;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.cache.object.GeoQuad;
import mod.azure.azurelib.common.internal.common.cache.object.GeoVertex;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.item.AzItemModelRenderer;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipeline;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class AzDynamicItemModelRenderer
extends AzItemModelRenderer {
    public AzDynamicItemModelRenderer(AzItemRendererPipeline itemRendererPipeline, AzLayerRenderer<class_1799> layerRenderer) {
        super(itemRendererPipeline, layerRenderer);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<class_1799> context, AzBone bone, boolean isReRender) {
        class_1921 renderType = context.renderType();
        class_4588 buffer = context.vertexConsumer();
        class_4597 bufferSource = context.multiBufferSource();
        class_4587 poseStack = context.poseStack();
        if (bone.isTrackingMatrices()) {
            class_1799 animatable = context.animatable();
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.itemRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.translateMatrix(localMatrix, this.getRenderOffset(animatable, 1.0f).method_46409()));
        }
        AzRendererConfig<class_1799> config = this.itemRendererPipeline.config();
        context.setTextureOverride(this.getTextureOverrideForBone(bone, context.animatable(), context.partialTick()));
        class_2960 texture = context.getTextureOverride() == null ? config.textureLocation(context.animatable()) : context.getTextureOverride();
        class_1921 renderTypeOverride = this.getRenderTypeOverrideForBone(bone, context.animatable(), texture, bufferSource, context.partialTick());
        if (texture != null && renderTypeOverride == null) {
            renderType = renderTypeOverride = context.getDefaultRenderType(context.animatable(), texture, context.multiBufferSource(), context.partialTick());
        }
        if (renderTypeOverride != null) {
            context.setVertexConsumer(bufferSource.getBuffer(renderTypeOverride));
            renderType = renderTypeOverride;
        }
        if (!this.boneRenderOverride(poseStack, bone, bufferSource, buffer, context.partialTick(), context.packedLight(), context.packedOverlay(), context.renderColor())) {
            super.renderCubesOfBone(context, bone);
        }
        if (!isReRender && buffer instanceof class_287) {
            class_287 builder = (class_287)buffer;
            if (!builder.field_1556) {
                context.setVertexConsumer(bufferSource.getBuffer(renderType));
            }
        }
        super.renderRecursively(context, bone, isReRender);
    }

    @Override
    protected void createVerticesOfQuad(AzRendererPipelineContext<class_1799> context, GeoQuad quad, Matrix4f poseState, Vector3f normal) {
        if (context.getTextureOverride() == null) {
            super.createVerticesOfQuad(context, quad, poseState, normal);
            return;
        }
        AzRendererConfig<class_1799> config = this.itemRendererPipeline.config();
        IntIntPair boneTextureSize = context.computeTextureSize(context.getTextureOverride());
        IntIntPair entityTextureSize = context.computeTextureSize(config.textureLocation(context.animatable()));
        if (boneTextureSize == null || entityTextureSize == null) {
            super.createVerticesOfQuad(context, quad, poseState, normal);
            return;
        }
        for (GeoVertex vertex : quad.vertices()) {
            Vector4f vector4f = poseState.transform(new Vector4f(vertex.position().x(), vertex.position().y(), vertex.position().z(), 1.0f));
            float texU = vertex.texU() * (float)entityTextureSize.firstInt() / (float)boneTextureSize.firstInt();
            float texV = vertex.texV() * (float)entityTextureSize.secondInt() / (float)boneTextureSize.secondInt();
            context.vertexConsumer().method_23919(vector4f.x(), vector4f.y(), vector4f.z(), -1, texU, texV, context.packedOverlay(), context.packedLight(), normal.x(), normal.y(), normal.z());
        }
    }
}

