/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.common.internal.common.cache.texture.AnimatableTexture;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.entity.AzEntityLayerRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityLeashRenderUtil;
import mod.azure.azurelib.rewrite.render.entity.AzEntityModelRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipelineContext;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzEntityRendererPipeline<T extends Entity>
extends AzRendererPipeline<T> {
    private final AzEntityRenderer<T> entityRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzEntityRendererPipeline(AzEntityRendererConfig<T> config, AzEntityRenderer<T> entityRenderer) {
        super(config);
        this.entityRenderer = entityRenderer;
    }

    @Override
    protected AzRendererPipelineContext<T> createContext(AzRendererPipeline<T> rendererPipeline) {
        return new AzEntityRendererPipelineContext(this);
    }

    @Override
    protected AzModelRenderer<T> createModelRenderer(AzLayerRenderer<T> layerRenderer) {
        return new AzEntityModelRenderer<T>(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<T> createLayerRenderer(AzRendererConfig<T> config) {
        return new AzEntityLayerRenderer(config::renderLayers);
    }

    @Override
    public void updateAnimatedTextureFrame(T entity) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(entity));
    }

    @Override
    public void preRender(AzRendererPipelineContext<T> context, boolean isReRender) {
        PoseStack poseStack = context.poseStack();
        this.entityRenderTranslations.set((Matrix4fc)poseStack.last().pose());
        AzEntityRendererConfig<Object> config = this.entityRenderer.config();
        float scaleWidth = config.scaleWidth((Entity)context.animatable());
        float scaleHeight = config.scaleHeight((Entity)context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (config.alpha((Entity)context.animatable()) < 1.0f) {
            int alpha = (int)(config.alpha((Entity)context.animatable()) * 255.0f) << 24;
            int color = context.renderColor() & 0xFFFFFF | alpha;
            context.setRenderColor(color);
        }
        config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<T> context, boolean isReRender) {
        this.config.postRenderEntry(context);
        context.setTextureOverride(null);
    }

    @Override
    public void renderFinal(AzRendererPipelineContext<T> context) {
        MultiBufferSource bufferSource = context.multiBufferSource();
        Entity entity = (Entity)context.animatable();
        int packedLight = context.packedLight();
        float partialTick = context.partialTick();
        PoseStack poseStack = context.poseStack();
        this.entityRenderer.superRender(entity, 0.0f, partialTick, poseStack, bufferSource, packedLight);
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        Entity leashHolder = mob.getLeashHolder();
        if (leashHolder == null) {
            return;
        }
        AzEntityLeashRenderUtil.renderLeash(this.entityRenderer, mob, partialTick, poseStack, bufferSource, leashHolder);
    }

    public AzEntityRenderer<T> getRenderer() {
        return this.entityRenderer;
    }
}

