/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.sensor.custom;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.registry.SBLMemoryTypes;
import mod.azure.azurelib.sblforked.registry.SBLSensors;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;

@Deprecated
public class UnreachableTargetSensor<E extends LivingEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.ATTACK_TARGET, SBLMemoryTypes.TARGET_UNREACHABLE.get()});
    protected long lastUnpathableTime = 0L;

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.UNREACHABLE_TARGET.get();
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        Brain brain = entity.getBrain();
        LivingEntity target = BrainUtils.getTargetOfEntity(entity);
        if (target == null) {
            this.resetState(brain);
            return;
        }
        Long unpathableTime = (Long)BrainUtils.getMemory(brain, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        if (unpathableTime == null) {
            this.resetState(brain);
            return;
        }
        if (this.lastUnpathableTime == 0L) {
            this.lastUnpathableTime = unpathableTime;
        } else if (this.lastUnpathableTime == unpathableTime) {
            BrainUtils.clearMemory(brain, SBLMemoryTypes.TARGET_UNREACHABLE.get());
        } else if (this.lastUnpathableTime < unpathableTime) {
            this.lastUnpathableTime = unpathableTime;
            BrainUtils.setMemory(brain, SBLMemoryTypes.TARGET_UNREACHABLE.get(), Boolean.valueOf(target.getY() > entity.getEyeY()));
        }
    }

    private void resetState(Brain<?> brain) {
        if (this.lastUnpathableTime > 0L) {
            BrainUtils.clearMemory(brain, SBLMemoryTypes.TARGET_UNREACHABLE.get());
        }
        this.lastUnpathableTime = 0L;
    }
}

