/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.model;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mod.azure.azurelib.common.model.AzBone;
import org.jetbrains.annotations.Nullable;

public class AzBakedModel {
    private static AzBakedModel defaultModel = new AzBakedModel(List.of());
    private final Map<String, AzBone> bonesByName;
    private final List<AzBone> topLevelBones;

    public AzBakedModel(List<AzBone> topLevelBones) {
        this.topLevelBones = Collections.unmodifiableList(topLevelBones);
        this.bonesByName = Collections.unmodifiableMap(this.mapBonesByName(topLevelBones));
    }

    private Map<String, AzBone> mapBonesByName(List<AzBone> bones) {
        HashMap<String, AzBone> bonesByName = new HashMap<String, AzBone>();
        ArrayDeque<AzBone> nodesToMap = new ArrayDeque<AzBone>(bones);
        while (!nodesToMap.isEmpty()) {
            AzBone currentBone = nodesToMap.poll();
            nodesToMap.addAll(currentBone.getChildBones());
            currentBone.saveInitialSnapshot();
            bonesByName.put(currentBone.getName(), currentBone);
        }
        return bonesByName;
    }

    public AzBakedModel deepCopy() {
        ArrayList<AzBone> copied = new ArrayList<AzBone>(this.topLevelBones.size());
        for (AzBone bone : this.topLevelBones) {
            copied.add(bone.deepCopy());
        }
        return new AzBakedModel(copied);
    }

    @Nullable
    public AzBone getBoneOrNull(String name) {
        return this.bonesByName.get(name);
    }

    public Optional<AzBone> getBone(String name) {
        return Optional.ofNullable(this.getBoneOrNull(name));
    }

    public Map<String, AzBone> getBonesByName() {
        return this.bonesByName;
    }

    public List<AzBone> getTopLevelBones() {
        return this.topLevelBones;
    }

    public static AzBakedModel getDefault() {
        return defaultModel;
    }

    public static void setDefault(AzBakedModel model) {
        defaultModel = model != null ? model : new AzBakedModel(List.of());
    }
}

