/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.util.client;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.common.cache.object.GeoCube;
import mod.azure.azurelib.common.model.AzBone;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3532;
import net.minecraft.class_3673;
import net.minecraft.class_4587;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class RenderUtils {
    private static final Matrix4f TRANSLATE_MATRIX_CACHE = new Matrix4f();
    private static final Quaternionf X_QUATERNION_CACHE = new Quaternionf();
    private static final Quaternionf Y_QUATERNION_CACHE = new Quaternionf();
    private static final Quaternionf Z_QUATERNION_CACHE = new Quaternionf();

    public static void translateMatrixToBone(class_4587 poseStack, AzBone bone) {
        poseStack.method_46416(-bone.getPosX() / 16.0f, bone.getPosY() / 16.0f, bone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(class_4587 poseStack, AzBone bone) {
        float rotX = bone.getRotX();
        float rotY = bone.getRotY();
        float rotZ = bone.getRotZ();
        if (rotZ != 0.0f) {
            poseStack.method_22907(Z_QUATERNION_CACHE.rotationXYZ(0.0f, 0.0f, rotZ));
        }
        if (rotY != 0.0f) {
            poseStack.method_22907(Y_QUATERNION_CACHE.rotationXYZ(0.0f, rotY, 0.0f));
        }
        if (rotX != 0.0f) {
            poseStack.method_22907(X_QUATERNION_CACHE.rotationXYZ(rotX, 0.0f, 0.0f));
        }
    }

    public static void rotateMatrixAroundCube(class_4587 poseStack, GeoCube cube) {
        class_243 rotation = cube.rotation();
        if (rotation.method_10215() != 0.0) {
            Z_QUATERNION_CACHE.identity().rotateZ((float)rotation.method_10215());
            poseStack.method_22907(Z_QUATERNION_CACHE);
        }
        if (rotation.method_10214() != 0.0) {
            Y_QUATERNION_CACHE.identity().rotateY((float)rotation.method_10214());
            poseStack.method_22907(Y_QUATERNION_CACHE);
        }
        if (rotation.method_10216() != 0.0) {
            X_QUATERNION_CACHE.identity().rotateX((float)rotation.method_10216());
            poseStack.method_22907(X_QUATERNION_CACHE);
        }
    }

    public static void scaleMatrixForBone(class_4587 poseStack, AzBone bone) {
        poseStack.method_22905(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
    }

    public static void translateToPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(pivot.method_10216() / 16.0, pivot.method_10214() / 16.0, pivot.method_10215() / 16.0);
    }

    public static void translateToPivotPoint(class_4587 poseStack, AzBone bone) {
        poseStack.method_46416(bone.getPivotX() / 16.0f, bone.getPivotY() / 16.0f, bone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, GeoCube cube) {
        class_243 pivot = cube.pivot();
        poseStack.method_22904(-pivot.method_10216() / 16.0, -pivot.method_10214() / 16.0, -pivot.method_10215() / 16.0);
    }

    public static void translateAwayFromPivotPoint(class_4587 poseStack, AzBone bone) {
        poseStack.method_46416(-bone.getPivotX() / 16.0f, -bone.getPivotY() / 16.0f, -bone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(class_4587 poseStack, AzBone bone) {
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
    }

    public static void prepMatrixForBone(class_4587 poseStack, AzBone bone) {
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
    }

    public static Matrix4f invertAndMultiplyMatrices(Matrix4f baseMatrix, Matrix4f inputMatrix) {
        inputMatrix = new Matrix4f((Matrix4fc)inputMatrix);
        inputMatrix.invert();
        inputMatrix.mul((Matrix4fc)baseMatrix);
        return inputMatrix;
    }

    public static void faceRotation(class_4587 poseStack, class_1297 animatable, float partialTick) {
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_5982, (float)animatable.method_36454()) - 90.0f));
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)partialTick, (float)animatable.field_6004, (float)animatable.method_36455())));
    }

    public static Matrix4f translateMatrix(Matrix4f matrix, Vector3f vector) {
        TRANSLATE_MATRIX_CACHE.m30(vector.x).m31(vector.y).m32(vector.z);
        return matrix.add((Matrix4fc)TRANSLATE_MATRIX_CACHE);
    }

    @Nullable
    public static IntIntPair getTextureDimensions(class_2960 texture) {
        if (texture == null) {
            return null;
        }
        class_1044 originalTexture = null;
        class_310 mc = class_310.method_1551();
        try {
            originalTexture = (class_1044)mc.method_5385(() -> mc.method_1531().method_4619(texture)).get();
        }
        catch (Exception e) {
            AzureLib.LOGGER.warn("Failed to load image for id {}", (Object)texture);
            e.printStackTrace();
        }
        if (originalTexture == null) {
            return null;
        }
        class_1011 image = null;
        try {
            class_1011 class_10112;
            if (originalTexture instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)originalTexture;
                class_10112 = dynamicTexture.method_4525();
            } else {
                class_10112 = class_1011.method_4309((InputStream)((class_3298)mc.method_1478().method_14486(texture).get()).method_14482());
            }
            image = class_10112;
        }
        catch (Exception e) {
            AzureLib.LOGGER.error("Failed to read image for id {}", (Object)texture);
            e.printStackTrace();
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.method_4307(), (int)image.method_4323());
    }

    public static double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    public static double getCurrentTick() {
        return class_3673.method_15974() * 20.0;
    }

    public static float booleanToFloat(boolean input) {
        return input ? 1.0f : 0.0f;
    }

    public static class_243 arrayToVec(double[] array) {
        return new class_243(array[0], array[1], array[2]);
    }

    public static void matchModelPartRot(class_630 from, AzBone to) {
        to.updateRotation(-from.field_3654, -from.field_3675, from.field_3674);
    }

    public static void fixInvertedFlatCube(GeoCube cube, Vector3f normal) {
        if (normal.x() < 0.0f && (cube.size().method_10214() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (normal.y() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10215() == 0.0)) {
            normal.mul(1.0f, -1.0f, 1.0f);
        }
        if (normal.z() < 0.0f && (cube.size().method_10216() == 0.0 || cube.size().method_10214() == 0.0)) {
            normal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    public static float getDirectionAngle(class_2350 direction) {
        return switch (direction) {
            case class_2350.field_11035 -> 90.0f;
            case class_2350.field_11043 -> 270.0f;
            case class_2350.field_11034 -> 180.0f;
            default -> 0.0f;
        };
    }
}

