/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.mixins;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.io.Serializable;
import mod.azure.azurelib.common.internal.common.AzureLib;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererRegistry;
import mod.azure.azurelib.rewrite.render.item.AzItemRenderer;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererRegistry;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AbstractContainerMenu.class})
public class AbstractContainerMenuMixin_AzItemIDFix {
    @Unique
    private static final int DEFAULT_AZ_ID = -1;

    @WrapOperation(method={"doClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;copyWithCount(I)Lnet/minecraft/world/item/ItemStack;", ordinal=1)})
    public ItemStack azurelib$syncAzureIDWithRemote(ItemStack itemStack, int count, Operation<ItemStack> original) {
        ItemStack copyStack = (ItemStack)original.call(new Object[]{itemStack, count});
        AzItemRenderer itemRenderer = AzItemRendererRegistry.getOrNull(itemStack.getItem());
        AzArmorRenderer armorRenderer = AzArmorRendererRegistry.getOrNull(itemStack);
        if ((itemRenderer != null || armorRenderer != null) && copyStack.has(AzureLib.AZ_ID.get())) {
            copyStack.remove(AzureLib.AZ_ID.get());
        }
        return copyStack;
    }

    @WrapOperation(method={"synchronizeSlotToRemote"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;matches(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    public boolean azurelib$syncAzureIDWithRemote(ItemStack itemStack, ItemStack comparisonItemStack, Operation<Boolean> original) {
        return this.azurelib$compareStacksWithAzureID(itemStack, comparisonItemStack, original);
    }

    @WrapOperation(method={"triggerSlotListeners"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;matches(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z")})
    public boolean azurelib$detectSlotChangeWithAzureID(ItemStack itemStack, ItemStack comparisonItemStack, Operation<Boolean> original) {
        return this.azurelib$compareStacksWithAzureID(itemStack, comparisonItemStack, original);
    }

    @Unique
    private boolean azurelib$compareStacksWithAzureID(ItemStack itemStack, ItemStack comparisonItemStack, Operation<Boolean> original) {
        AzItemRenderer itemRenderer = AzItemRendererRegistry.getOrNull(itemStack.getItem());
        AzArmorRenderer armorRenderer = AzArmorRendererRegistry.getOrNull(itemStack);
        if (itemRenderer != null || armorRenderer != null) {
            return (Boolean)original.call(new Object[]{itemStack, comparisonItemStack}) != false && this.azurelib$stacksHaveMatchingAzID(itemStack, comparisonItemStack);
        }
        return (Boolean)original.call(new Object[]{itemStack, comparisonItemStack});
    }

    @Unique
    private boolean azurelib$stacksHaveMatchingAzID(ItemStack itemStack, ItemStack comparisonItemStack) {
        return ((Serializable)itemStack.getOrDefault(AzureLib.AZ_ID.get(), (Object)-1)).equals(comparisonItemStack.getOrDefault(AzureLib.AZ_ID.get(), (Object)-1));
    }
}

