/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network;

import java.util.Map;
import java.util.function.Supplier;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.AzureLibException;
import mod.azure.azurelib.config.ConfigHolder;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.network.IPacket;
import mod.azure.azurelib.network.Networking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class S2C_SendConfigData
implements IPacket<S2C_SendConfigData> {
    private final String config;

    S2C_SendConfigData() {
        this.config = null;
    }

    public S2C_SendConfigData(String config) {
        this.config = config;
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.config);
        ConfigHolder.getConfig(this.config).ifPresent(data -> {
            Map<String, ConfigValue<?>> serialized = data.getNetworkSerializedFields();
            buffer.writeInt(serialized.size());
            for (Map.Entry<String, ConfigValue<?>> entry : serialized.entrySet()) {
                String id = entry.getKey();
                ConfigValue<?> value = entry.getValue();
                TypeAdapter adapter = value.getAdapter();
                buffer.m_130070_(id);
                adapter.encodeToBuffer(value, buffer);
            }
        });
    }

    @Override
    public S2C_SendConfigData decode(FriendlyByteBuf buffer) {
        String config = buffer.m_130277_();
        int i = buffer.readInt();
        ConfigHolder.getConfig(config).ifPresent(data -> {
            Map<String, ConfigValue<?>> serialized = data.getNetworkSerializedFields();
            for (int j = 0; j < i; ++j) {
                String fieldId = buffer.m_130277_();
                ConfigValue<?> value = serialized.get(fieldId);
                if (value == null) {
                    AzureLib.LOGGER.fatal(Networking.MARKER, "Received unknown config value " + fieldId);
                    throw new AzureLibException("Unknown config field: " + fieldId);
                }
                this.setValue(value, buffer);
            }
        });
        return new S2C_SendConfigData(config);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().setPacketHandled(true);
    }

    private <V> void setValue(ConfigValue<V> value, FriendlyByteBuf buffer) {
        TypeAdapter adapter = value.getAdapter();
        Object v = adapter.decodeFromBuffer(value, buffer);
        value.set(v);
    }
}

