/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.rewrite.animation.impl.AzEntityAnimator;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzProvider;
import mod.azure.azurelib.rewrite.render.entity.AzEntityNameRenderUtil;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererPipeline;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AzEntityRenderer<T extends Entity>
extends EntityRenderer<T> {
    protected final AzEntityRendererConfig<T> config;
    protected final AzProvider<T> provider;
    protected final AzEntityRendererPipeline<T> rendererPipeline;
    @Nullable
    private AzEntityAnimator<T> reusedAzEntityAnimator;

    protected AzEntityRenderer(AzEntityRendererConfig<T> config, EntityRendererProvider.Context context) {
        super(context);
        this.config = config;
        this.provider = new AzProvider<Entity>(config::createAnimator, config::modelLocation);
        this.rendererPipeline = this.createPipeline(config);
    }

    public AzEntityRendererPipeline<T> createPipeline(AzEntityRendererConfig<T> config) {
        return new AzEntityRendererPipeline<T>(config, this);
    }

    @NotNull
    public final ResourceLocation getTextureLocation(@NotNull T animatable) {
        return this.config.textureLocation(animatable);
    }

    public void superRender(@NotNull T entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        super.render(entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
    }

    public void render(@NotNull T entity, float entityYaw, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight) {
        AzEntityAnimator cachedEntityAnimator = (AzEntityAnimator)this.provider.provideAnimator(entity);
        AzBakedModel azBakedModel = this.provider.provideBakedModel(entity);
        if (cachedEntityAnimator != null && azBakedModel != null) {
            cachedEntityAnimator.setActiveModel(azBakedModel);
        }
        this.reusedAzEntityAnimator = cachedEntityAnimator;
        this.rendererPipeline.render(poseStack, azBakedModel, entity, bufferSource, null, null, entityYaw, partialTick, packedLight);
    }

    protected float getShadowRadius(@NotNull T entity) {
        return this.config.shadowRadius(entity);
    }

    public boolean shouldShowName(@NotNull T entity) {
        return AzEntityNameRenderUtil.shouldShowName(this.entityRenderDispatcher, entity);
    }

    public int getBlockLightLevel(@NotNull T entity, @NotNull BlockPos pos) {
        return super.getBlockLightLevel(entity, pos);
    }

    public AzEntityAnimator<T> getAnimator() {
        return this.reusedAzEntityAnimator;
    }

    public AzEntityRendererConfig<T> config() {
        return this.config;
    }
}

