/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.cache.texture;

import com.mojang.blaze3d.pipeline.RenderCall;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.cache.texture.AutoGlowingTexture;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class AnimatableTexture
extends SimpleTexture {
    protected AnimationContents animationContents = null;
    protected boolean isAnimated = false;

    public AnimatableTexture(ResourceLocation location) {
        super(location);
    }

    public void m_6704_(ResourceManager manager) throws IOException {
        Resource resource = manager.m_215593_(this.f_118129_);
        AnimationMetadataSection animMeta = resource.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(null);
        if (animMeta != null) {
            NativeImage nativeImage;
            try (InputStream inputstream = resource.m_215507_();){
                nativeImage = NativeImage.m_85058_((InputStream)inputstream);
            }
            this.animationContents = new AnimationContents(nativeImage, animMeta);
            if (!this.animationContents.isValid()) {
                nativeImage.close();
                return;
            }
            this.isAnimated = true;
            AnimatableTexture.onRenderThread(() -> {
                TextureUtil.m_85287_((int)this.m_117963_(), (int)0, (int)((Integer)this.animationContents.frameSize.getFirst()), (int)((Integer)this.animationContents.frameSize.getSecond()));
                nativeImage.m_85003_(0, 0, 0, 0, 0, ((Integer)this.animationContents.frameSize.getFirst()).intValue(), ((Integer)this.animationContents.frameSize.getSecond()).intValue(), false, false);
            });
        }
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public static void setAndUpdate(ResourceLocation texturePath) {
        AnimatableTexture.setAndUpdate(texturePath, (int)RenderUtils.getCurrentTick());
    }

    public static void setAndUpdate(ResourceLocation texturePath, int frameTick) {
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(texturePath);
        if (texture instanceof AnimatableTexture) {
            AnimatableTexture animatableTexture = (AnimatableTexture)texture;
            animatableTexture.setAnimationFrame(frameTick);
        }
        RenderSystem.m_157453_((int)0, (int)texture.m_117963_());
    }

    public void setAnimationFrame(int tick) {
        if (this.animationContents != null) {
            this.animationContents.animatedTexture.setCurrentFrame(tick);
        }
    }

    private static void onRenderThread(RenderCall renderCall) {
        if (!RenderSystem.m_69586_()) {
            RenderSystem.m_69879_((RenderCall)renderCall);
        } else {
            renderCall.m_83909_();
        }
    }

    protected class AnimationContents {
        protected final Pair<Integer, Integer> frameSize;
        protected final Texture animatedTexture;

        private AnimationContents(NativeImage image, AnimationMetadataSection animMeta) {
            this.frameSize = animMeta.m_7117_(image.m_84982_(), image.m_85084_());
            this.animatedTexture = this.generateAnimatedTexture(image, animMeta);
        }

        private boolean isValid() {
            return this.animatedTexture != null;
        }

        private Texture generateAnimatedTexture(NativeImage image, AnimationMetadataSection animMeta) {
            if (!AzureLibUtil.isMultipleOf(image.m_84982_(), (Integer)this.frameSize.getFirst()) || !AzureLibUtil.isMultipleOf(image.m_85084_(), (Integer)this.frameSize.getSecond())) {
                AzureLib.LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", (Object)AnimatableTexture.this.f_118129_, (Object)image.m_84982_(), (Object)image.m_85084_(), this.frameSize.getFirst(), this.frameSize.getSecond());
                return null;
            }
            int columns = image.m_84982_() / (Integer)this.frameSize.getFirst();
            int rows = image.m_85084_() / (Integer)this.frameSize.getSecond();
            int frameCount = columns * rows;
            ObjectArrayList frames = new ObjectArrayList();
            animMeta.m_174861_((arg_0, arg_1) -> AnimationContents.lambda$generateAnimatedTexture$0((List)frames, arg_0, arg_1));
            if (frames.isEmpty()) {
                for (int frame = 0; frame < frameCount; ++frame) {
                    frames.add(new Frame(frame, animMeta.m_119030_()));
                }
            } else {
                int index = 0;
                IntOpenHashSet unusedFrames = new IntOpenHashSet();
                for (Frame frame : frames) {
                    if (frame.time <= 0) {
                        AzureLib.LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", (Object)AnimatableTexture.this.f_118129_, (Object)index, (Object)frame.time);
                        unusedFrames.add(frame.index);
                    } else if (frame.index < 0 || frame.index >= frameCount) {
                        AzureLib.LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", (Object)AnimatableTexture.this.f_118129_, (Object)index, (Object)frame.index);
                        unusedFrames.add(frame.index);
                    }
                    ++index;
                }
                if (!unusedFrames.isEmpty()) {
                    AzureLib.LOGGER.warn("Unused frames in sprite {}: {}", (Object)AnimatableTexture.this.f_118129_, (Object)Arrays.toString(unusedFrames.toArray()));
                }
            }
            return frames.size() <= 1 ? null : new Texture(image, frames.toArray(new Frame[0]), columns, animMeta.m_119036_());
        }

        private static /* synthetic */ void lambda$generateAnimatedTexture$0(List frames, int frame, int frameTime) {
            frames.add(new Frame(frame, frameTime));
        }

        public class Texture
        implements AutoCloseable {
            private final NativeImage baseImage;
            private final Frame[] frames;
            private final int framePanelSize;
            private final boolean interpolating;
            private final NativeImage interpolatedFrame;
            private final int totalFrameTime;
            protected int glowMaskTextureId = -1;
            protected NativeImage glowmaskImage = null;
            protected NativeImage glowmaskInterpolatedFrame = null;
            private int currentFrame;
            private int currentSubframe;

            private Texture(NativeImage baseImage, Frame[] frames, int framePanelSize, boolean interpolating) {
                this.baseImage = baseImage;
                this.frames = frames;
                this.framePanelSize = framePanelSize;
                this.interpolating = interpolating;
                this.interpolatedFrame = interpolating ? new NativeImage(((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false) : null;
                int time = 0;
                for (Frame frame : this.frames) {
                    time += frame.time;
                }
                this.totalFrameTime = time;
            }

            private int getFrameX(int frameIndex) {
                return frameIndex % this.framePanelSize;
            }

            private int getFrameY(int frameIndex) {
                return frameIndex / this.framePanelSize;
            }

            public void setGlowMaskTexture(AutoGlowingTexture texture, NativeImage baseImage, NativeImage glowMask) {
                this.glowMaskTextureId = texture.m_117963_();
                this.glowmaskImage = glowMask;
                this.glowmaskInterpolatedFrame = this.interpolating ? new NativeImage(((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false) : null;
                this.baseImage.m_85054_(baseImage);
            }

            public void setCurrentFrame(int ticks) {
                if ((ticks %= this.totalFrameTime) == this.currentSubframe) {
                    return;
                }
                int lastSubframe = this.currentSubframe;
                int lastFrame = this.currentFrame;
                int time = 0;
                for (Frame frame : this.frames) {
                    if (ticks >= (time += frame.time)) continue;
                    this.currentFrame = frame.index;
                    this.currentSubframe = ticks % frame.time;
                    break;
                }
                if (this.currentFrame != lastFrame && this.currentSubframe == 0) {
                    AnimatableTexture.onRenderThread(() -> {
                        TextureUtil.m_85287_((int)AnimatableTexture.this.m_117963_(), (int)0, (int)((Integer)AnimationContents.this.frameSize.getFirst()), (int)((Integer)AnimationContents.this.frameSize.getSecond()));
                        this.baseImage.m_85003_(0, 0, 0, this.getFrameX(this.currentFrame) * (Integer)AnimationContents.this.frameSize.getFirst(), this.getFrameY(this.currentFrame) * (Integer)AnimationContents.this.frameSize.getSecond(), ((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false, false);
                        if (this.glowmaskImage != null) {
                            TextureUtil.m_85287_((int)this.glowMaskTextureId, (int)0, (int)((Integer)AnimationContents.this.frameSize.getFirst()), (int)((Integer)AnimationContents.this.frameSize.getSecond()));
                            this.glowmaskImage.m_85003_(0, 0, 0, this.getFrameX(this.currentFrame) * (Integer)AnimationContents.this.frameSize.getFirst(), this.getFrameY(this.currentFrame) * (Integer)AnimationContents.this.frameSize.getSecond(), ((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false, false);
                        }
                    });
                } else if (this.currentSubframe != lastSubframe && this.interpolating) {
                    AnimatableTexture.onRenderThread(() -> {
                        this.generateInterpolatedFrame(AnimatableTexture.this.m_117963_(), this.baseImage, this.interpolatedFrame);
                        if (this.glowmaskImage != null) {
                            this.generateInterpolatedFrame(this.glowMaskTextureId, this.glowmaskImage, this.glowmaskInterpolatedFrame);
                        }
                    });
                }
            }

            private void generateInterpolatedFrame(int textureId, NativeImage image, NativeImage interpolatedFrame) {
                Frame frame = this.frames[this.currentFrame];
                double frameProgress = 1.0 - (double)this.currentSubframe / (double)frame.time();
                int nextFrameIndex = this.frames[(this.currentFrame + 1) % this.frames.length].index();
                if (frame.index() != nextFrameIndex) {
                    for (int y = 0; y < interpolatedFrame.m_85084_(); ++y) {
                        for (int x = 0; x < interpolatedFrame.m_84982_(); ++x) {
                            int prevFramePixel = this.getPixel(image, frame.index(), x, y);
                            int nextFramePixel = this.getPixel(image, nextFrameIndex, x, y);
                            int blendedRed = this.interpolate(frameProgress, prevFramePixel >> 16 & 0xFF, nextFramePixel >> 16 & 0xFF);
                            int blendedGreen = this.interpolate(frameProgress, prevFramePixel >> 8 & 0xFF, nextFramePixel >> 8 & 0xFF);
                            int blendedBlue = this.interpolate(frameProgress, prevFramePixel & 0xFF, nextFramePixel & 0xFF);
                            interpolatedFrame.m_84988_(x, y, prevFramePixel & 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue);
                        }
                    }
                    TextureUtil.m_85287_((int)textureId, (int)0, (int)((Integer)AnimationContents.this.frameSize.getFirst()), (int)((Integer)AnimationContents.this.frameSize.getSecond()));
                    interpolatedFrame.m_85003_(0, 0, 0, 0, 0, ((Integer)AnimationContents.this.frameSize.getFirst()).intValue(), ((Integer)AnimationContents.this.frameSize.getSecond()).intValue(), false, false);
                }
            }

            private int getPixel(NativeImage image, int frameIndex, int x, int y) {
                return image.m_84985_(x + this.getFrameX(frameIndex) * (Integer)AnimationContents.this.frameSize.getFirst(), y + this.getFrameY(frameIndex) * (Integer)AnimationContents.this.frameSize.getSecond());
            }

            private int interpolate(double frameProgress, double prevColour, double nextColour) {
                return (int)(frameProgress * prevColour + (1.0 - frameProgress) * nextColour);
            }

            @Override
            public void close() {
                this.baseImage.close();
                if (this.interpolatedFrame != null) {
                    this.interpolatedFrame.close();
                }
                if (this.glowmaskImage != null) {
                    this.glowmaskImage.close();
                }
                if (this.glowmaskInterpolatedFrame != null) {
                    this.glowmaskInterpolatedFrame.close();
                }
            }
        }

        private record Frame(int index, int time) {
        }
    }
}

