/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import mod.azure.azurelib.rewrite.animation.impl.AzItemAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.item.AzItemRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class AzItemModelRenderer
extends AzModelRenderer<ItemStack> {
    protected final AzItemRendererPipeline itemRendererPipeline;

    public AzItemModelRenderer(AzItemRendererPipeline itemRendererPipeline, AzLayerRenderer<ItemStack> layerRenderer) {
        super(itemRendererPipeline, layerRenderer);
        this.itemRendererPipeline = itemRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<ItemStack> context, boolean isReRender) {
        if (!isReRender) {
            ItemStack animatable = context.animatable();
            AzItemAnimator animator = this.itemRendererPipeline.getRenderer().getAnimator();
            if (animator != null) {
                this.handleAnimation(animator, animatable, context.partialTick());
            }
        }
        PoseStack poseStack = context.poseStack();
        this.itemRendererPipeline.modelRenderTranslations = new Matrix4f(poseStack.m_85850_().m_85861_());
        super.render(context, isReRender);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<ItemStack> context, AzBone bone, boolean isReRender) {
        if (bone.isTrackingMatrices()) {
            ItemStack animatable = context.animatable();
            PoseStack poseStack = context.poseStack();
            Matrix4f poseState = new Matrix4f(poseStack.m_85850_().m_85861_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.itemRenderTranslations);
            Matrix4f worldState = localMatrix.m_27658_();
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.itemRendererPipeline.modelRenderTranslations));
            worldState.m_27648_(new Vector3f(this.getRenderOffset(animatable, 1.0f)));
            bone.setWorldSpaceMatrix(worldState);
        }
        super.renderRecursively(context, bone, isReRender);
    }

    public Vec3 getRenderOffset(ItemStack itemStack, float f) {
        return Vec3.f_82478_;
    }
}

