/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.client;

import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import mod.azure.azurelib.config.ConfigUtils;
import mod.azure.azurelib.config.Configurable;
import mod.azure.azurelib.config.client.ClientErrors;
import mod.azure.azurelib.config.client.WidgetAdder;
import mod.azure.azurelib.config.client.screen.ArrayConfigScreen;
import mod.azure.azurelib.config.client.screen.ConfigScreen;
import mod.azure.azurelib.config.client.widget.BooleanWidget;
import mod.azure.azurelib.config.client.widget.ColorWidget;
import mod.azure.azurelib.config.client.widget.ConfigEntryWidget;
import mod.azure.azurelib.config.client.widget.EnumWidget;
import mod.azure.azurelib.config.validate.ValidationResult;
import mod.azure.azurelib.config.value.BooleanArrayValue;
import mod.azure.azurelib.config.value.BooleanValue;
import mod.azure.azurelib.config.value.CharValue;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.config.value.DecimalValue;
import mod.azure.azurelib.config.value.DoubleArrayValue;
import mod.azure.azurelib.config.value.DoubleValue;
import mod.azure.azurelib.config.value.EnumValue;
import mod.azure.azurelib.config.value.FloatArrayValue;
import mod.azure.azurelib.config.value.FloatValue;
import mod.azure.azurelib.config.value.IntArrayValue;
import mod.azure.azurelib.config.value.IntValue;
import mod.azure.azurelib.config.value.IntegerValue;
import mod.azure.azurelib.config.value.LongArrayValue;
import mod.azure.azurelib.config.value.LongValue;
import mod.azure.azurelib.config.value.ObjectValue;
import mod.azure.azurelib.config.value.StringArrayValue;
import mod.azure.azurelib.config.value.StringValue;
import mod.azure.azurelib.config.value.ValueData;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

@FunctionalInterface
public interface DisplayAdapter {
    public void placeWidgets(ConfigValue<?> var1, Field var2, WidgetAdder var3);

    public static DisplayAdapter booleanValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> new BooleanWidget(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, (BooleanValue)value));
    }

    public static DisplayAdapter characterValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            class_342 widget = new class_342(class_310.method_1551().field_1772, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, class_5244.field_39003);
            CharValue charValue = (CharValue)value;
            char character = ((Character)charValue.get()).charValue();
            widget.method_1852(String.valueOf(character));
            widget.method_1890(str -> str.length() <= 1);
            widget.method_1863(str -> {
                if (!str.isEmpty()) {
                    container.setOkStatus();
                    char toSet = str.charAt(0);
                    charValue.setWithValidationHandler(Character.valueOf(toSet), container);
                } else {
                    container.setValidationResult(ValidationResult.error(ClientErrors.CHAR_VALUE_EMPTY));
                }
            });
            ConfigUtils.adjustCharacterLimit(field, widget);
            return widget;
        });
    }

    public static DisplayAdapter integerValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            class_342 tfw = new class_342(class_310.method_1551().field_1772, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, class_5244.field_39003);
            IntValue intValue = (IntValue)value;
            int num = (Integer)intValue.get();
            tfw.method_1852(String.valueOf(num));
            tfw.method_1890(str -> ConfigUtils.containsOnlyValidCharacters(str, ConfigUtils.INTEGER_CHARS));
            tfw.method_1863(str -> {
                int n;
                if (!ConfigUtils.INTEGER_PATTERN.matcher((CharSequence)str).matches()) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                try {
                    n = Integer.parseInt(str);
                }
                catch (NumberFormatException e) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                IntegerValue.Range range = intValue.getRange();
                if (!range.isWithin(n)) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.outOfBounds(n, range)));
                    return;
                }
                container.setOkStatus();
                intValue.setWithValidationHandler(n, container);
            });
            ConfigUtils.adjustCharacterLimit(field, tfw);
            return tfw;
        });
    }

    public static DisplayAdapter longValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            class_342 tfw = new class_342(class_310.method_1551().field_1772, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, class_5244.field_39003);
            LongValue longValue = (LongValue)value;
            long num = (Long)longValue.get();
            tfw.method_1852(String.valueOf(num));
            tfw.method_1890(str -> ConfigUtils.containsOnlyValidCharacters(str, ConfigUtils.INTEGER_CHARS));
            tfw.method_1863(str -> {
                long n;
                if (!ConfigUtils.INTEGER_PATTERN.matcher((CharSequence)str).matches()) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                try {
                    n = Long.parseLong(str);
                }
                catch (NumberFormatException e) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                IntegerValue.Range range = longValue.getRange();
                if (!range.isWithin(n)) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.outOfBounds(n, range)));
                    return;
                }
                container.setOkStatus();
                longValue.setWithValidationHandler(n, container);
            });
            ConfigUtils.adjustCharacterLimit(field, tfw);
            return tfw;
        });
    }

    public static DisplayAdapter floatValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            class_342 tfw = new class_342(class_310.method_1551().field_1772, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, class_5244.field_39003);
            FloatValue floatValue = (FloatValue)value;
            DecimalFormat format = ConfigUtils.getDecimalFormat(field);
            float number = ((Float)floatValue.get()).floatValue();
            tfw.method_1852(format != null ? format.format(number) : String.valueOf(number));
            tfw.method_1890(str -> ConfigUtils.containsOnlyValidCharacters(str, ConfigUtils.DECIMAL_CHARS));
            tfw.method_1863(str -> {
                float n;
                if (!ConfigUtils.DECIMAL_PATTERN.matcher((CharSequence)str).matches()) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                try {
                    n = Float.parseFloat(str);
                }
                catch (NumberFormatException e) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                DecimalValue.Range range = floatValue.getRange();
                if (!range.isWithin(n)) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.outOfBounds(n, range)));
                    return;
                }
                container.setOkStatus();
                floatValue.setWithValidationHandler(Float.valueOf(n), container);
            });
            ConfigUtils.adjustCharacterLimit(field, tfw);
            return tfw;
        });
    }

    public static DisplayAdapter doubleValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            class_342 tfw = new class_342(class_310.method_1551().field_1772, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, class_5244.field_39003);
            DoubleValue doubleValue = (DoubleValue)value;
            DecimalFormat format = ConfigUtils.getDecimalFormat(field);
            double number = (Double)doubleValue.get();
            tfw.method_1852(format != null ? format.format(number) : String.valueOf(number));
            tfw.method_1890(str -> ConfigUtils.containsOnlyValidCharacters(str, ConfigUtils.DECIMAL_CHARS));
            tfw.method_1863(str -> {
                double n;
                if (!ConfigUtils.DECIMAL_PATTERN.matcher((CharSequence)str).matches()) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                try {
                    n = Double.parseDouble(str);
                }
                catch (NumberFormatException e) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.notANumber(str)));
                    return;
                }
                DecimalValue.Range range = doubleValue.getRange();
                if (!range.isWithin(n)) {
                    container.setValidationResult(ValidationResult.error(ClientErrors.outOfBounds(n, range)));
                    return;
                }
                container.setOkStatus();
                doubleValue.setWithValidationHandler(n, container);
            });
            ConfigUtils.adjustCharacterLimit(field, tfw);
            return tfw;
        });
    }

    public static DisplayAdapter stringValue() {
        return (value, field, container) -> {
            Configurable.Gui.ColorValue colorValue = field.getAnnotation(Configurable.Gui.ColorValue.class);
            StringValue strValue = (StringValue)value;
            class_342 widget = container.addConfigWidget((x, y, width, height, configId) -> {
                class_342 tfw = new class_342(class_310.method_1551().field_1772, DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, class_5244.field_39003);
                String val = (String)strValue.get();
                tfw.method_1852(val);
                tfw.method_1863(str -> {
                    Pattern pattern = strValue.getPattern();
                    if (pattern != null && !pattern.matcher((CharSequence)str).matches()) {
                        String errDescriptor = strValue.getErrorDescriptor();
                        class_5250 error = errDescriptor != null ? class_2561.method_43469((String)errDescriptor, (Object[])new Object[]{str, pattern}) : ClientErrors.invalidText(str, pattern);
                        container.setValidationResult(ValidationResult.error(error));
                        return;
                    }
                    container.setOkStatus();
                    strValue.setWithValidationHandler(str, container);
                });
                ConfigUtils.adjustCharacterLimit(field, tfw);
                return tfw;
            });
            if (colorValue != null) {
                container.addConfigWidget((x, y, width, height, configId) -> {
                    int left = DisplayAdapter.getValueX(x, width) - 25;
                    ColorWidget.GetSet<String> provider = ColorWidget.GetSet.of(() -> ((class_342)widget).method_1882(), arg_0 -> ((class_342)widget).method_1852(arg_0));
                    class_437 currentScreen = class_310.method_1551().field_1755;
                    return new ColorWidget(left, y, 20, 20, colorValue, provider, currentScreen);
                });
            }
        };
    }

    public static DisplayAdapter booleanArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            BooleanArrayValue arrayValue = (BooleanArrayValue)value;
            BiConsumer<Boolean, Integer> setCallback = (val, i) -> {
                boolean[] arr = (boolean[])arrayValue.get();
                arr[i.intValue()] = val;
                arrayValue.set(arr);
            };
            class_4185.class_4241 pressable = btn -> {
                class_310 client = class_310.method_1551();
                class_437 usedScreen = client.field_1755;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((boolean[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    boolean[] arr = (boolean[])arrayValue.get();
                    return new BooleanValue(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, Boolean.TYPE, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    boolean[] arr = (boolean[])arrayValue.get();
                    boolean[] expanded = new boolean[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = false;
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    boolean[] arr = (boolean[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new boolean[arr.length - 1]));
                });
                client.method_1507(screen);
            };
            return class_4185.method_46430((class_2561)ConfigEntryWidget.EDIT, (class_4185.class_4241)pressable).method_46433(DisplayAdapter.getValueX(x, width), y).method_46437(DisplayAdapter.getValueWidth(width), 20).method_46431();
        });
    }

    public static DisplayAdapter integerArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            IntArrayValue arrayValue = (IntArrayValue)value;
            BiConsumer<Integer, Integer> setCallback = (val, i) -> {
                int[] arr = (int[])arrayValue.get();
                arr[i.intValue()] = val;
                arrayValue.set(arr);
            };
            class_4185.class_4241 pressable = btn -> {
                class_310 client = class_310.method_1551();
                class_437 usedScreen = client.field_1755;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((int[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    int[] arr = (int[])arrayValue.get();
                    return new IntValue(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, Integer.TYPE, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    int[] arr = (int[])arrayValue.get();
                    int[] expanded = new int[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = Math.max((int)arrayValue.getRange().min(), 0);
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    int[] arr = (int[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new int[arr.length - 1]));
                });
                client.method_1507(screen);
            };
            return class_4185.method_46430((class_2561)ConfigEntryWidget.EDIT, (class_4185.class_4241)pressable).method_46433(DisplayAdapter.getValueX(x, width), y).method_46437(DisplayAdapter.getValueWidth(width), 20).method_46431();
        });
    }

    public static DisplayAdapter longArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            LongArrayValue arrayValue = (LongArrayValue)value;
            BiConsumer<Long, Integer> setCallback = (val, i) -> {
                long[] arr = (long[])arrayValue.get();
                arr[i.intValue()] = val;
                arrayValue.set(arr);
            };
            class_4185.class_4241 pressable = btn -> {
                class_310 client = class_310.method_1551();
                class_437 usedScreen = client.field_1755;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((long[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    long[] arr = (long[])arrayValue.get();
                    return new LongValue(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, Long.TYPE, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    long[] arr = (long[])arrayValue.get();
                    long[] expanded = new long[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = Math.max(arrayValue.getRange().min(), 0L);
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    long[] arr = (long[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new long[arr.length - 1]));
                });
                client.method_1507(screen);
            };
            return class_4185.method_46430((class_2561)ConfigEntryWidget.EDIT, (class_4185.class_4241)pressable).method_46433(DisplayAdapter.getValueX(x, width), y).method_46437(DisplayAdapter.getValueWidth(width), 20).method_46431();
        });
    }

    public static DisplayAdapter floatArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            FloatArrayValue arrayValue = (FloatArrayValue)value;
            BiConsumer<Float, Integer> setCallback = (val, i) -> {
                float[] arr = (float[])arrayValue.get();
                arr[i.intValue()] = val.floatValue();
                arrayValue.set(arr);
            };
            class_4185.class_4241 pressable = btn -> {
                class_310 client = class_310.method_1551();
                class_437 usedScreen = client.field_1755;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((float[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    float[] arr = (float[])arrayValue.get();
                    return new FloatValue(ValueData.of(id, Float.valueOf(arr[i]), ArrayConfigScreen.callbackCtx(field, Float.TYPE, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    float[] arr = (float[])arrayValue.get();
                    float[] expanded = new float[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = Math.max((float)arrayValue.getRange().min(), 0.0f);
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    float[] arr = (float[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new float[arr.length - 1]));
                });
                client.method_1507(screen);
            };
            return class_4185.method_46430((class_2561)ConfigEntryWidget.EDIT, (class_4185.class_4241)pressable).method_46433(DisplayAdapter.getValueX(x, width), y).method_46437(DisplayAdapter.getValueWidth(width), 20).method_46431();
        });
    }

    public static DisplayAdapter doubleArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            DoubleArrayValue arrayValue = (DoubleArrayValue)value;
            BiConsumer<Double, Integer> setCallback = (val, i) -> {
                double[] arr = (double[])arrayValue.get();
                arr[i.intValue()] = val;
                arrayValue.set(arr);
            };
            class_4185.class_4241 pressable = btn -> {
                class_310 client = class_310.method_1551();
                class_437 usedScreen = client.field_1755;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((double[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    double[] arr = (double[])arrayValue.get();
                    return new DoubleValue(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, Double.TYPE, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    double[] arr = (double[])arrayValue.get();
                    double[] expanded = new double[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = Math.max(arrayValue.getRange().min(), 0.0);
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    double[] arr = (double[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new double[arr.length - 1]));
                });
                client.method_1507(screen);
            };
            return class_4185.method_46430((class_2561)ConfigEntryWidget.EDIT, (class_4185.class_4241)pressable).method_46433(DisplayAdapter.getValueX(x, width), y).method_46437(DisplayAdapter.getValueWidth(width), 20).method_46431();
        });
    }

    public static DisplayAdapter stringArrayValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            StringArrayValue arrayValue = (StringArrayValue)value;
            BiConsumer<String, Integer> setCallback = (val, i) -> {
                String[] arr = (String[])arrayValue.get();
                arr[i.intValue()] = val;
                arrayValue.set(arr);
            };
            class_4185.class_4241 pressable = btn -> {
                class_310 client = class_310.method_1551();
                class_437 usedScreen = client.field_1755;
                ArrayConfigScreen screen = new ArrayConfigScreen(value.getId(), configId, arrayValue, usedScreen);
                screen.fetchSize(() -> ((String[])arrayValue.get()).length);
                screen.valueFactory((id, i) -> {
                    String[] arr = (String[])arrayValue.get();
                    return new StringValue(ValueData.of(id, arr[i], ArrayConfigScreen.callbackCtx(field, String.class, setCallback, i), new String[0]));
                });
                screen.addElement(() -> {
                    String[] arr = (String[])arrayValue.get();
                    String[] expanded = new String[arr.length + 1];
                    System.arraycopy(arr, 0, expanded, 0, arr.length);
                    expanded[arr.length] = arrayValue.getDefaultElementValue();
                    arrayValue.set(expanded);
                });
                screen.removeElement((i, trimmer) -> {
                    String[] arr = (String[])arrayValue.get();
                    arrayValue.set(trimmer.trim(i, arr, new String[arr.length - 1]));
                });
                client.method_1507(screen);
            };
            return class_4185.method_46430((class_2561)ConfigEntryWidget.EDIT, (class_4185.class_4241)pressable).method_46433(DisplayAdapter.getValueX(x, width), y).method_46437(DisplayAdapter.getValueWidth(width), 20).method_46431();
        });
    }

    public static DisplayAdapter enumValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> new EnumWidget(DisplayAdapter.getValueX(x, width), y, DisplayAdapter.getValueWidth(width), 20, (EnumValue)value));
    }

    public static DisplayAdapter objectValue() {
        return (value, field, container) -> container.addConfigWidget((x, y, width, height, configId) -> {
            ObjectValue objectValue = (ObjectValue)value;
            Map valueMap = (Map)objectValue.get();
            class_4185.class_4241 pressable = btn -> {
                class_310 client = class_310.method_1551();
                class_437 currentScreen = client.field_1755;
                ConfigScreen nestedConfigScreen = new ConfigScreen(container.getComponentName(), configId, valueMap, currentScreen);
                client.method_1507((class_437)nestedConfigScreen);
            };
            return class_4185.method_46430((class_2561)ConfigEntryWidget.EDIT, (class_4185.class_4241)pressable).method_46433(DisplayAdapter.getValueX(x, width), y).method_46437(DisplayAdapter.getValueWidth(width), 20).method_46431();
        });
    }

    public static int getValueX(int x, int width) {
        return x + width - DisplayAdapter.getValueWidth(width);
    }

    public static int getValueWidth(int width) {
        return width / 3;
    }
}

