/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.dispatch.command;

import java.util.function.UnaryOperator;
import mod.azure.azurelib.animation.dispatch.command.AzCommand;
import mod.azure.azurelib.animation.dispatch.command.AzCommandBuilder;
import mod.azure.azurelib.animation.dispatch.command.action.impl.root.AzRootCancelAllAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.root.AzRootPlayAnimationSequenceAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.root.AzRootSetAnimationSpeedAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.root.AzRootSetEasingTypeAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.root.AzRootSetFreezeTickAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.root.AzRootSetRepeatTimesAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.root.AzRootSetReverseAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.root.AzRootSetStartTickOffsetAction;
import mod.azure.azurelib.animation.dispatch.command.action.impl.root.AzRootSetTransitionSpeedAction;
import mod.azure.azurelib.animation.dispatch.command.sequence.AzAnimationSequence;
import mod.azure.azurelib.animation.dispatch.command.sequence.AzAnimationSequenceBuilder;
import mod.azure.azurelib.animation.easing.AzEasingType;

public class AzRootCommandBuilder
extends AzCommandBuilder {
    public AzRootCommandBuilder append(AzCommand command) {
        this.actions.addAll(command.actions());
        return this;
    }

    public AzRootCommandBuilder cancelAll() {
        this.actions.add(AzRootCancelAllAction.INSTANCE);
        return this;
    }

    public AzRootCommandBuilder setEasingType(AzEasingType easingType) {
        this.actions.add(new AzRootSetEasingTypeAction(easingType));
        return this;
    }

    public AzRootCommandBuilder setSpeed(float speed) {
        this.actions.add(new AzRootSetAnimationSpeedAction(speed));
        return this;
    }

    public AzRootCommandBuilder setTransitionSpeed(float transitionSpeed) {
        this.actions.add(new AzRootSetTransitionSpeedAction(transitionSpeed));
        return this;
    }

    public AzRootCommandBuilder setStartTickOffset(float tickOffset) {
        this.actions.add(new AzRootSetStartTickOffsetAction(tickOffset));
        return this;
    }

    public AzRootCommandBuilder setFreezeTickOffset(float freezeTickOffset) {
        this.actions.add(new AzRootSetFreezeTickAction(freezeTickOffset));
        return this;
    }

    public AzRootCommandBuilder setRepeatAmount(float repeatAmount) {
        this.actions.add(new AzRootSetRepeatTimesAction(repeatAmount));
        return this;
    }

    public AzRootCommandBuilder setReverseAnimation(boolean hasReverse) {
        this.actions.add(new AzRootSetReverseAction(hasReverse));
        return this;
    }

    public AzRootCommandBuilder playSequence(UnaryOperator<AzAnimationSequenceBuilder> builderUnaryOperator) {
        AzAnimationSequence sequence = ((AzAnimationSequenceBuilder)builderUnaryOperator.apply(new AzAnimationSequenceBuilder())).build();
        this.actions.add(new AzRootPlayAnimationSequenceAction(sequence));
        return this;
    }
}

