/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.animation.easing.bedrock_easings;

import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2d;

public record CubicBezierCurve(Vector2d startPoint, Vector2d controlPoint1, Vector2d controlPoint2, Vector2d endPoint) {
    private static final int BEZIER_WEIGHT = 3;

    public Vector2d getPoint(float progress) {
        return this.getPoint(progress, new Vector2d());
    }

    public Vector2d getPoint(float progress, Vector2d target) {
        if (progress < 0.0f || progress > 1.0f) {
            throw new IllegalArgumentException("Parameter t must be in the range [0, 1].");
        }
        if (target == null) {
            target = new Vector2d();
        }
        float oneMinusProgress = 1.0f - progress;
        float progressSquared = progress * progress;
        float oneMinusProgressSquared = oneMinusProgress * oneMinusProgress;
        float oneMinusProgressCubed = oneMinusProgressSquared * oneMinusProgress;
        float progressCubed = progressSquared * progress;
        target.x = (double)oneMinusProgressCubed * this.startPoint.x() + (double)(3.0f * oneMinusProgressSquared * progress) * this.controlPoint1.x() + (double)(3.0f * oneMinusProgress * progressSquared) * this.controlPoint2.x() + (double)progressCubed * this.endPoint.x();
        target.y = (double)oneMinusProgressCubed * this.startPoint.y() + (double)(3.0f * oneMinusProgressSquared * progress) * this.controlPoint1.y() + (double)(3.0f * oneMinusProgress * progressSquared) * this.controlPoint2.y() + (double)progressCubed * this.endPoint.y();
        return target;
    }

    public List<Vector2d> getPoints(int divisions) {
        if (divisions <= 0) {
            throw new IllegalArgumentException("Divisions must be greater than 0.");
        }
        ArrayList<Vector2d> points = new ArrayList<Vector2d>();
        for (int step = 0; step <= divisions; ++step) {
            points.add(this.getPoint((float)step / (float)divisions));
        }
        return points;
    }
}

