/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.util.codec;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

public class AzListStreamCodec<T> {
    private final Function<class_2540, T> decoder;
    private final BiConsumer<class_2540, T> encoder;

    public AzListStreamCodec(Function<class_2540, T> decoder, BiConsumer<class_2540, T> encoder) {
        this.decoder = decoder;
        this.encoder = encoder;
    }

    @NotNull
    public List<T> decode(class_2540 buf) {
        int size = buf.readByte();
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(this.decoder.apply(buf));
        }
        return list;
    }

    public void encode(class_2540 buf, List<T> elements) {
        buf.writeByte(elements.size());
        elements.forEach(element -> this.encoder.accept(buf, (class_2540)element));
    }
}

