/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.config.value;

import java.util.Objects;
import mod.azure.azurelib.config.adapter.TypeAdapter;
import mod.azure.azurelib.config.value.ConfigValue;
import mod.azure.azurelib.config.value.IDescriptionProvider;
import org.jetbrains.annotations.Nullable;

public final class ValueData<T>
implements IDescriptionProvider {
    private final String id;
    private final String[] tooltip;
    private final T defaultValue;
    private final TypeAdapter.AdapterContext context;
    private final Class<T> valueType;
    @Nullable
    private ConfigValue<?> parent;

    private ValueData(String id, String[] tooltip, T defaultValue, TypeAdapter.AdapterContext context) {
        this.id = id;
        this.tooltip = tooltip;
        this.defaultValue = defaultValue;
        this.context = context;
        this.valueType = defaultValue.getClass();
    }

    public static <V> ValueData<V> of(String id, V value, TypeAdapter.AdapterContext setter, String ... comments) {
        return new ValueData<V>(id, comments, Objects.requireNonNull(value), setter);
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String[] getDescription() {
        return this.tooltip;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setValueToMemory(Object value) {
        this.context.setFieldValue(value);
    }

    public void setParent(@Nullable ConfigValue<?> parent) {
        this.parent = parent;
    }

    @Nullable
    public ConfigValue<?> getParent() {
        return this.parent;
    }

    public TypeAdapter.AdapterContext getContext() {
        return this.context;
    }

    public Class<T> getValueType() {
        return this.valueType;
    }
}

