/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.network;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.function.BiConsumer;
import mod.azure.azurelib.AzureLib;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.network.AbstractPacket;
import mod.azure.azurelib.network.S2C_SendConfigData;
import mod.azure.azurelib.network.api.IClientPacket;
import mod.azure.azurelib.network.api.IPacket;
import mod.azure.azurelib.network.api.IPacketDecoder;
import mod.azure.azurelib.network.api.IPacketEncoder;
import mod.azure.azurelib.network.packet.AnimDataSyncPacket;
import mod.azure.azurelib.network.packet.AnimTriggerPacket;
import mod.azure.azurelib.network.packet.AzBlockEntityDispatchCommandPacket;
import mod.azure.azurelib.network.packet.AzEntityDispatchCommandPacket;
import mod.azure.azurelib.network.packet.AzItemStackDispatchCommandPacket;
import mod.azure.azurelib.network.packet.BlockEntityAnimDataSyncPacket;
import mod.azure.azurelib.network.packet.BlockEntityAnimTriggerPacket;
import mod.azure.azurelib.network.packet.EntityAnimDataSyncPacket;
import mod.azure.azurelib.network.packet.EntityAnimTriggerPacket;
import mod.azure.azurelib.network.packet.EntityPacketOnClient;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;

public final class AzureLibNetwork {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Network");
    public static final class_2960 ANIM_DATA_SYNC_PACKET_ID = new class_2960("azurelib", "anim_data_sync");
    public static final class_2960 ANIM_TRIGGER_SYNC_PACKET_ID = new class_2960("azurelib", "anim_trigger_sync");
    public static final class_2960 ENTITY_ANIM_DATA_SYNC_PACKET_ID = new class_2960("azurelib", "entity_anim_data_sync");
    public static final class_2960 ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID = new class_2960("azurelib", "entity_anim_trigger_sync");
    public static final class_2960 BLOCK_ENTITY_ANIM_DATA_SYNC_PACKET_ID = new class_2960("azurelib", "block_entity_anim_data_sync");
    public static final class_2960 BLOCK_ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID = new class_2960("azurelib", "block_entity_anim_trigger_sync");
    public static final class_2960 AZ_BLOCKENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID = new class_2960("azurelib", "az_blockentity_dispatch_command_sync");
    public static final class_2960 AZ_ENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID = new class_2960("azurelib", "az_entity_dispatch_command_sync");
    public static final class_2960 AZ_ITEM_STACK_DISPATCH_COMMAND_SYNC_PACKET_ID = new class_2960("azurelib", "az_item_stack_dispatch_command_sync");
    public static final class_2960 CUSTOM_ENTITY_ID = new class_2960("azurelib", "spawn_entity");
    public static final Map<String, GeoAnimatable> SYNCED_ANIMATABLES = new Object2ObjectOpenHashMap();

    public static void registerClientReceiverPackets() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ANIM_DATA_SYNC_PACKET_ID, AnimDataSyncPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ANIM_TRIGGER_SYNC_PACKET_ID, AnimTriggerPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ENTITY_ANIM_DATA_SYNC_PACKET_ID, EntityAnimDataSyncPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID, EntityAnimTriggerPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)BLOCK_ENTITY_ANIM_DATA_SYNC_PACKET_ID, BlockEntityAnimDataSyncPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)BLOCK_ENTITY_ANIM_TRIGGER_SYNC_PACKET_ID, BlockEntityAnimTriggerPacket::receive);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CUSTOM_ENTITY_ID, (client, handler, buf, responseSender) -> EntityPacketOnClient.onPacket(client, buf));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AZ_BLOCKENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID, (client, handler, buf, responseSender) -> AzBlockEntityDispatchCommandPacket.receive(buf));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AZ_ENTITY_DISPATCH_COMMAND_SYNC_PACKET_ID, (client, handler, buf, responseSender) -> AzEntityDispatchCommandPacket.receive(buf));
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AZ_ITEM_STACK_DISPATCH_COMMAND_SYNC_PACKET_ID, (client, handler, buf, responseSender) -> AzItemStackDispatchCommandPacket.receive(buf));
    }

    @Deprecated
    public static synchronized void registerSyncedAnimatable(GeoAnimatable animatable) {
        GeoAnimatable existing = SYNCED_ANIMATABLES.put(animatable.getClass().toString(), animatable);
        if (existing == null) {
            AzureLib.LOGGER.debug("Registered SyncedAnimatable for " + animatable.getClass());
        }
    }

    @Deprecated
    @Nullable
    public static GeoAnimatable getSyncedAnimatable(String className) {
        GeoAnimatable animatable = SYNCED_ANIMATABLES.get(className);
        if (animatable == null) {
            AzureLib.LOGGER.error("Attempting to retrieve unregistered synced animatable! (" + className + ")");
        }
        return animatable;
    }

    public static void sendWithCallback(AbstractPacket packet, IPacketCallback callback) {
        callback.onReadyToSend(packet);
    }

    public static void sendToTrackingEntityAndSelf(AbstractPacket packet, class_1297 entityToTrack) {
        for (class_3222 trackingPlayer : PlayerLookup.tracking((class_1297)entityToTrack)) {
            ServerPlayNetworking.send((class_3222)trackingPlayer, (class_2960)packet.getPacketID(), (class_2540)packet.encode());
        }
        if (entityToTrack instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entityToTrack;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)packet.getPacketID(), (class_2540)packet.encode());
        }
    }

    public static void sendToEntitiesTrackingChunk(AbstractPacket packet, class_3218 level, class_2338 blockPos) {
        for (class_3222 trackingPlayer : PlayerLookup.tracking((class_3218)level, (class_2338)blockPos)) {
            ServerPlayNetworking.send((class_3222)trackingPlayer, (class_2960)packet.getPacketID(), (class_2540)packet.encode());
        }
    }

    public static void sendClientPacket(class_3222 target, IClientPacket<?> packet) {
        AzureLibNetwork.dispatch(packet, (packetId, buffer) -> ServerPlayNetworking.send((class_3222)target, (class_2960)packetId, (class_2540)buffer));
    }

    private static <T> void dispatch(IPacket<T> packet, BiConsumer<class_2960, class_2540> dispatcher) {
        class_2960 packetId = packet.getPacketId();
        class_2540 buffer = new class_2540(Unpooled.buffer());
        IPacketEncoder<T> encoder = packet.getEncoder();
        T data = packet.getPacketData();
        encoder.encode(data, buffer);
        dispatcher.accept(packetId, buffer);
    }

    public static interface IPacketCallback {
        public void onReadyToSend(AbstractPacket var1);
    }

    public static final class PacketRegistry {
        public static void registerClient() {
            PacketRegistry.registerServer2ClientReceiver(S2C_SendConfigData.class);
        }

        @Environment(value=EnvType.CLIENT)
        private static <T> void registerServer2ClientReceiver(Class<? extends IClientPacket<T>> clientPacketClass) {
            try {
                IClientPacket packet = clientPacketClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                class_2960 packetId = packet.getPacketId();
                ClientPlayNetworking.registerGlobalReceiver((class_2960)packetId, (client, handler, buffer, responseDispatcher) -> {
                    IPacketDecoder decoder = packet.getDecoder();
                    Object packetData = decoder.decode(buffer);
                    client.execute(() -> packet.handleClientsidePacket(client, handler, packetData, responseDispatcher));
                });
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exc) {
                AzureLib.LOGGER.fatal(MARKER, "Couldn't instantiate new client packet from class {}, make sure it declares public default constructor", (Object)clientPacketClass.getSimpleName());
                throw new RuntimeException(exc);
            }
        }
    }
}

