/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_3270;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class GeoGlowingTextureMeta {
    public static final class_3270<GeoGlowingTextureMeta> DESERIALIZER = new class_3270<GeoGlowingTextureMeta>(){

        public String method_14420() {
            return "glowsections";
        }

        public GeoGlowingTextureMeta fromJson(JsonObject json) {
            List<Pixel> pixels = this.fromSections(class_3518.method_15292((JsonObject)json, (String)"sections", null));
            if (pixels.isEmpty()) {
                throw new JsonParseException("Empty glowlayer sections file. Must have at least one glow section!");
            }
            return new GeoGlowingTextureMeta(pixels);
        }

        private List<Pixel> fromSections(@Nullable JsonArray sectionsArray) {
            if (sectionsArray == null) {
                return List.of();
            }
            ObjectArrayList pixels = new ObjectArrayList();
            for (JsonElement element : sectionsArray) {
                if (!(element instanceof JsonObject)) {
                    throw new JsonParseException("Invalid glowsections json format, expected a JsonObject, found: " + element.getClass());
                }
                JsonObject obj = (JsonObject)element;
                int x1 = class_3518.method_15282((JsonObject)obj, (String)"x1", (int)class_3518.method_15282((JsonObject)obj, (String)"x", (int)0));
                int y1 = class_3518.method_15282((JsonObject)obj, (String)"y1", (int)class_3518.method_15282((JsonObject)obj, (String)"y", (int)0));
                int x2 = class_3518.method_15282((JsonObject)obj, (String)"x2", (int)(class_3518.method_15282((JsonObject)obj, (String)"w", (int)0) + x1));
                int y2 = class_3518.method_15282((JsonObject)obj, (String)"y2", (int)(class_3518.method_15282((JsonObject)obj, (String)"h", (int)0) + y1));
                int alpha = class_3518.method_15282((JsonObject)obj, (String)"alpha", (int)class_3518.method_15282((JsonObject)obj, (String)"a", (int)0));
                if (x1 + y1 + x2 + y2 == 0) {
                    throw new IllegalArgumentException("Invalid glowsections section object, section must be at least one pixel in size");
                }
                for (int x = x1; x <= x2; ++x) {
                    for (int y = y1; y <= y2; ++y) {
                        pixels.add(new Pixel(x, y, alpha));
                    }
                }
            }
            return pixels;
        }
    };
    private final List<Pixel> pixels;

    public GeoGlowingTextureMeta(List<Pixel> pixels) {
        this.pixels = pixels;
    }

    public static GeoGlowingTextureMeta fromExistingImage(class_1011 glowLayer) {
        ObjectArrayList pixels = new ObjectArrayList();
        for (int x = 0; x < glowLayer.method_4307(); ++x) {
            for (int y = 0; y < glowLayer.method_4323(); ++y) {
                int color = glowLayer.method_4315(x, y);
                if (color == 0) continue;
                pixels.add(new Pixel(x, y, class_1011.method_24030((int)color)));
            }
        }
        if (pixels.isEmpty()) {
            throw new IllegalStateException("Invalid glow layer texture provided, must have at least one pixel!");
        }
        return new GeoGlowingTextureMeta((List<Pixel>)pixels);
    }

    public void createImageMask(class_1011 originalImage, class_1011 newImage) {
        for (Pixel pixel : this.pixels) {
            int color = originalImage.method_4315(pixel.x, pixel.y);
            if (pixel.alpha > 0) {
                color = class_1011.method_24031((int)pixel.alpha, (int)class_1011.method_24035((int)color), (int)class_1011.method_24034((int)color), (int)class_1011.method_24033((int)color));
            }
            newImage.method_4305(pixel.x, pixel.y, color);
            originalImage.method_4305(pixel.x, pixel.y, 0);
        }
    }

    private record Pixel(int x, int y, int alpha) {
    }
}

