/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.block;

import com.mojang.blaze3d.systems.RenderSystem;
import mod.azure.azurelib.rewrite.animation.impl.AzBlockAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1921;
import net.minecraft.class_2318;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;

public class AzBlockEntityModelRenderer<T extends class_2586>
extends AzModelRenderer<T> {
    private final AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline;

    public AzBlockEntityModelRenderer(AzBlockEntityRendererPipeline<T> blockEntityRendererPipeline, AzLayerRenderer<T> layerRenderer) {
        super(blockEntityRendererPipeline, layerRenderer);
        this.blockEntityRendererPipeline = blockEntityRendererPipeline;
    }

    @Override
    public void render(AzRendererPipelineContext<T> context, boolean isReRender) {
        class_2586 entity = (class_2586)context.animatable();
        class_4587 poseStack = context.poseStack();
        if (!isReRender) {
            poseStack.method_22904(0.5, 0.0, 0.5);
            this.rotateBlock(this.getFacing(entity), poseStack);
            AzBlockAnimator<class_2586> animator = this.blockEntityRendererPipeline.getRenderer().getAnimator();
            if (animator != null) {
                animator.animate(entity, context.partialTick());
            }
        }
        this.blockEntityRendererPipeline.modelRenderTranslations = new class_1159(poseStack.method_23760().method_23761());
        class_2960 textureLocation = this.blockEntityRendererPipeline.config().textureLocation(entity);
        RenderSystem.setShaderTexture((int)0, (class_2960)textureLocation);
        super.render(context, isReRender);
    }

    @Override
    public void renderRecursively(AzRendererPipelineContext<T> context, AzBone bone, boolean isReRender) {
        class_4588 buffer = context.vertexConsumer();
        class_4597 bufferSource = context.multiBufferSource();
        class_2586 entity = (class_2586)context.animatable();
        class_4587 poseStack = context.poseStack();
        class_1921 renderType = context.renderType();
        poseStack.method_22903();
        RenderUtils.translateMatrixToBone(poseStack, bone);
        RenderUtils.translateToPivotPoint(poseStack, bone);
        RenderUtils.rotateMatrixAroundBone(poseStack, bone);
        RenderUtils.scaleMatrixForBone(poseStack, bone);
        if (bone.isTrackingMatrices()) {
            class_1159 poseState = new class_1159(poseStack.method_23760().method_23761());
            class_1159 localMatrix = RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.entityRenderTranslations);
            class_2338 pos = entity.method_11016();
            class_1159 worldState = new class_1159(localMatrix);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices(poseState, this.blockEntityRendererPipeline.modelRenderTranslations));
            bone.setLocalSpaceMatrix(localMatrix);
            worldState.method_22671(new class_1160((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260()));
            bone.setWorldSpaceMatrix(worldState);
        }
        RenderUtils.translateAwayFromPivotPoint(poseStack, bone);
        if (!isReRender && buffer instanceof class_287) {
            class_287 builder = (class_287)buffer;
            if (!builder.field_1556) {
                context.setVertexConsumer(bufferSource.getBuffer(renderType));
            }
        }
        this.renderCubesOfBone(context, bone);
        if (!isReRender) {
            this.layerRenderer.applyRenderLayersForBone(context, bone);
        }
        this.renderChildBones(context, bone, isReRender);
        poseStack.method_22909();
    }

    protected class_2350 getFacing(T block) {
        class_2680 blockState = block.method_11010();
        if (blockState.method_28498((class_2769)class_2383.field_11177)) {
            return (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        }
        if (blockState.method_28498((class_2769)class_2318.field_10927)) {
            return (class_2350)blockState.method_11654((class_2769)class_2318.field_10927);
        }
        return class_2350.field_11043;
    }

    protected void rotateBlock(class_2350 facing, class_4587 poseStack) {
        switch (facing) {
            case field_11035: {
                poseStack.method_22907(class_1160.field_20705.method_23214(180.0f));
                break;
            }
            case field_11039: {
                poseStack.method_22907(class_1160.field_20705.method_23214(90.0f));
                break;
            }
            case field_11043: {
                poseStack.method_22907(class_1160.field_20705.method_23214(0.0f));
                break;
            }
            case field_11034: {
                poseStack.method_22907(class_1160.field_20705.method_23214(270.0f));
                break;
            }
            case field_11036: {
                poseStack.method_22907(class_1160.field_20703.method_23214(90.0f));
                break;
            }
            case field_11033: {
                poseStack.method_22907(class_1160.field_20702.method_23214(90.0f));
            }
        }
    }
}

