/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.codec;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.phys.AABB;
import sirttas.dpanvil.api.codec.CodecHelper;

public class Codecs {
    public static final Codec<Pattern> PATTERN = Codec.STRING.xmap(Pattern::compile, Pattern::pattern);
    public static final Codec<EquipmentSlot> EQUIPMENT_SLOT_TYPE = Codec.STRING.xmap(EquipmentSlot::byName, EquipmentSlot::getName);
    public static final Codec<Integer> HEX_COLOR = Codec.STRING.comapFlatMap(s -> {
        if (s.startsWith("#")) {
            return DataResult.success((Object)Integer.parseInt(s.substring(1), 16));
        }
        return DataResult.error(() -> "Couldn't parse color: '" + s + "'");
    }, i -> String.format("#%06X", i));
    public static final Codec<Integer> RGB_COLOR = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("r").forGetter(i -> i >> 16 & 0xFF), (App)Codec.INT.fieldOf("g").forGetter(i -> i >> 8 & 0xFF), (App)Codec.INT.fieldOf("b").forGetter(i -> i & 0xFF)).apply((Applicative)builder, (r, g, b) -> (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF));
    public static final Codec<Integer> COLOR = Codec.either((Codec)Codec.INT, (Codec)Codec.either(HEX_COLOR, RGB_COLOR).xmap(e -> (Integer)e.map(Function.identity(), Function.identity()), Either::left)).xmap(e -> (Integer)e.map(Function.identity(), Function.identity()), Either::left);
    public static final Codec<Multimap<Holder<Attribute>, AttributeModifier>> ATTRIBUTE_MULTIMAP = CodecHelper.multiMapCodec(BuiltInRegistries.ATTRIBUTE.holderByNameCodec(), AttributeModifier.CODEC);
    public static final Codec<AABB> AABB = Codec.DOUBLE.listOf().comapFlatMap(list -> Util.fixedSize((List)list, (int)6).map(doubles -> new AABB(((Double)doubles.getFirst()).doubleValue(), ((Double)doubles.get(1)).doubleValue(), ((Double)doubles.get(2)).doubleValue(), ((Double)doubles.get(3)).doubleValue(), ((Double)doubles.get(4)).doubleValue(), ((Double)doubles.get(5)).doubleValue())), aabb -> List.of(Double.valueOf(aabb.minX), Double.valueOf(aabb.minY), Double.valueOf(aabb.minZ), Double.valueOf(aabb.maxX), Double.valueOf(aabb.maxY), Double.valueOf(aabb.maxZ)));

    public static <T> Codec<ResourceKey<T>> keyCodec(ResourceKey<Registry<T>> registryKey) {
        return ResourceLocation.CODEC.xmap(l -> ResourceKey.create((ResourceKey)registryKey, (ResourceLocation)l), ResourceKey::location);
    }

    private Codecs() {
    }
}

