/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.data.preprocessor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import sirttas.dpanvil.api.DPAnvilNames;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.preprocessor.DataPreprocessor;
import sirttas.dpanvil.api.json.merger.DeepJsonMerger;
import sirttas.dpanvil.api.json.merger.JsonMerger;

public class InheritanceDataPreprocessor
implements DataPreprocessor {
    private static final String PARENT_TAG_NAME = DPAnvilNames.ResourceLocations.PARENT.toString();
    private final JsonMerger jsonMerger;

    public InheritanceDataPreprocessor() {
        this(DeepJsonMerger.INSTANCE);
    }

    public InheritanceDataPreprocessor(JsonMerger jsonMerger) {
        this.jsonMerger = jsonMerger;
    }

    @Override
    public List<JsonElement> preprocess(DataPreprocessor.Context context, List<JsonElement> source) {
        return source.stream().map(element -> this.preprocess(context, (JsonElement)element)).toList();
    }

    private JsonElement preprocess(DataPreprocessor.Context context, JsonElement element) {
        if (!element.isJsonObject()) {
            throw new IllegalArgumentException("Inheritance can only be applied to json objects.");
        }
        JsonObject jsonObject = element.getAsJsonObject();
        if (jsonObject.has(PARENT_TAG_NAME)) {
            ResourceLocation parentId = ResourceLocation.parse((String)jsonObject.get(PARENT_TAG_NAME).getAsString());
            JsonObject parentElements = context.getProcessed(parentId).stream().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject).findFirst().orElse(null);
            if (parentElements != null) {
                return this.jsonMerger.merge((JsonElement)parentElements, (JsonElement)jsonObject);
            }
            DataPackAnvilApi.LOGGER.error("Couldn't find parent {}.", (Object)parentId);
        }
        return jsonObject;
    }
}

