/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.json.merger;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;
import sirttas.dpanvil.api.json.merger.JsonMerger;

public class ForeachJsonMerger
implements JsonMerger {
    private final JsonMerger valueMerger;

    public ForeachJsonMerger(JsonMerger valueMerger) {
        this.valueMerger = valueMerger;
    }

    @Override
    public JsonElement merge(JsonElement jsonElement1, JsonElement jsonElement2) {
        if (jsonElement1 == null) {
            return jsonElement2;
        }
        if (jsonElement2 == null) {
            return jsonElement1;
        }
        if (jsonElement1.equals(jsonElement2)) {
            return jsonElement1;
        }
        if (jsonElement1.isJsonObject() && jsonElement2.isJsonObject()) {
            return this.mergeObjects(jsonElement1.getAsJsonObject(), jsonElement2.getAsJsonObject());
        }
        return jsonElement2;
    }

    private JsonElement mergeObjects(JsonObject jsonObject1, JsonObject jsonObject2) {
        JsonObject result = new JsonObject();
        Sets.SetView keys = Sets.union((Set)jsonObject1.keySet(), (Set)jsonObject2.keySet());
        for (String key : keys) {
            JsonElement value1 = jsonObject1.get(key);
            JsonElement value2 = jsonObject2.get(key);
            if (value1 == null) {
                result.add(key, value2);
                continue;
            }
            if (value2 == null) {
                result.add(key, value1);
                continue;
            }
            if (value1.equals(value2)) {
                result.add(key, value1);
                continue;
            }
            result.add(key, this.valueMerger.merge(value1, value2));
        }
        return result;
    }
}

