/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.logical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateTooltipHelper;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.logical.AnyBlockPredicate;
import sirttas.dpanvil.api.predicate.block.logical.NoneBlockPredicate;

public record NotBlockPredicate(IBlockPosPredicate predicate) implements IBlockPosPredicate
{
    public static final String NAME = "not";
    public static final MapCodec<NotBlockPredicate> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IBlockPosPredicate.CODEC.fieldOf("value").forGetter(NotBlockPredicate::predicate)).apply((Applicative)builder, NotBlockPredicate::new));

    @Override
    public boolean test(@Nonnull LevelReader level, @Nonnull BlockPos pos, @Nullable Direction direction) {
        return !this.predicate.test(level, pos, direction);
    }

    public BlockPosPredicateType<NotBlockPredicate> getType() {
        return (BlockPosPredicateType)BlockPosPredicateType.NOT.get();
    }

    @Override
    public IBlockPosPredicate not() {
        return this.predicate;
    }

    @Override
    public IBlockPosPredicate simplify() {
        IBlockPosPredicate simplified = this.predicate.simplify();
        if (simplified instanceof NotBlockPredicate) {
            NotBlockPredicate notBlockPredicate = (NotBlockPredicate)simplified;
            return notBlockPredicate.predicate;
        }
        if (simplified instanceof AnyBlockPredicate) {
            return IBlockPosPredicate.none();
        }
        if (simplified instanceof NoneBlockPredicate) {
            return IBlockPosPredicate.any();
        }
        return IBlockPosPredicate.super.simplify();
    }

    @Override
    @Nonnull
    public List<Component> getTooltip() {
        return BlockPosPredicateTooltipHelper.not(this.predicate, IBlockPosPredicate::getTooltip);
    }
}

