/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.data.preprocessor;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.neoforged.neoforge.common.conditions.ICondition;
import sirttas.dpanvil.api.DPAnvilNames;
import sirttas.dpanvil.api.codec.CodecHelper;
import sirttas.dpanvil.api.data.preprocessor.DataPreprocessor;

public class NeoForgeConditionsPreprocessor
implements DataPreprocessor {
    private static final String CONDITIONS_TAG_NAME = DPAnvilNames.ResourceLocations.NEOFORGE_CONDITIONS.toString();

    public static <O> RecordCodecBuilder<O, List<ICondition>> fieldOf(Function<O, List<ICondition>> getter) {
        return ICondition.LIST_CODEC.optionalFieldOf(CONDITIONS_TAG_NAME, List.of()).forGetter(getter);
    }

    @Override
    public List<JsonElement> preprocess(DataPreprocessor.Context context, List<JsonElement> source) {
        return source.stream().filter(jsonElement -> this.testNeoforgeConditions(context, (JsonElement)jsonElement)).toList();
    }

    private boolean testNeoforgeConditions(DataPreprocessor.Context context, JsonElement jsonElement) {
        if (jsonElement == null) {
            return false;
        }
        if (!jsonElement.isJsonObject()) {
            return true;
        }
        if (jsonElement.getAsJsonObject().has(CONDITIONS_TAG_NAME)) {
            List conditions = (List)CodecHelper.decode(ICondition.LIST_CODEC, context.getRegistryLookup().createSerializationContext((DynamicOps)JsonOps.INSTANCE), jsonElement.getAsJsonObject().get(CONDITIONS_TAG_NAME));
            return conditions.isEmpty() || conditions.stream().allMatch(c -> c.test(context.getConditionContext()));
        }
        return true;
    }
}

