/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.json.merger;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sirttas.dpanvil.api.json.merger.DeepJsonMerger;
import sirttas.dpanvil.api.json.merger.JsonMerger;

public class JsonObjectMerger
implements JsonMerger {
    private final Map<String, JsonMerger> mergerMap;

    private JsonObjectMerger(Map<String, JsonMerger> mergerMap) {
        this.mergerMap = mergerMap;
    }

    @Override
    public JsonElement merge(JsonElement jsonElement1, JsonElement jsonElement2) {
        if (!jsonElement1.isJsonObject() || !jsonElement2.isJsonObject()) {
            throw new IllegalArgumentException("Both elements must be JsonObjects");
        }
        JsonObject result = new JsonObject();
        JsonObject jsonObject1 = jsonElement1.getAsJsonObject();
        JsonObject jsonObject2 = jsonElement2.getAsJsonObject();
        Sets.SetView keys = Sets.union((Set)jsonObject1.keySet(), (Set)jsonObject2.keySet());
        for (String key : keys) {
            JsonElement value1 = jsonObject1.get(key);
            JsonElement value2 = jsonObject2.get(key);
            if (value1 == null) {
                result.add(key, value2);
                continue;
            }
            if (value2 == null) {
                result.add(key, value1);
                continue;
            }
            if (value1.equals(value2)) {
                result.add(key, value1);
                continue;
            }
            JsonMerger merger = this.mergerMap.getOrDefault(key, DeepJsonMerger.INSTANCE);
            result.add(key, merger.merge(value1, value2));
        }
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, JsonMerger> mergerMap = new HashMap<String, JsonMerger>();

        public Builder with(String key, JsonMerger merger) {
            this.mergerMap.put(key, merger);
            return this;
        }

        public JsonObjectMerger build() {
            return new JsonObjectMerger(this.mergerMap);
        }
    }
}

