/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.api.predicate.block.match;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateTooltipHelper;
import sirttas.dpanvil.api.predicate.block.BlockPosPredicateType;
import sirttas.dpanvil.api.predicate.block.IBlockPosPredicate;
import sirttas.dpanvil.api.predicate.block.IBlockStatePredicate;
import sirttas.dpanvil.api.predicate.block.match.MatchBlockPredicate;

public record MatchBlocksPredicate(List<Block> blocks) implements IBlockStatePredicate
{
    public static final String NAME = "blocks";
    public static final MapCodec<MatchBlocksPredicate> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BuiltInRegistries.BLOCK.byNameCodec().listOf().fieldOf(NAME).forGetter(MatchBlocksPredicate::blocks)).apply((Applicative)builder, MatchBlocksPredicate::new));

    public MatchBlocksPredicate(Block ... blocks) {
        this((List<Block>)ImmutableList.copyOf((Object[])blocks));
    }

    public MatchBlocksPredicate(Iterable<Block> blocks) {
        this((List<Block>)ImmutableList.copyOf(blocks));
    }

    @Override
    public boolean test(BlockState state) {
        return this.blocks.stream().anyMatch(arg_0 -> ((BlockState)state).is(arg_0));
    }

    public BlockPosPredicateType<MatchBlocksPredicate> getType() {
        return (BlockPosPredicateType)BlockPosPredicateType.MATCH_BLOCKS.get();
    }

    @Override
    public IBlockPosPredicate simplify() {
        if (this.blocks.isEmpty()) {
            return IBlockPosPredicate.none();
        }
        if (this.blocks.size() == 1) {
            return new MatchBlockPredicate(this.blocks.getFirst());
        }
        return new MatchBlocksPredicate(this.blocks.stream().distinct().toList());
    }

    @Override
    @Nonnull
    public List<Component> getTooltip() {
        return BlockPosPredicateTooltipHelper.or(this.blocks, b -> List.of(b.getName()));
    }
}

