/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.apache.logging.log4j.util.Supplier;
import org.jetbrains.annotations.NotNull;
import sirttas.dpanvil.DataPackAnvil;
import sirttas.dpanvil.api.DPAnvilNames;
import sirttas.dpanvil.api.DataPackAnvilApi;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.data.preprocessor.DataPreprocessor;
import sirttas.dpanvil.api.event.DataManagerReloadEvent;
import sirttas.dpanvil.data.DataManagerWrapper;
import sirttas.dpanvil.registry.RegistryListener;

public class DataManager<T>
extends SimplePreparableReloadListener<Map<ResourceLocation, List<JsonElement>>>
implements IDataManager<T> {
    private static final Gson GSON = new GsonBuilder().create();
    private final Class<T> contentType;
    private final Function<ResourceLocation, T> defaultValueFactory;
    private final Map<ResourceLocation, Holder.Reference<T>> references;
    private final String folder;
    private final BiConsumer<T, ResourceLocation> idSetter;
    private final ResourceKey<IDataManager<T>> key;
    private final List<DataPreprocessor> preprocessors;
    private Map<ResourceLocation, T> data;
    private Map<ResourceLocation, T> remappedData;
    private PreprocessorContext preprocessorContext;

    public DataManager(ResourceKey<IDataManager<T>> key, Class<T> contentType, String folder, Function<ResourceLocation, T> defaultValueFactory, BiConsumer<T, ResourceLocation> idSetter, List<DataPreprocessor> preprocessors) {
        this.key = key;
        this.contentType = contentType;
        this.defaultValueFactory = defaultValueFactory;
        this.idSetter = idSetter;
        this.folder = folder;
        this.data = ImmutableBiMap.of();
        this.references = new HashMap<ResourceLocation, Holder.Reference<T>>();
        this.remappedData = Collections.emptyMap();
        this.preprocessors = preprocessors;
        if (preprocessors.isEmpty()) {
            DataPackAnvilApi.LOGGER.warn("No preprocessors provided for {}. This may lead to unexpected behavior.", (Object)key.location());
        }
        this.preprocessorContext = new PreprocessorContext(Map.of());
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, T> getData() {
        return this.data;
    }

    @Override
    public ResourceKey<IDataManager<T>> getKey() {
        return this.key;
    }

    @Override
    public void setData(@Nonnull Map<ResourceLocation, T> map) {
        map.forEach((loc, value) -> this.idSetter.accept(value, (ResourceLocation)loc));
        if (this != DataPackAnvilApi.REMAP_KEYS_MANAGER) {
            HashMap remap = new HashMap();
            DataPackAnvilApi.REMAP_KEYS_MANAGER.get(this.key.location()).keys().forEach((k, v) -> {
                Object value = map.get(v);
                if (value != null) {
                    remap.put(k, value);
                }
            });
            this.remappedData = Map.copyOf(remap);
        } else {
            this.remappedData = Collections.emptyMap();
        }
        try {
            this.data = ImmutableBiMap.copyOf(map);
        }
        catch (IllegalArgumentException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> this.key;
            supplierArray[1] = e::getMessage;
            DataPackAnvilApi.LOGGER.warn("Manager {} has duplicate values ({}), by key search will be slower and may be inconsistent", supplierArray);
            this.data = Map.copyOf(map);
        }
        this.rebindReferences();
        DataPackAnvilApi.LOGGER.info("Loaded {} {}", (Object)this.data.size(), this.key);
        NeoForge.EVENT_BUS.post((Event)new DataManagerReloadEvent(this));
    }

    @Override
    @Nonnull
    public Class<T> getContentType() {
        return this.contentType;
    }

    @Override
    @Nonnull
    public ResourceLocation getId(T value) {
        if (this.data instanceof BiMap) {
            return (ResourceLocation)((BiMap)this.data).inverse().getOrDefault(value, (Object)DPAnvilNames.ResourceLocations.NONE);
        }
        for (Map.Entry<ResourceLocation, T> entry : this.data.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return entry.getKey();
        }
        return DPAnvilNames.ResourceLocations.NONE;
    }

    @Override
    public T get(@Nonnull ResourceLocation id) {
        T value = this.data.get(id);
        if (value != null) {
            return value;
        }
        value = this.remappedData.get(id);
        if (value != null) {
            return value;
        }
        return this.defaultValueFactory.apply(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public Holder<T> getOrCreateHolder(@Nonnull ResourceKey<T> key) {
        Map<ResourceLocation, Holder.Reference<T>> map = this.references;
        synchronized (map) {
            return (Holder)this.references.computeIfAbsent(key.location(), resourceLocation -> {
                Holder.Reference reference = Holder.Reference.createStandAlone((HolderOwner)this, (ResourceKey)key);
                this.bindReference((Holder.Reference<T>)reference, (ResourceLocation)resourceLocation);
                return reference;
            });
        }
    }

    @Override
    @Nonnull
    public Holder<T> getOrCreateHolder(@Nonnull ResourceLocation key) {
        return this.getOrCreateHolder(this.createKey(key));
    }

    @Override
    @Nonnull
    public String getFolder() {
        return this.folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebindReferences() {
        Map<ResourceLocation, Holder.Reference<T>> map = this.references;
        synchronized (map) {
            this.references.values().forEach(r -> this.bindReference((Holder.Reference<T>)r, r.key().location()));
        }
    }

    private void bindReference(Holder.Reference<T> reference, ResourceLocation resourceLocation) {
        T value = this.get(resourceLocation);
        if (value == null) {
            DataPackAnvilApi.LOGGER.debug("Could not bind reference for {} in manager {}", (Object)resourceLocation, this.key);
            return;
        }
        reference.bindValue(value);
        if (!reference.isBound()) {
            DataPackAnvilApi.LOGGER.warn("Failed to bind reference {} for manager {}", (Object)resourceLocation, this.key);
        }
    }

    @Nonnull
    private ResourceKey<T> createKey(ResourceLocation l) {
        return IDataManager.createKey(this.key, l);
    }

    public String toString() {
        return this.key != null ? this.key.toString() : this.folder;
    }

    public JsonElement preprocess(JsonElement input) {
        return this.preprocessorContext.processAnonymous(input);
    }

    @NotNull
    protected Map<ResourceLocation, List<JsonElement>> prepare(ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap<ResourceLocation, List<JsonElement>> map = new HashMap<ResourceLocation, List<JsonElement>>();
        int i = this.folder.length() + 1;
        for (Map.Entry entry : resourceManager.listResourceStacks(this.folder, file -> file.getPath().endsWith(".json")).entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            String path = resourceLocation.getPath();
            ResourceLocation resourceId = ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)path.substring(i, path.length() - 5));
            ArrayList<JsonElement> list = new ArrayList<JsonElement>();
            for (Resource resource : (List)entry.getValue()) {
                JsonElement element = DataManager.getElement(resourceLocation, resourceId, resource);
                if (element == null) continue;
                list.add(element);
            }
            map.put(resourceId, list);
        }
        this.preprocessorContext = new PreprocessorContext(map);
        return map;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonElement getElement(ResourceLocation resourcelocation, ResourceLocation resourceId, Resource resource) {
        try (InputStream inputstream = resource.open();){
            JsonElement jsonElement;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonElement.class);
            }
            return jsonElement;
        }
        catch (JsonParseException | IOException | IllegalArgumentException e) {
            DataPackAnvilApi.LOGGER.error("Couldn't parse data file {} from {}", (Object)resourceId, (Object)resourcelocation, (Object)e);
            return null;
        }
    }

    protected void apply(@NotNull Map<ResourceLocation, List<JsonElement>> objects, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        RegistryListener.getInstance().listen(r -> {
            try {
                while (!this.preprocessorContext.rawData.isEmpty()) {
                    this.preprocessorContext.process(this.preprocessorContext.rawData.keySet().iterator().next());
                }
                HashMap map = Maps.newHashMap();
                Object serializer = DataPackAnvil.WRAPPER.getSerializer(this.key);
                this.preprocessorContext.processedData.forEach((loc, jsonElements) -> {
                    try {
                        Object value = serializer.read((JsonElement)jsonElements.getFirst());
                        this.idSetter.accept(value, (ResourceLocation)loc);
                        map.put(loc, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to load data file " + String.valueOf(loc), e);
                    }
                });
                this.setData(map);
            }
            catch (Exception e) {
                DataManagerWrapper.logManagerException(this.key, e);
            }
        });
    }

    private class PreprocessorContext
    implements DataPreprocessor.Context {
        private final Map<ResourceLocation, List<JsonElement>> rawData;
        private final Map<ResourceLocation, List<JsonElement>> processedData;
        private final List<ResourceLocation> processingIds;

        private PreprocessorContext(Map<ResourceLocation, List<JsonElement>> rawData) {
            this.rawData = new HashMap<ResourceLocation, List<JsonElement>>(rawData);
            this.processedData = Maps.newHashMap();
            this.processingIds = Lists.newArrayList();
        }

        @Override
        public HolderLookup.Provider getRegistryLookup() {
            return DataManager.this.getRegistryLookup();
        }

        @Override
        public ICondition.IContext getConditionContext() {
            return DataManager.this.getContext();
        }

        @Override
        public List<JsonElement> getProcessed(ResourceLocation id) {
            if (this.processedData.containsKey(id)) {
                return this.processedData.get(id);
            }
            if (this.processingIds.contains(id)) {
                throw new IllegalStateException("Data for " + String.valueOf(id) + " is already being processed. This is likely a circular dependency.");
            }
            this.process(id);
            return this.processedData.get(id);
        }

        void process(ResourceLocation id) {
            DataPreprocessor preprocessor;
            List<JsonElement> elements = this.rawData.remove(id);
            this.processingIds.add(id);
            Iterator<DataPreprocessor> iterator = DataManager.this.preprocessors.iterator();
            while (iterator.hasNext() && (elements = (preprocessor = iterator.next()).preprocess(this, elements)) != null && !elements.isEmpty()) {
            }
            this.processingIds.remove(id);
            if (elements == null || elements.isEmpty()) {
                return;
            }
            this.processedData.put(id, elements);
        }

        JsonElement processAnonymous(JsonElement element) {
            DataPreprocessor preprocessor;
            List<JsonElement> list = List.of(element);
            Iterator<DataPreprocessor> iterator = DataManager.this.preprocessors.iterator();
            while (iterator.hasNext() && (list = (preprocessor = iterator.next()).preprocess(this, list)) != null && !list.isEmpty()) {
            }
            return list != null && !list.isEmpty() ? list.getFirst() : JsonNull.INSTANCE;
        }
    }
}

