/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.data.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import sirttas.dpanvil.api.data.IDataManager;
import sirttas.dpanvil.api.data.preprocessor.DataPreprocessor;
import sirttas.dpanvil.api.data.preprocessor.NeoForgeConditionsPreprocessor;
import sirttas.dpanvil.api.data.preprocessor.PickingDataPreprocessor;
import sirttas.dpanvil.data.manager.DataManager;

public class DataManagerBuilder<T>
implements IDataManager.Builder<T> {
    private final Class<T> type;
    private final ResourceKey<IDataManager<T>> key;
    private final List<DataPreprocessor> preprocessors;
    private String folder;
    private Function<ResourceLocation, T> defaultValueFactory = id -> null;
    private BiConsumer<T, ResourceLocation> idSetter = (t, id) -> {};

    public DataManagerBuilder(Class<T> type, @Nonnull ResourceKey<IDataManager<T>> key) {
        this.type = type;
        this.key = key;
        this.preprocessors = new ArrayList<DataPreprocessor>();
        ResourceLocation location = key.location();
        this.folder = location.getNamespace() + "/" + location.getPath();
    }

    @Override
    public IDataManager.Builder<T> withDefault(Function<ResourceLocation, T> factory) {
        this.defaultValueFactory = factory;
        return this;
    }

    @Override
    public IDataManager.Builder<T> preprocessor(DataPreprocessor preprocessor) {
        this.preprocessors.add(preprocessor);
        return this;
    }

    @Override
    public IDataManager.Builder<T> defaultPreprocessors() {
        this.preprocessors.add(new NeoForgeConditionsPreprocessor());
        this.preprocessors.add(new PickingDataPreprocessor());
        return this;
    }

    @Override
    public IDataManager.Builder<T> folder(String folder) {
        this.folder = folder;
        return this;
    }

    @Override
    public IDataManager.Builder<T> idSetter(BiConsumer<T, ResourceLocation> idSetter) {
        this.idSetter = idSetter;
        return this;
    }

    @Override
    public IDataManager<T> build() {
        if (this.preprocessors.isEmpty()) {
            this.defaultPreprocessors();
        }
        return new DataManager<T>(this.key, this.type, this.folder, this.defaultValueFactory, this.idSetter, this.preprocessors);
    }
}

