/*
 * Decompiled with CFR 0.152.
 */
package sirttas.dpanvil.registry;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;

@EventBusSubscriber(modid="dpanvil")
@Deprecated
public class RegistryListener {
    private final List<Consumer<RegistryAccess>> listeners = new ArrayList<Consumer<RegistryAccess>>();
    private final Map<DynamicOps<?>, RegistryOps<?>> registryOps = new Reference2ObjectOpenHashMap();
    private RegistryAccess registry;
    private static final RegistryListener INSTANCE = new RegistryListener();

    private RegistryListener() {
    }

    public static RegistryListener getInstance() {
        return INSTANCE;
    }

    public synchronized void listen(Consumer<RegistryAccess> listener) {
        if (this.registry != null) {
            listener.accept(this.registry);
        } else {
            this.listeners.add(listener);
        }
    }

    public synchronized <T> RegistryOps<T> getRegistryOps(DynamicOps<T> ops) {
        if (this.registry == null) {
            throw new IllegalStateException("Registry not initialized yet!");
        }
        return this.registryOps.computeIfAbsent(ops, o -> this.registry.createSerializationContext(o));
    }

    private synchronized void clear() {
        this.registry = null;
        this.registryOps.clear();
    }

    private synchronized void runListeners(RegistryAccess registryAccess) {
        this.registry = registryAccess;
        this.registryOps.clear();
        this.listeners.forEach(l -> l.accept(this.registry));
        this.listeners.clear();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void addReloadListeners(AddReloadListenerEvent event) {
        INSTANCE.clear();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTagsUpdated(TagsUpdatedEvent event) {
        INSTANCE.runListeners((RegistryAccess)event.getRegistryAccess().freeze());
    }
}

