/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Commands;

import fr.xyness.SCS.CScoreboard;
import fr.xyness.SCS.ClaimMain;
import fr.xyness.SCS.Guis.Bedrock.BChunkConfirmationGui;
import fr.xyness.SCS.Guis.Bedrock.BClaimBansGui;
import fr.xyness.SCS.Guis.Bedrock.BClaimChunksGui;
import fr.xyness.SCS.Guis.Bedrock.BClaimConfirmationGui;
import fr.xyness.SCS.Guis.Bedrock.BClaimListGui;
import fr.xyness.SCS.Guis.Bedrock.BClaimMainGui;
import fr.xyness.SCS.Guis.Bedrock.BClaimMembersGui;
import fr.xyness.SCS.Guis.Bedrock.BClaimSettingsGui;
import fr.xyness.SCS.Guis.ChunkConfirmationGui;
import fr.xyness.SCS.Guis.ClaimBansGui;
import fr.xyness.SCS.Guis.ClaimChunksGui;
import fr.xyness.SCS.Guis.ClaimConfirmationGui;
import fr.xyness.SCS.Guis.ClaimListGui;
import fr.xyness.SCS.Guis.ClaimMainGui;
import fr.xyness.SCS.Guis.ClaimMembersGui;
import fr.xyness.SCS.Guis.ClaimSettingsGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import fr.xyness.SCS.Types.WorldMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.geysermc.floodgate.api.FloodgateApi;

public class ClaimCommand
implements CommandExecutor,
TabCompleter {
    public static Map<Player, Integer> isOnCreate = new HashMap<Player, Integer>();
    public static Map<Player, String> isOnAdd = new HashMap<Player, String>();
    public static Map<Player, Map<Player, String>> invitations = new HashMap<Player, Map<Player, String>>();
    public static Map<Player, Map<Player, LocalDateTime>> invitationsTime = new HashMap<Player, Map<Player, LocalDateTime>>();
    private SimpleClaimSystem instance;
    public static Set<String> commands = Set.of("settings", "add", "remove", "list", "setspawn", "setname", "members", "setdesc", "chat", "map", "autoclaim", "automap", "see", "tp", "ban", "unban", "bans", "fly", "autofly", "owner", "merge", "sell", "cancel", "main", "delchunk", "addchunk", "chunks", "kick", "buy", "autounclaim", "autoaddchunk", "autodelchunk", "accept", "deny", "cancelinv");

    public ClaimCommand(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim")) {
            return Collections.emptyList();
        }
        String playerName = player.getName();
        Chunk chunk = player.getLocation().getChunk();
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
            ArrayList<String> completions = new ArrayList<String>();
            if (args.length == 1) {
                String arg = args.length > 0 ? args[0].toLowerCase() : "";
                completions.addAll(this.getPrimaryCompletions(player, arg));
            } else if (args.length == 2) {
                String arg = args.length > 1 ? args[1].toLowerCase() : "";
                completions.addAll(this.getSecondaryCompletions(player, args[0], playerName, chunk, arg));
            } else if (args.length == 3) {
                String arg = args.length > 2 ? args[2].toLowerCase() : "";
                completions.addAll(this.getTertiaryCompletions(player, args[0], args[1], playerName, arg));
            }
            return completions;
        });
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return Collections.emptyList();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.instance.getLanguage().getMessage("command-only-by-players"));
            return true;
        }
        Player player = (Player)sender;
        String playerName = player.getName();
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
        if (args.length > 1 && args[0].equals("setdesc")) {
            this.handleDesc(player, playerName, args);
            return true;
        }
        switch (args.length) {
            case 0: {
                this.handleArgZero(player, playerName, cPlayer);
                break;
            }
            case 1: {
                this.handleArgOne(player, playerName, cPlayer, args);
                break;
            }
            case 2: {
                this.handleArgTwo(player, playerName, cPlayer, args);
                break;
            }
            case 3: {
                this.handleArgThree(player, playerName, cPlayer, args);
                break;
            }
            default: {
                this.instance.getMain().getHelp(player, args[0], "claim");
            }
        }
        return true;
    }

    private void handleDesc(Player player, String playerName, String[] args) {
        if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.setdesc")) {
            player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
            return;
        }
        if (this.instance.getMain().getClaimsNameFromOwner(playerName).contains(args[1])) {
            String description = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
            if (description.length() > Integer.parseInt(this.instance.getSettings().getSetting("max-length-claim-description"))) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-description-too-long"));
                return;
            }
            if (!description.matches("^[a-zA-Z0-9\\s]+$")) {
                player.sendMessage(this.instance.getLanguage().getMessage("incorrect-characters-description"));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            ((CompletableFuture)this.instance.getMain().setClaimDescription(claim, description).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("claim-set-description-success").replace("%name%", args[1]).replace("%description%", description)));
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
    }

    private void handleArgThree(Player player, String playerName, CPlayer cPlayer, String[] args) {
        if (args[0].equalsIgnoreCase("delchunk")) {
            int Z_;
            int X_;
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.delchunk")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (claim.getChunks().size() == 1) {
                player.sendMessage(this.instance.getLanguage().getMessage("cannot-remove-only-remaining-chunk"));
                return;
            }
            String[] parts = args[2].split(";");
            if (parts.length != 3) {
                player.sendMessage(this.instance.getLanguage().getMessage("delchunk-bad-format"));
                return;
            }
            World world = Bukkit.getWorld((String)parts[0]);
            if (world == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-does-not-exist"));
                return;
            }
            try {
                X_ = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.instance.getLanguage().getMessage("x-z-must-be-integer"));
                return;
            }
            try {
                Z_ = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.instance.getLanguage().getMessage("x-z-must-be-integer"));
                return;
            }
            if (this.instance.isFolia()) {
                world.getChunkAtAsync(X_, Z_).thenAccept(chunk -> {
                    HashSet<Chunk> chunks = new HashSet<Chunk>(claim.getChunks());
                    if (!chunks.contains(chunk)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("chunk-not-in-claim"));
                        return;
                    }
                    chunks.remove(chunk);
                    if (!this.instance.getMain().areChunksConnected(chunks)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("chunks-are-not-connected-delchunk"));
                        return;
                    }
                    ((CompletableFuture)this.instance.getMain().removeClaimChunk(claim, (Chunk)chunk).thenAccept(success -> {
                        if (success.booleanValue()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("delete-chunk-success").replace("%chunk%", "[" + args[2] + "]").replace("%claim-name%", claim.getName())));
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error-delete-chunk")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                });
            } else {
                Chunk chunk2 = world.getChunkAt(X_, Z_);
                HashSet<Chunk> chunks = new HashSet<Chunk>(claim.getChunks());
                if (!chunks.contains(chunk2)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("chunk-not-in-claim"));
                    return;
                }
                chunks.remove(chunk2);
                if (!this.instance.getMain().areChunksConnected(chunks)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("chunks-are-not-connected-delchunk"));
                    return;
                }
                ((CompletableFuture)this.instance.getMain().removeClaimChunk(claim, chunk2).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("delete-chunk-success").replace("%chunk%", "[" + args[2] + "]").replace("%claim-name%", claim.getName())));
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error-delete-chunk")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            }
            return;
        }
        if (args[0].equalsIgnoreCase("merge")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.merge")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            CustomSet<String> claimsName = this.instance.getMain().getClaimsNameFromOwner(playerName);
            if (!claimsName.contains(args[1])) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            Claim claim1 = this.instance.getMain().getClaimByName(args[1], player);
            CustomSet<Claim> claims = new CustomSet<Claim>();
            if (args[2].equals("*")) {
                claims.addAll(this.instance.getMain().getPlayerClaims(playerName));
                claims.remove(claim1);
                if (claims.size() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("no-claim-can-be-merged"));
                    return;
                }
            } else if (args[2].contains(";")) {
                for (String c2 : args[2].split(";")) {
                    if (!claimsName.contains(c2)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                        return;
                    }
                    claims.add(this.instance.getMain().getClaimByName(c2, player));
                }
            } else {
                if (!claimsName.contains(args[2])) {
                    player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                    return;
                }
                Claim claim2 = this.instance.getMain().getClaimByName(args[2], player);
                claims.add(claim2);
            }
            if (claims.contains(claim1)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-merge-same-claim"));
                return;
            }
            HashSet<Chunk> chunks = new HashSet<Chunk>(claim1.getChunks());
            claims.forEach(c -> chunks.addAll(c.getChunks()));
            if (!this.areChunksLinked(chunks)) {
                player.sendMessage(this.instance.getLanguage().getMessage("there-is-a-claim-not-adjacent"));
                return;
            }
            if (!cPlayer.canClaimWithNumber(chunks.size())) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks"));
                return;
            }
            if (!this.instance.getMain().areChunksInSameWorld(chunks)) {
                player.sendMessage(this.instance.getLanguage().getMessage("chunks-must-be-from-same-world"));
                return;
            }
            ((CompletableFuture)this.instance.getMain().mergeClaims(claim1, claims).thenAccept(success -> {
                if (success.booleanValue()) {
                    player.sendMessage(this.instance.getLanguage().getMessage("claims-are-now-merged").replace("%claim-name%", claim1.getName()));
                    if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                        this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)claim1.getChunks()), true, false);
                    }
                } else {
                    player.sendMessage(this.instance.getLanguage().getMessage("error"));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("setname")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.setname")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (this.instance.getMain().getClaimsNameFromOwner(playerName).contains(args[1])) {
                if (args[2].length() > Integer.parseInt(this.instance.getSettings().getSetting("max-length-claim-name"))) {
                    player.sendMessage(this.instance.getLanguage().getMessage("claim-name-too-long"));
                    return;
                }
                if (args[2].contains("claim-")) {
                    player.sendMessage(this.instance.getLanguage().getMessage("you-cannot-use-this-name"));
                    return;
                }
                if (!args[2].matches("^[a-zA-Z0-9_\\-\\s]+$")) {
                    player.sendMessage(this.instance.getLanguage().getMessage("incorrect-characters-name"));
                    return;
                }
                if (this.instance.getMain().checkName(player.getUniqueId(), args[2])) {
                    Claim claim = this.instance.getMain().getClaimByName(args[1], player);
                    ((CompletableFuture)this.instance.getMain().setClaimName(claim, args[2]).thenAccept(success -> {
                        if (success.booleanValue()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("name-change-success").replace("%name%", args[2])));
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                    return;
                }
                player.sendMessage(this.instance.getLanguage().getMessage("error-name-exists").replace("%name%", args[2]));
                return;
            }
            player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
            return;
        }
        if (args[0].equalsIgnoreCase("kick")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.kick")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (args[1].equalsIgnoreCase("*")) {
                if (cPlayer.getClaimsCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-has-no-claim"));
                    return;
                }
                Player target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                    return;
                }
                if (target.getName().equals(playerName)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("can-not-kick-yourself"));
                    return;
                }
                this.instance.executeAsyncLocation(() -> {
                    if (!this.instance.getMain().getAllChunksFromAllClaims(playerName).contains(target.getLocation().getChunk())) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-not-in-any-claim").replace("%player%", target.getName()));
                        return;
                    }
                    player.sendMessage(this.instance.getLanguage().getMessage("kick-success-all-claims").replace("%player%", target.getName()));
                    target.sendMessage(this.instance.getLanguage().getMessage("kicked-from-all-claims").replace("%player%", playerName));
                    this.instance.getMain().teleportPlayerToExpulsion(target);
                }, target.getLocation());
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[2]);
            if (target == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                return;
            }
            if (target.getName().equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("can-not-kick-yourself"));
                return;
            }
            this.instance.executeAsyncLocation(() -> {
                if (!claim.getChunks().contains(target.getLocation().getChunk())) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-not-in-the-claim").replace("%player%", target.getName()).replace("%claim-name%", claim.getName()));
                    return;
                }
                String claimName = claim.getName();
                player.sendMessage(this.instance.getLanguage().getMessage("kick-success").replace("%player%", target.getName()).replace("%claim-name%", claimName));
                target.sendMessage(this.instance.getLanguage().getMessage("kicked-from-claim").replace("%player%", playerName).replace("%claim-name%", claimName));
                this.instance.getMain().teleportPlayerToExpulsion(target);
            }, target.getLocation());
            return;
        }
        if (args[0].equalsIgnoreCase("ban")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.ban")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (args[1].equalsIgnoreCase("*")) {
                if (cPlayer.getClaimsCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-has-no-claim"));
                    return;
                }
                Player target = Bukkit.getPlayer((String)args[2]);
                String[] targetName = new String[]{""};
                Runnable task = () -> this.instance.executeSync(() -> {
                    if (targetName[0].equals(playerName)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("cant-ban-yourself"));
                        return;
                    }
                    String message = this.instance.getLanguage().getMessage("add-ban-all-success").replace("%player%", targetName[0]);
                    ((CompletableFuture)this.instance.getMain().addAllClaimBan(playerName, targetName[0]).thenAccept(success -> {
                        if (success.booleanValue()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                            if (target != null && target.isOnline()) {
                                this.instance.executeAsyncLocation(() -> {
                                    if (this.instance.getMain().getAllChunksFromAllClaims(playerName).contains(target.getLocation().getChunk())) {
                                        this.instance.executeEntitySync(target, () -> this.instance.getMain().teleportPlayerToExpulsion(target));
                                    }
                                }, target.getLocation());
                                this.instance.executeEntitySync(target, () -> {
                                    target.sendMessage(this.instance.getLanguage().getMessage("banned-all-claim-player").replace("%owner%", playerName));
                                    target.sendMessage(this.instance.getLanguage().getMessage("remove-all-claim-player").replace("%owner%", playerName));
                                });
                            }
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                });
                if (target == null) {
                    this.instance.getOfflinePlayer(args[2], otarget -> {
                        if (otarget == null || !otarget.hasPlayedBefore()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                            return;
                        }
                        targetName[0] = otarget.getName();
                        task.run();
                    });
                } else {
                    targetName[0] = target.getName();
                    task.run();
                }
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[2]);
            String[] targetName = new String[]{""};
            Runnable task = () -> this.instance.executeSync(() -> {
                if (targetName[0].equals(playerName)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-ban-yourself"));
                    return;
                }
                if (this.instance.getMain().checkBan(claim, targetName[0])) {
                    String message = this.instance.getLanguage().getMessage("already-banned").replace("%player%", targetName[0]);
                    player.sendMessage(message);
                    return;
                }
                String message = this.instance.getLanguage().getMessage("add-ban-success").replace("%player%", targetName[0]).replace("%claim-name%", claim.getName());
                ((CompletableFuture)this.instance.getMain().addClaimBan(claim, targetName[0]).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                        if (target != null && target.isOnline()) {
                            String claimName = claim.getName();
                            this.instance.executeAsyncLocation(() -> {
                                if (claim.getChunks().contains(target.getLocation().getChunk())) {
                                    this.instance.executeEntitySync(target, () -> this.instance.getMain().teleportPlayerToExpulsion(target));
                                }
                            }, target.getLocation());
                            this.instance.executeEntitySync(target, () -> {
                                target.sendMessage(this.instance.getLanguage().getMessage("banned-claim-player").replace("%owner%", playerName).replace("%claim-name%", claimName));
                                target.sendMessage(this.instance.getLanguage().getMessage("remove-claim-player").replace("%owner%", playerName).replace("%claim-name%", claimName));
                            });
                        }
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            });
            if (target == null) {
                this.instance.getOfflinePlayer(args[2], otarget -> {
                    if (otarget == null || !otarget.hasPlayedBefore()) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    targetName[0] = otarget.getName();
                    task.run();
                });
            } else {
                targetName[0] = target.getName();
                task.run();
            }
            return;
        }
        if (args[0].equalsIgnoreCase("unban")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.unban")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (args[1].equalsIgnoreCase("*")) {
                if (cPlayer.getClaimsCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-has-no-claim"));
                    return;
                }
                Player target = Bukkit.getPlayer((String)args[2]);
                String[] targetName = new String[]{""};
                Runnable task = () -> this.instance.executeSync(() -> {
                    String message = this.instance.getLanguage().getMessage("remove-ban-all-success").replace("%player%", targetName[0]);
                    ((CompletableFuture)this.instance.getMain().removeAllClaimBan(playerName, targetName[0]).thenAccept(success -> {
                        if (success.booleanValue()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                            if (target != null && target.isOnline()) {
                                this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("unbanned-all-claim-player").replace("%owner%", playerName)));
                            }
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                });
                if (target == null) {
                    this.instance.getOfflinePlayer(args[2], otarget -> {
                        targetName[0] = otarget == null ? args[2] : otarget.getName();
                        task.run();
                    });
                } else {
                    targetName[0] = target.getName();
                    task.run();
                }
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (!this.instance.getMain().checkBan(claim, args[2])) {
                String message = this.instance.getLanguage().getMessage("not-banned").replace("%player%", args[2]);
                player.sendMessage(message);
                return;
            }
            String targetName = this.instance.getMain().getRealNameFromClaimBans(claim, args[2]);
            ((CompletableFuture)this.instance.getMain().removeClaimBan(claim, targetName).thenAccept(success -> {
                if (success.booleanValue()) {
                    String message = this.instance.getLanguage().getMessage("remove-ban-success").replace("%player%", targetName).replace("%claim-name%", claim.getName());
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    Player target = Bukkit.getPlayer((String)targetName);
                    if (target != null && target.isOnline()) {
                        this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("unbanned-claim-player").replace("%owner%", playerName).replace("%claim-name%", claim.getName())));
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("add")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.add")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (args[1].equalsIgnoreCase("*")) {
                if (cPlayer.getClaimsCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-has-no-claim"));
                    return;
                }
                for (Claim claim : this.instance.getMain().getPlayerClaims(playerName)) {
                    if (this.instance.getPlayerMain().canAddMember(player, claim)) continue;
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-add-member-anymore"));
                    return;
                }
                Player target = Bukkit.getPlayer((String)args[2]);
                if (this.instance.getSettings().getBooleanSetting("claim-invitations-system")) {
                    if (target == null) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                        return;
                    }
                    targetName = target.getName();
                    if (targetName.equals(playerName)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("cant-add-yourself"));
                        return;
                    }
                    if (invitations.containsKey(player) && invitations.get(player).containsKey(target)) {
                        String message = this.instance.getLanguage().getMessage("player-already-invite-other").replace("%player%", (CharSequence)targetName);
                        player.sendMessage(message);
                        return;
                    }
                    invitations.computeIfAbsent(player, k -> new HashMap()).put(target, "*");
                    LocalDateTime date = LocalDateTime.now();
                    invitationsTime.computeIfAbsent(player, k -> new HashMap()).put(target, date);
                    player.sendMessage(this.instance.getLanguage().getMessage("player-invite-other").replace("%player%", (CharSequence)targetName));
                    TextComponent message = new TextComponent(this.instance.getLanguage().getMessage("player-invite-other-player").replace("%sender%", playerName).replace("%claim-name%", this.instance.getLanguage().getMessage("player-invitation-all-their-claims")) + " ");
                    TextComponent acceptButton = new TextComponent(this.instance.getLanguage().getMessage("player-invite-accept-button"));
                    acceptButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/claim accept " + playerName));
                    acceptButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.instance.getLanguage().getMessage("player-invite-accept-button-hover")).create()));
                    TextComponent space = new TextComponent(" ");
                    TextComponent denyButton = new TextComponent(this.instance.getLanguage().getMessage("player-invite-deny-button"));
                    denyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/claim deny " + playerName));
                    denyButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.instance.getLanguage().getMessage("player-invite-deny-button-hover")).create()));
                    message.addExtra((BaseComponent)acceptButton);
                    message.addExtra((BaseComponent)space);
                    message.addExtra((BaseComponent)denyButton);
                    target.sendMessage((BaseComponent)message);
                    this.instance.executeAsyncLater(() -> this.lambda$handleArgThree$60(player, target, date, playerName, (String)targetName), Integer.parseInt(this.instance.getSettings().getSetting("claim-invitation-expiration-delay")) * 1000);
                } else {
                    targetName = new String[]{""};
                    Runnable task = () -> this.instance.executeSync(() -> {
                        if (targetName[0].equals(playerName)) {
                            player.sendMessage(this.instance.getLanguage().getMessage("cant-add-yourself"));
                            return;
                        }
                        String message = this.instance.getLanguage().getMessage("add-member-success").replace("%player%", targetName[0]).replace("%claim-name%", this.instance.getLanguage().getMessage("all-your-claims-title"));
                        ((CompletableFuture)this.instance.getMain().addAllClaimsMember(playerName, targetName[0]).thenAccept(success -> {
                            if (success.booleanValue()) {
                                this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                                if (target != null && target.isOnline()) {
                                    this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("add-all-claim-player").replace("%owner%", playerName)));
                                }
                            } else {
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                            }
                        })).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                    });
                    if (target == null) {
                        this.instance.getOfflinePlayer(args[2], otarget -> {
                            if (otarget == null || !otarget.hasPlayedBefore()) {
                                player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                                return;
                            }
                            targetName[0] = otarget.getName();
                            task.run();
                        });
                    } else {
                        targetName[0] = target.getName();
                        task.run();
                    }
                }
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (!this.instance.getPlayerMain().canAddMember(player, claim)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-add-member-anymore"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[2]);
            if (this.instance.getSettings().getBooleanSetting("claim-invitations-system")) {
                if (target == null) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[1]));
                    return;
                }
                String targetName = target.getName();
                if (targetName.equals(playerName)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-add-yourself"));
                    return;
                }
                if (this.instance.getMain().checkMembre(claim, targetName)) {
                    String message = this.instance.getLanguage().getMessage("already-member").replace("%player%", targetName);
                    player.sendMessage(message);
                    return;
                }
                if (invitations.containsKey(player) && invitations.get(player).containsKey(target)) {
                    String message = this.instance.getLanguage().getMessage("player-already-invite-other").replace("%player%", targetName);
                    player.sendMessage(message);
                    return;
                }
                invitations.computeIfAbsent(player, k -> new HashMap()).put(target, claim.getName());
                LocalDateTime date = LocalDateTime.now();
                invitationsTime.computeIfAbsent(player, k -> new HashMap()).put(target, date);
                player.sendMessage(this.instance.getLanguage().getMessage("player-invite-other").replace("%player%", targetName));
                TextComponent message = new TextComponent(this.instance.getLanguage().getMessage("player-invite-other-player").replace("%sender%", playerName).replace("%claim-name%", claim.getName()));
                TextComponent acceptButton = new TextComponent(this.instance.getLanguage().getMessage("player-invite-accept-button"));
                acceptButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/claim accept " + playerName));
                acceptButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.instance.getLanguage().getMessage("player-invite-accept-button-hover")).create()));
                TextComponent denyButton = new TextComponent(this.instance.getLanguage().getMessage("player-invite-deny-button"));
                denyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/claim deny " + playerName));
                denyButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.instance.getLanguage().getMessage("player-invite-deny-button-hover")).create()));
                message.addExtra((BaseComponent)acceptButton);
                message.addExtra((BaseComponent)denyButton);
                target.sendMessage((BaseComponent)message);
                this.instance.executeAsyncLater(() -> {
                    if (player != null && target != null && invitations.containsKey(player) && invitations.get(player).containsKey(target) && invitations.get(player).get(target).equals(claim.getName()) && invitationsTime.containsKey(player) && invitationsTime.get(player).containsKey(target) && invitationsTime.get(player).get(target) == date) {
                        if (target.isOnline()) {
                            this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("player-invitation-expired-other").replace("%player%", playerName)));
                        }
                        if (player.isOnline()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("player-invitation-expired").replace("%player%", targetName)));
                        }
                        invitations.get(player).remove(target);
                        if (invitations.get(player).isEmpty()) {
                            invitations.remove(player);
                        }
                        invitationsTime.get(player).remove(target);
                        if (invitationsTime.get(player).isEmpty()) {
                            invitationsTime.remove(player);
                        }
                    }
                }, Integer.parseInt(this.instance.getSettings().getSetting("claim-invitation-expiration-delay")) * 1000);
            } else {
                String[] targetName = new String[]{""};
                Runnable task = () -> this.instance.executeSync(() -> {
                    if (targetName[0].equals(playerName)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("cant-add-yourself"));
                        return;
                    }
                    if (this.instance.getMain().checkMembre(claim, targetName[0])) {
                        String message = this.instance.getLanguage().getMessage("already-member").replace("%player%", targetName[0]);
                        player.sendMessage(message);
                        return;
                    }
                    String message = this.instance.getLanguage().getMessage("add-member-success").replace("%player%", targetName[0]).replace("%claim-name%", claim.getName());
                    ((CompletableFuture)this.instance.getMain().addClaimMember(claim, targetName[0]).thenAccept(success -> {
                        if (success.booleanValue()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                            if (target != null && target.isOnline()) {
                                this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("add-claim-player").replace("%claim-name%", claim.getName()).replace("%owner%", playerName)));
                            }
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                });
                if (target == null) {
                    this.instance.getOfflinePlayer(args[2], otarget -> {
                        if (otarget == null || !otarget.hasPlayedBefore()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                            return;
                        }
                        targetName[0] = otarget.getName();
                        task.run();
                    });
                } else {
                    targetName[0] = target.getName();
                    task.run();
                }
            }
            return;
        }
        if (args[0].equalsIgnoreCase("remove")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.remove")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (args[1].equalsIgnoreCase("*")) {
                if (cPlayer.getClaimsCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-has-no-claim"));
                    return;
                }
                if (args[2].equals(playerName)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-remove-owner"));
                    return;
                }
                String targetName = args[2];
                ((CompletableFuture)this.instance.getMain().removeAllClaimsMember(playerName, targetName).thenAccept(success -> {
                    if (success.booleanValue()) {
                        String message = this.instance.getLanguage().getMessage("remove-member-success").replace("%player%", targetName).replace("%claim-name%", this.instance.getLanguage().getMessage("all-your-claims-title"));
                        this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                        Player target = Bukkit.getPlayer((String)targetName);
                        if (target != null && target.isOnline()) {
                            this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("remove-all-claim-player").replace("%owner%", playerName)));
                        }
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            String targetName = args[2];
            if (targetName.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-remove-owner"));
                return;
            }
            if (!this.instance.getMain().checkMembre(claim, targetName)) {
                String message = this.instance.getLanguage().getMessage("not-member").replace("%player%", targetName);
                player.sendMessage(message);
                return;
            }
            String realName = this.instance.getMain().getRealNameFromClaimMembers(claim, targetName);
            ((CompletableFuture)this.instance.getMain().removeClaimMember(claim, realName).thenAccept(success -> {
                if (success.booleanValue()) {
                    String message = this.instance.getLanguage().getMessage("remove-member-success").replace("%player%", realName).replace("%claim-name%", claim.getName());
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    Player target = Bukkit.getPlayer((String)realName);
                    if (target != null && target.isOnline()) {
                        this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("remove-claim-player").replace("%claim-name%", claim.getName()).replace("%owner%", playerName)));
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("owner")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.owner")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (args[1].equalsIgnoreCase("*")) {
                if (cPlayer.getClaimsCount() == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-has-no-claim"));
                    return;
                }
                Player target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                    return;
                }
                String targetName = target.getName();
                if (targetName.equals(playerName)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-transfer-ownership-yourself"));
                    return;
                }
                CPlayer cTarget = this.instance.getPlayerMain().getCPlayer(target.getUniqueId());
                if (cTarget == null) {
                    player.sendMessage(this.instance.getLanguage().getMessage("error"));
                    return;
                }
                if (!cTarget.canClaimX(cPlayer.getClaimsCount())) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-anymore-other").replace("%player%", targetName));
                    return;
                }
                if (!cTarget.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(targetName).size() + this.instance.getMain().getAllChunksFromAllClaims(playerName).size())) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks-other").replace("%player%", targetName));
                    return;
                }
                String message = this.instance.getLanguage().getMessage("setowner-all-success").replace("%owner%", targetName);
                ((CompletableFuture)this.instance.getMain().setOwner(targetName, this.instance.getMain().getPlayerClaims(playerName), playerName).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[2]);
            if (target == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                return;
            }
            String targetName = target.getName();
            if (targetName.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-transfer-ownership-yourself"));
                return;
            }
            CPlayer cTarget = this.instance.getPlayerMain().getCPlayer(target.getUniqueId());
            if (cTarget == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("error"));
                return;
            }
            if (!cTarget.canClaim()) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-anymore-other").replace("%player%", targetName));
                return;
            }
            if (!cTarget.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(targetName).size() + claim.getChunks().size())) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks-other").replace("%player%", targetName));
                return;
            }
            String message = this.instance.getLanguage().getMessage("setowner-claim-success").replace("%owner%", targetName).replace("%claim-name%", claim.getName());
            ((CompletableFuture)this.instance.getMain().setOwner(targetName, claim).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("sell")) {
            if (!this.instance.getSettings().getBooleanSetting("economy")) {
                player.sendMessage(this.instance.getLanguage().getMessage("economy-disabled"));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (claim.getSale()) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-already-in-sale"));
                return;
            }
            try {
                long price = Long.parseLong(args[2]);
                long max_price = Long.parseLong(this.instance.getSettings().getSetting("max-sell-price"));
                if (price > max_price || price <= 0L) {
                    player.sendMessage(this.instance.getLanguage().getMessage("sell-claim-price-syntax").replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")).replace("%max-price%", this.instance.getMain().getPrice(this.instance.getSettings().getSetting("max-sell-price"))));
                    return;
                }
                ((CompletableFuture)this.instance.getMain().setChunkSale(claim, price).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("claim-for-sale-success").replace("%name%", args[1]).replace("%price%", this.instance.getMain().getPrice(args[2])).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                        this.instance.executeSync(() -> Bukkit.getOnlinePlayers().stream().forEach(p -> p.sendMessage(this.instance.getLanguage().getMessage("claim-for-sale-success-broadcast").replace("%name%", args[1]).replace("%price%", this.instance.getMain().getPrice(args[2])).replace("%player%", playerName).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")))));
                        this.instance.getBossBars().activateBossBar(claim.getChunks());
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            catch (NumberFormatException e) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-price-must-be-number"));
                return;
            }
        }
        this.instance.getMain().getHelp(player, args[0], "claim");
    }

    private void handleArgTwo(Player player, String playerName, CPlayer cPlayer, String[] args) {
        if (args[0].equalsIgnoreCase("cancelinv")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.cancelinv")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (!this.instance.getSettings().getBooleanSetting("claim-invitations-system")) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-invitations-system-off"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[1]));
                return;
            }
            if (invitations.containsKey(player) && invitations.get(player).containsKey(target) && invitationsTime.containsKey(player) && invitationsTime.get(player).containsKey(target)) {
                invitations.get(player).remove(target);
                if (invitations.get(player).isEmpty()) {
                    invitations.remove(player);
                }
                invitationsTime.get(player).remove(target);
                if (invitationsTime.get(player).isEmpty()) {
                    invitationsTime.remove(player);
                }
                player.sendMessage(this.instance.getLanguage().getMessage("player-cancel-invitation").replace("%player%", target.getName()));
            } else {
                player.sendMessage(this.instance.getLanguage().getMessage("player-do-not-invite").replace("%player%", target.getName()));
            }
            return;
        }
        if (args[0].equalsIgnoreCase("accept")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.accept")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (!this.instance.getSettings().getBooleanSetting("claim-invitations-system")) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-invitations-system-off"));
                return;
            }
            Player sender = Bukkit.getPlayer((String)args[1]);
            if (sender == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[1]));
                return;
            }
            if (invitations.containsKey(sender) && invitations.get(sender).containsKey(player)) {
                String claimName = invitations.get(sender).get(player);
                invitations.get(sender).remove(player);
                if (invitations.get(sender).isEmpty()) {
                    invitations.remove(sender);
                }
                invitationsTime.get(sender).remove(player);
                if (invitationsTime.get(sender).isEmpty()) {
                    invitationsTime.remove(sender);
                }
                if (claimName.equals("*")) {
                    ((CompletableFuture)this.instance.getMain().addAllClaimsMember(sender.getName(), playerName).thenAccept(success -> {
                        if (success.booleanValue()) {
                            String message = this.instance.getLanguage().getMessage("player-accept-invitation");
                            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                            this.instance.executeEntitySync(sender, () -> sender.sendMessage(this.instance.getLanguage().getMessage("player-accept-invitation-other").replace("%player%", playerName)));
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                } else {
                    Claim claim = this.instance.getMain().getClaimByName(claimName, sender);
                    if (claim == null) {
                        player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                        return;
                    }
                    ((CompletableFuture)this.instance.getMain().addClaimMember(claim, playerName).thenAccept(success -> {
                        if (success.booleanValue()) {
                            String message = this.instance.getLanguage().getMessage("player-accept-invitation");
                            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                            this.instance.executeEntitySync(sender, () -> sender.sendMessage(this.instance.getLanguage().getMessage("player-accept-invitation-other").replace("%player%", playerName)));
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                }
            } else {
                player.sendMessage(this.instance.getLanguage().getMessage("player-no-invitation").replace("%player%", sender.getName()));
            }
            return;
        }
        if (args[0].equalsIgnoreCase("deny")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.deny")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (!this.instance.getSettings().getBooleanSetting("claim-invitations-system")) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-invitations-system-off"));
                return;
            }
            Player sender = Bukkit.getPlayer((String)args[1]);
            if (sender == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[1]));
                return;
            }
            if (invitations.containsKey(sender) && invitations.get(sender).containsKey(player)) {
                invitations.get(sender).remove(player);
                if (invitations.get(sender).isEmpty()) {
                    invitations.remove(sender);
                }
                invitationsTime.get(sender).remove(player);
                if (invitationsTime.get(sender).isEmpty()) {
                    invitationsTime.remove(sender);
                }
                String message = this.instance.getLanguage().getMessage("player-deny-invitation");
                player.sendMessage(message);
                sender.sendMessage(this.instance.getLanguage().getMessage("player-deny-invitation-other").replace("%player%", playerName));
            } else {
                player.sendMessage(this.instance.getLanguage().getMessage("player-no-invitation").replace("%player%", sender.getName()));
            }
            return;
        }
        if (args[0].equalsIgnoreCase("main")) {
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                new BClaimMainGui(player, claim, this.instance);
                return;
            }
            new ClaimMainGui(player, claim, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("addchunk")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.addchunk")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (this.instance.getMain().checkIfClaimExists(chunk)) {
                Claim claim_target = this.instance.getMain().getClaim(chunk);
                if (claim_target.getOwner().equalsIgnoreCase(playerName)) {
                    if (claim_target.equals(claim)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-already-in-claim").replace("%claim-name%", claim.getName()));
                        return;
                    }
                    player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-already-owner").replace("%claim-name%", claim.getName()).replace("%claim-name-1%", claim_target.getName()));
                    return;
                }
                player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-not-owner"));
                return;
            }
            HashSet<Chunk> chunks = new HashSet<Chunk>(claim.getChunks());
            if (!cPlayer.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(playerName).size() + 1)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks"));
                return;
            }
            if (!cPlayer.canClaimWithNumber(chunks.size() + 1)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks"));
                return;
            }
            chunks.add(chunk);
            if (!this.instance.getMain().areChunksInSameWorld(chunks)) {
                player.sendMessage(this.instance.getLanguage().getMessage("chunks-must-be-from-same-world"));
                return;
            }
            chunks.remove(chunk);
            if (!this.instance.getMain().isAnyChunkAdjacent(chunks, chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("one-chunk-must-be-adjacent"));
                return;
            }
            double[] price = new double[]{0.0};
            if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("chunk-cost")) {
                price[0] = this.instance.getSettings().getBooleanSetting("chunk-cost-multiplier") ? cPlayer.getChunkMultipliedCost(chunks.size()).doubleValue() : cPlayer.getChunkCost();
                double balance = this.instance.getVault().getPlayerBalance(playerName);
                if (balance < price[0]) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("buy-but-not-enough-money-claim").replace("%missing-price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round((price[0] - balance) * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                    return;
                }
            }
            ((CompletableFuture)this.instance.getMain().isAreaClaimFree(chunk, cPlayer.getClaimDistance(), playerName).thenAccept(successs -> {
                if (successs.booleanValue()) {
                    if (this.instance.getSettings().getBooleanSetting("claim-confirmation")) {
                        if (isOnAdd.containsKey(player)) {
                            isOnAdd.remove(player);
                            if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("claim-cost")) {
                                this.instance.getVault().removePlayerBalance(playerName, price[0]);
                                if (price[0] > 0.0) {
                                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("you-paid-chunk").replace("%price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round(price[0] * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                                }
                            }
                            ((CompletableFuture)this.instance.getMain().addClaimChunk(claim, chunk).thenAccept(success -> {
                                if (success.booleanValue()) {
                                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-successful").replace("%chunk%", "[" + chunk.getWorld().getName() + ";" + String.valueOf(chunk.getX()) + ";" + String.valueOf(chunk.getZ()) + "]").replace("%claim-name%", claim.getName())));
                                    if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                                        this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)claim.getChunks()), true, false);
                                    }
                                    return;
                                }
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                            })).exceptionally(ex -> {
                                ex.printStackTrace();
                                return null;
                            });
                        } else {
                            isOnAdd.put(player, claim.getName());
                            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                                new BChunkConfirmationGui(player, this.instance, price[0]);
                                return;
                            }
                            new ChunkConfirmationGui(player, this.instance, price[0]);
                        }
                    } else {
                        if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("claim-cost")) {
                            this.instance.getVault().removePlayerBalance(playerName, price[0]);
                            if (price[0] > 0.0) {
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("you-paid-chunk").replace("%price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round(price[0] * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                            }
                        }
                        ((CompletableFuture)this.instance.getMain().addClaimChunk(claim, chunk).thenAccept(success -> {
                            if (success.booleanValue()) {
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("add-chunk-successful").replace("%chunk%", "[" + chunk.getWorld().getName() + ";" + String.valueOf(chunk.getX()) + ";" + String.valueOf(chunk.getZ()) + "]").replace("%claim-name%", claim.getName())));
                                if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                                    this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)claim.getChunks()), true, false);
                                }
                                return;
                            }
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        })).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cannot-claim-because-claim-near")));
                    return;
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("kick")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.kick")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[1]));
                return;
            }
            if (target.getName().equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("can-not-kick-yourself"));
                return;
            }
            this.instance.executeAsyncLocation(() -> {
                if (!claim.getChunks().contains(target.getLocation().getChunk())) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-not-in-the-claim").replace("%player%", target.getName()).replace("%claim-name%", claim.getName()));
                    return;
                }
                String claimName = claim.getName();
                player.sendMessage(this.instance.getLanguage().getMessage("kick-success").replace("%player%", target.getName()).replace("%claim-name%", claimName));
                target.sendMessage(this.instance.getLanguage().getMessage("kicked-from-claim").replace("%player%", playerName).replace("%claim-name%", claimName));
                this.instance.getMain().teleportPlayerToExpulsion(target);
            }, target.getLocation());
            return;
        }
        if (args[0].equalsIgnoreCase("ban")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.ban")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            String[] targetName = new String[]{""};
            Runnable task = () -> this.instance.executeSync(() -> {
                if (targetName[0].equals(playerName)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-ban-yourself"));
                    return;
                }
                if (this.instance.getMain().checkBan(claim, targetName[0])) {
                    String message = this.instance.getLanguage().getMessage("already-banned").replace("%player%", targetName[0]);
                    player.sendMessage(message);
                    return;
                }
                String message = this.instance.getLanguage().getMessage("add-ban-success").replace("%player%", targetName[0]).replace("%claim-name%", claim.getName());
                ((CompletableFuture)this.instance.getMain().addClaimBan(claim, targetName[0]).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                        if (target != null && target.isOnline()) {
                            String claimName = claim.getName();
                            this.instance.executeAsyncLocation(() -> {
                                if (claim.getChunks().contains(target.getLocation().getChunk())) {
                                    this.instance.executeEntitySync(target, () -> this.instance.getMain().teleportPlayerToExpulsion(target));
                                }
                            }, target.getLocation());
                            this.instance.executeEntitySync(target, () -> {
                                target.sendMessage(this.instance.getLanguage().getMessage("banned-claim-player").replace("%owner%", playerName).replace("%claim-name%", claimName));
                                target.sendMessage(this.instance.getLanguage().getMessage("remove-claim-player").replace("%owner%", playerName).replace("%claim-name%", claimName));
                            });
                        }
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            });
            if (target == null) {
                this.instance.getOfflinePlayer(args[1], otarget -> {
                    if (otarget == null || !otarget.hasPlayedBefore()) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[1]));
                        return;
                    }
                    targetName[0] = otarget.getName();
                    task.run();
                });
            } else {
                targetName[0] = target.getName();
                task.run();
            }
            return;
        }
        if (args[0].equalsIgnoreCase("unban")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.unban")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            if (!this.instance.getMain().checkBan(claim, args[1])) {
                String message = this.instance.getLanguage().getMessage("not-banned").replace("%player%", args[1]);
                player.sendMessage(message);
                return;
            }
            String targetName = this.instance.getMain().getRealNameFromClaimBans(claim, args[1]);
            String message = this.instance.getLanguage().getMessage("remove-ban-success").replace("%player%", targetName).replace("%claim-name%", claim.getName());
            ((CompletableFuture)this.instance.getMain().removeClaimBan(claim, targetName).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    Player target = Bukkit.getPlayer((String)targetName);
                    if (target != null && target.isOnline()) {
                        this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("unbanned-claim-player").replace("%owner%", playerName).replace("%claim-name%", claim.getName())));
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("owner")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.owner")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (target == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[1]));
                return;
            }
            String targetName = target.getName();
            if (targetName.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-transfer-ownership-yourself"));
                return;
            }
            CPlayer cTarget = this.instance.getPlayerMain().getCPlayer(target.getUniqueId());
            if (cTarget == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("error"));
                return;
            }
            if (!cTarget.canClaim()) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-anymore-other").replace("%player%", targetName));
                return;
            }
            if (!cTarget.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(targetName).size() + claim.getChunks().size())) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks-other").replace("%player%", targetName));
                return;
            }
            String message = this.instance.getLanguage().getMessage("setowner-claim-success").replace("%owner%", targetName).replace("%claim-name%", claim.getName());
            ((CompletableFuture)this.instance.getMain().setOwner(targetName, claim).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> null);
            return;
        }
        if (args[0].equalsIgnoreCase("remove")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.remove")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            String targetName = args[1];
            if (targetName.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-remove-owner"));
                return;
            }
            if (!this.instance.getMain().checkMembre(claim, targetName)) {
                String message = this.instance.getLanguage().getMessage("not-member").replace("%player%", targetName);
                player.sendMessage(message);
                return;
            }
            String realName = this.instance.getMain().getRealNameFromClaimMembers(claim, targetName);
            String message = this.instance.getLanguage().getMessage("remove-member-success").replace("%player%", realName).replace("%claim-name%", claim.getName());
            ((CompletableFuture)this.instance.getMain().removeClaimMember(claim, realName).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                    Player target = Bukkit.getPlayer((String)realName);
                    if (target != null && target.isOnline()) {
                        this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("remove-claim-player").replace("%claim-name%", claim.getName()).replace("%owner%", playerName)));
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("add")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.add")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            if (!this.instance.getPlayerMain().canAddMember(player, claim)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-add-member-anymore"));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            if (this.instance.getSettings().getBooleanSetting("claim-invitations-system")) {
                if (target == null) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[1]));
                    return;
                }
                String targetName = target.getName();
                if (targetName.equals(playerName)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-add-yourself"));
                    return;
                }
                if (this.instance.getMain().checkMembre(claim, targetName)) {
                    String message = this.instance.getLanguage().getMessage("already-member").replace("%player%", targetName);
                    player.sendMessage(message);
                    return;
                }
                if (invitations.containsKey(player) && invitations.get(player).containsKey(target)) {
                    String message = this.instance.getLanguage().getMessage("player-already-invite-other").replace("%player%", targetName);
                    player.sendMessage(message);
                    return;
                }
                invitations.computeIfAbsent(player, k -> new HashMap()).put(target, claim.getName());
                LocalDateTime date = LocalDateTime.now();
                invitationsTime.computeIfAbsent(player, k -> new HashMap()).put(target, date);
                player.sendMessage(this.instance.getLanguage().getMessage("player-invite-other").replace("%player%", targetName));
                TextComponent message = new TextComponent(this.instance.getLanguage().getMessage("player-invite-other-player").replace("%sender%", playerName).replace("%claim-name%", claim.getName()) + " ");
                TextComponent acceptButton = new TextComponent(this.instance.getLanguage().getMessage("player-invite-accept-button"));
                acceptButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/claim accept " + playerName));
                acceptButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.instance.getLanguage().getMessage("player-invite-accept-button-hover")).create()));
                TextComponent space = new TextComponent(" ");
                TextComponent denyButton = new TextComponent(this.instance.getLanguage().getMessage("player-invite-deny-button"));
                denyButton.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/claim deny " + playerName));
                denyButton.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(this.instance.getLanguage().getMessage("player-invite-deny-button-hover")).create()));
                message.addExtra((BaseComponent)acceptButton);
                message.addExtra((BaseComponent)space);
                message.addExtra((BaseComponent)denyButton);
                target.sendMessage((BaseComponent)message);
                this.instance.executeAsyncLater(() -> {
                    if (player != null && target != null && invitations.containsKey(player) && invitations.get(player).containsKey(target) && invitations.get(player).get(target).equals(claim.getName()) && invitationsTime.containsKey(player) && invitationsTime.get(player).containsKey(target) && invitationsTime.get(player).get(target) == date) {
                        if (target.isOnline()) {
                            this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("player-invitation-expired-other").replace("%player%", playerName)));
                        }
                        if (player.isOnline()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("player-invitation-expired").replace("%player%", targetName)));
                        }
                        invitations.get(player).remove(target);
                        if (invitations.get(player).isEmpty()) {
                            invitations.remove(player);
                        }
                        invitationsTime.get(player).remove(target);
                        if (invitationsTime.get(player).isEmpty()) {
                            invitationsTime.remove(player);
                        }
                    }
                }, Integer.parseInt(this.instance.getSettings().getSetting("claim-invitation-expiration-delay")) * 1000);
            } else {
                String[] targetName = new String[]{""};
                Runnable task = () -> this.instance.executeSync(() -> {
                    if (targetName[0].equals(playerName)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("cant-add-yourself"));
                        return;
                    }
                    if (this.instance.getMain().checkMembre(claim, targetName[0])) {
                        String message = this.instance.getLanguage().getMessage("already-member").replace("%player%", targetName[0]);
                        player.sendMessage(message);
                        return;
                    }
                    String message = this.instance.getLanguage().getMessage("add-member-success").replace("%player%", targetName[0]).replace("%claim-name%", claim.getName());
                    ((CompletableFuture)this.instance.getMain().addClaimMember(claim, targetName[0]).thenAccept(success -> {
                        if (success.booleanValue()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(message));
                            if (target != null && target.isOnline()) {
                                this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("add-claim-player").replace("%claim-name%", claim.getName()).replace("%owner%", playerName)));
                            }
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                });
                if (target == null) {
                    this.instance.getOfflinePlayer(args[1], otarget -> {
                        if (otarget == null || !otarget.hasPlayedBefore()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[1]));
                            return;
                        }
                        targetName[0] = otarget.getName();
                        task.run();
                    });
                } else {
                    targetName[0] = target.getName();
                    task.run();
                }
            }
            return;
        }
        if (args[0].equalsIgnoreCase("see")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.see.others")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            Player target = Bukkit.getPlayer((String)args[1]);
            UUID[] uuid = new UUID[]{null};
            Runnable task = () -> this.instance.executeSync(() -> {
                if (this.instance.getMain().getPlayerClaimsCount(uuid[0]) == 0) {
                    player.sendMessage(this.instance.getLanguage().getMessage("target-does-not-have-claim").replace("%name%", args[1]));
                    return;
                }
                HashSet chunks = new HashSet();
                this.instance.getMain().getPlayerClaims(playerName).forEach(c -> c.getChunks().forEach(chunk -> chunks.add(chunk)));
                this.instance.getMain().displayChunks(player, new CustomSet<Chunk>(chunks), false, true);
            });
            if (target == null) {
                this.instance.getOfflinePlayer(args[1], otarget -> {
                    if (otarget == null || !otarget.hasPlayedBefore()) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[1]));
                        return;
                    }
                    uuid[0] = otarget.getUniqueId();
                    task.run();
                });
            } else {
                uuid[0] = target.getUniqueId();
                task.run();
            }
            return;
        }
        if (args[0].equalsIgnoreCase("settings")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.settings")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                new BClaimSettingsGui(player, claim, this.instance);
                return;
            }
            new ClaimSettingsGui(player, claim, this.instance, "visitors");
            return;
        }
        if (args[0].equalsIgnoreCase("chunks")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.chunks")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                new BClaimChunksGui(player, claim, this.instance);
                return;
            }
            new ClaimChunksGui(player, claim, 1, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("members")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.members")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                new BClaimMembersGui(player, claim, this.instance);
                return;
            }
            new ClaimMembersGui(player, claim, 1, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("bans")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.bans")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                new BClaimBansGui(player, claim, this.instance);
                return;
            }
            new ClaimBansGui(player, claim, 1, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("tp")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            this.instance.getMain().goClaim(player, claim.getLocation());
            return;
        }
        if (args[0].equalsIgnoreCase("autoaddchunk")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.autoaddchunk")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (cPlayer.getClaimAuto().equals("addchunk")) {
                cPlayer.setClaimAuto("");
                cPlayer.setTargetClaimChunk(null);
                player.sendMessage(this.instance.getLanguage().getMessage("autoaddchunk-off"));
                return;
            }
            cPlayer.setTargetClaimChunk(claim);
            cPlayer.setClaimAuto("addchunk");
            player.sendMessage(this.instance.getLanguage().getMessage("autoaddchunk-on").replace("%claim-name%", claim.getName()));
            return;
        }
        if (args[0].equalsIgnoreCase("autodelchunk")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.autodelchunk")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (cPlayer.getClaimAuto().equals("delchunk")) {
                cPlayer.setClaimAuto("");
                cPlayer.setTargetClaimChunk(null);
                player.sendMessage(this.instance.getLanguage().getMessage("autodelchunk-off"));
                return;
            }
            cPlayer.setTargetClaimChunk(claim);
            cPlayer.setClaimAuto("delchunk");
            player.sendMessage(this.instance.getLanguage().getMessage("autodelchunk-on").replace("%claim-name%", claim.getName()));
            return;
        }
        if (args[0].equalsIgnoreCase("cancel")) {
            Claim claim = this.instance.getMain().getClaimByName(args[1], player);
            if (claim == null) {
                player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                return;
            }
            if (claim.getSale()) {
                ((CompletableFuture)this.instance.getMain().delChunkSale(claim).thenAccept(success -> {
                    if (success.booleanValue()) {
                        this.instance.getBossBars().activateBossBar(claim.getChunks());
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("claim-in-sale-cancel").replace("%name%", args[1])));
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            player.sendMessage(this.instance.getLanguage().getMessage("claim-is-not-in-sale"));
            return;
        }
        this.instance.getMain().getHelp(player, args[0], "claim");
    }

    private void handleArgOne(Player player, String playerName, CPlayer cPlayer, String[] args) {
        if (args[0].equalsIgnoreCase("buy")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.buy")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaimFromChunk(chunk);
            if (claim.getOwner().equalsIgnoreCase(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("can-not-buy-your-own-claim"));
                return;
            }
            if (claim.getSale()) {
                String old_owner = claim.getOwner();
                String old_name = claim.getName();
                long price = claim.getPrice();
                long balance = (long)this.instance.getVault().getPlayerBalance(playerName);
                if (balance < price) {
                    player.sendMessage(this.instance.getLanguage().getMessage("buy-but-not-enough-money"));
                    return;
                }
                if (!cPlayer.canClaim()) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-anymore"));
                    return;
                }
                if (!cPlayer.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(playerName).size() + claim.getChunks().size())) {
                    player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks"));
                    return;
                }
                ((CompletableFuture)this.instance.getMain().isAreaClaimFree(chunk, cPlayer.getClaimDistance(), playerName).thenAccept(successs -> {
                    if (successs.booleanValue()) {
                        ((CompletableFuture)this.instance.getMain().sellChunk(player, claim).thenAccept(success -> {
                            if (success.booleanValue()) {
                                Player target;
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("buy-claim-success").replace("%name%", old_name).replace("%price%", this.instance.getMain().getPrice(price)).replace("%owner%", old_owner.equalsIgnoreCase("*") ? "protected areas" : old_owner).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                                if (!old_owner.equalsIgnoreCase("*") && (target = Bukkit.getPlayer((String)old_owner)) != null && target.isOnline()) {
                                    this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("claim-was-sold").replace("%name%", old_name).replace("%buyer%", playerName).replace("%price%", this.instance.getMain().getPrice(price)).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                                }
                            } else {
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                            }
                        })).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                        return;
                    }
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cannot-claim-because-claim-near")));
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
            player.sendMessage(this.instance.getLanguage().getMessage("claim-is-not-in-sale"));
            return;
        }
        if (args[0].equalsIgnoreCase("fly")) {
            if (this.instance.isFolia()) {
                player.sendMessage(this.instance.getLanguage().getMessage("fly-disabled-on-this-server"));
                return;
            }
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.fly")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaimFromChunk(chunk);
            if (claim.getOwner().equals(playerName)) {
                if (cPlayer.getClaimFly().booleanValue()) {
                    this.instance.getPlayerMain().removePlayerFly(player);
                    player.sendMessage(this.instance.getLanguage().getMessage("fly-disabled"));
                    return;
                }
                this.instance.getPlayerMain().activePlayerFly(player);
                player.sendMessage(this.instance.getLanguage().getMessage("fly-enabled"));
                return;
            }
            if (!claim.getPermissionForPlayer("Fly", player)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-fly-in-this-claim"));
                return;
            }
            if (cPlayer.getClaimFly().booleanValue()) {
                this.instance.getPlayerMain().removePlayerFly(player);
                player.sendMessage(this.instance.getLanguage().getMessage("fly-disabled"));
                return;
            }
            this.instance.getPlayerMain().activePlayerFly(player);
            player.sendMessage(this.instance.getLanguage().getMessage("fly-enabled"));
            return;
        }
        if (args[0].equalsIgnoreCase("autofly")) {
            Claim claim;
            if (this.instance.isFolia()) {
                player.sendMessage(this.instance.getLanguage().getMessage("fly-disabled-on-this-server"));
                return;
            }
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.autofly")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (cPlayer.getClaimAutofly().booleanValue()) {
                cPlayer.setClaimAutofly(false);
                player.sendMessage(this.instance.getLanguage().getMessage("autofly-disabled"));
                return;
            }
            cPlayer.setClaimAutofly(true);
            player.sendMessage(this.instance.getLanguage().getMessage("autofly-enabled"));
            Chunk chunk = player.getLocation().getChunk();
            if (this.instance.getMain().checkIfClaimExists(chunk) && ((claim = this.instance.getMain().getClaimFromChunk(chunk)).getOwner().equals(playerName) || claim.getPermissionForPlayer("Fly", player))) {
                if (cPlayer.getClaimFly().booleanValue()) {
                    return;
                }
                this.instance.getPlayerMain().activePlayerFly(player);
                player.sendMessage(this.instance.getLanguage().getMessage("fly-enabled"));
                return;
            }
            return;
        }
        if (args[0].equalsIgnoreCase("chat")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.chat")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            if (cPlayer.getClaimChat().booleanValue()) {
                cPlayer.setClaimChat(false);
                player.sendMessage(this.instance.getLanguage().getMessage("talking-now-in-public"));
                return;
            }
            cPlayer.setClaimChat(true);
            player.sendMessage(this.instance.getLanguage().getMessage("talking-now-in-claim"));
            return;
        }
        if (args[0].equalsIgnoreCase("automap")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.automap")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            if (cPlayer.getClaimAutomap().booleanValue()) {
                cPlayer.setClaimAutomap(false);
                player.sendMessage(this.instance.getLanguage().getMessage("automap-off"));
                if (this.instance.getSettings().getSetting("map-type").equals("scoreboard")) {
                    cPlayer.getScoreboard().removeFromPlayer(player);
                    cPlayer.setScoreboard(null);
                }
                return;
            }
            cPlayer.setClaimAutomap(true);
            player.sendMessage(this.instance.getLanguage().getMessage("automap-on"));
            if (this.instance.getSettings().getSetting("map-type").equals("scoreboard")) {
                CScoreboard cScoreboard = new CScoreboard("\u00a7b\u00a7lClaims Map");
                this.instance.getMain().getMap(player, player.getLocation().getChunk(), true);
                cPlayer.setScoreboard(cScoreboard);
                cScoreboard.showToPlayer(player);
            } else {
                this.instance.getMain().getMap(player, player.getLocation().getChunk(), true);
            }
            return;
        }
        if (args[0].equalsIgnoreCase("map")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.map")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            this.instance.getMain().getMap(player, player.getLocation().getChunk(), false);
            return;
        }
        if (args[0].equalsIgnoreCase("autoaddchunk")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.autoaddchunk")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            if (cPlayer.getClaimAuto().equals("addchunk")) {
                cPlayer.setClaimAuto("");
                player.sendMessage(this.instance.getLanguage().getMessage("autoaddchunk-off"));
            } else {
                player.sendMessage(this.instance.getLanguage().getMessage("autoaddchunk-not-enabled"));
            }
            return;
        }
        if (args[0].equalsIgnoreCase("autodelchunk")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.autoaddchunk")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            if (cPlayer.getClaimAuto().equals("delchunk")) {
                cPlayer.setClaimAuto("");
                player.sendMessage(this.instance.getLanguage().getMessage("autodelchunk-off"));
            } else {
                player.sendMessage(this.instance.getLanguage().getMessage("autodelchunk-not-enabled"));
            }
            return;
        }
        if (args[0].equalsIgnoreCase("autoclaim")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.autoclaim")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            if (cPlayer.getClaimAuto().equals("claim")) {
                cPlayer.setClaimAuto("");
                player.sendMessage(this.instance.getLanguage().getMessage("autoclaim-off"));
                return;
            }
            cPlayer.setClaimAuto("claim");
            player.sendMessage(this.instance.getLanguage().getMessage("autoclaim-on"));
            return;
        }
        if (args[0].equalsIgnoreCase("autounclaim")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.autounclaim")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            if (cPlayer.getClaimAuto().equals("unclaim")) {
                cPlayer.setClaimAuto("");
                player.sendMessage(this.instance.getLanguage().getMessage("autounclaim-off"));
                return;
            }
            cPlayer.setClaimAuto("unclaim");
            player.sendMessage(this.instance.getLanguage().getMessage("autounclaim-on"));
            return;
        }
        if (args[0].equalsIgnoreCase("setspawn")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.setspawn")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            Location l = player.getLocation();
            ((CompletableFuture)this.instance.getMain().setClaimLocation(claim, l).thenAccept(success -> {
                if (success.booleanValue()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("loc-change-success").replace("%coords%", this.instance.getMain().getClaimCoords(claim))));
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("settings")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.settings")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                new BClaimSettingsGui(player, claim, this.instance);
                return;
            }
            new ClaimSettingsGui(player, claim, this.instance, "visitors");
            return;
        }
        if (args[0].equalsIgnoreCase("chunks")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.chunks")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                new BClaimChunksGui(player, claim, this.instance);
                return;
            }
            new ClaimChunksGui(player, claim, 1, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("members")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.members")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                new BClaimMembersGui(player, claim, this.instance);
                return;
            }
            new ClaimMembersGui(player, claim, 1, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("bans")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.bans")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                return;
            }
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (!owner.equals(playerName)) {
                player.sendMessage(this.instance.getLanguage().getMessage("territory-not-yours"));
                return;
            }
            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                new BClaimBansGui(player, claim, this.instance);
                return;
            }
            new ClaimBansGui(player, claim, 1, this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("list")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.list")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            cPlayer.setClaim(null);
            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                new BClaimListGui(player, this.instance, "owner");
                return;
            }
            new ClaimListGui(player, 1, "owner", this.instance);
            return;
        }
        if (args[0].equalsIgnoreCase("see")) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.see")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            Chunk chunk = player.getLocation().getChunk();
            Claim claim = this.instance.getMain().getClaim(chunk);
            this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)(claim == null ? Set.of(player.getLocation().getChunk()) : claim.getChunks())), false, false);
            return;
        }
        try {
            int radius = Integer.parseInt(args[0]);
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.radius")) {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
                return;
            }
            String world = player.getWorld().getName();
            if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
                player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
                return;
            }
            if (!cPlayer.canRadiusClaim(radius)) {
                player.sendMessage(this.instance.getLanguage().getMessage("cant-radius-claim"));
                return;
            }
            ClaimCommand.getChunksInRadius(player, player.getLocation(), radius, this.instance).thenAccept(chunks -> {
                CustomSet chunksToClaim = chunks.stream().filter(c -> !this.instance.getMain().checkIfClaimExists((Chunk)c)).collect(Collectors.toCollection(CustomSet::new));
                if (chunks.size() != chunksToClaim.size()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cant-radius-claim-already-claim")));
                    return;
                }
                ((CompletableFuture)this.instance.getMain().isAreaClaimFree(player.getLocation().getChunk(), cPlayer.getClaimDistance() + radius, playerName).thenAccept(successs -> {
                    if (successs.booleanValue()) {
                        if (!cPlayer.canClaim()) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-anymore")));
                            return;
                        }
                        if (!cPlayer.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(playerName).size() + chunksToClaim.size())) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks")));
                            return;
                        }
                        if (!cPlayer.canClaimWithNumber(chunksToClaim.size())) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks")));
                            return;
                        }
                        double[] price = new double[]{0.0};
                        if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("claim-cost")) {
                            price[0] = this.instance.getMain().calculateClaimPrice(cPlayer, chunksToClaim.size());
                            double balance = this.instance.getVault().getPlayerBalance(playerName);
                            if (balance < price[0]) {
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("buy-but-not-enough-money-claim").replace("%missing-price%", this.instance.getMain().getNumberSeparate(String.valueOf((double)Math.round((price[0] - balance) * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                                return;
                            }
                        }
                        if (this.instance.getSettings().getBooleanSetting("claim-confirmation")) {
                            if (isOnCreate.containsKey(player)) {
                                isOnCreate.remove(player);
                                if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("claim-cost")) {
                                    this.instance.getVault().removePlayerBalance(playerName, price[0]);
                                    if (price[0] > 0.0) {
                                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("you-paid-claim").replace("%price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round(price[0] * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                                    }
                                }
                                ((CompletableFuture)this.instance.getMain().createClaimRadius(player, new CustomSet<Chunk>((Collection<Chunk>)chunks), radius).thenAccept(success -> {
                                    if (success.booleanValue()) {
                                        if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                                            this.instance.getMain().displayChunkBorderWithRadius(player, radius);
                                        }
                                        this.instance.executeAsyncLocation(() -> {
                                            Claim claim = this.instance.getMain().getClaim(player.getLocation().getChunk());
                                            int remainingClaims = cPlayer.getMaxClaims() - cPlayer.getClaimsCount();
                                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("create-claim-radius-success").replace("%number%", this.instance.getMain().getNumberSeparate(String.valueOf(chunks.size()))).replace("%remaining-claims%", this.instance.getMain().getNumberSeparate(String.valueOf(remainingClaims))).replace("%claim-name%", claim.getName())));
                                        }, player.getLocation());
                                    } else {
                                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                                    }
                                })).exceptionally(ex -> {
                                    ex.printStackTrace();
                                    return null;
                                });
                                return;
                            }
                            isOnCreate.put(player, radius);
                            if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                                new BClaimConfirmationGui(player, this.instance, price[0]);
                                return;
                            }
                            new ClaimConfirmationGui(player, this.instance, price[0]);
                            return;
                        }
                        if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("claim-cost")) {
                            this.instance.getVault().removePlayerBalance(playerName, price[0]);
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("you-paid-claim").replace("%price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round(price[0] * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                        }
                    } else {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cannot-claim-because-claim-near")));
                        return;
                    }
                    ((CompletableFuture)this.instance.getMain().createClaimRadius(player, new CustomSet<Chunk>((Collection<Chunk>)chunks), radius).thenAccept(success -> {
                        if (success.booleanValue()) {
                            if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                                this.instance.getMain().displayChunkBorderWithRadius(player, radius);
                            }
                            this.instance.executeAsyncLocation(() -> {
                                Claim claim = this.instance.getMain().getClaim(player.getLocation().getChunk());
                                int remainingClaims = cPlayer.getMaxClaims() - cPlayer.getClaimsCount();
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("create-claim-radius-success").replace("%number%", this.instance.getMain().getNumberSeparate(String.valueOf(chunks.size()))).replace("%remaining-claims%", this.instance.getMain().getNumberSeparate(String.valueOf(remainingClaims))).replace("%claim-name%", claim.getName())));
                            }, player.getLocation());
                        } else {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                        }
                    })).exceptionally(ex -> {
                        ex.printStackTrace();
                        return null;
                    });
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
            });
            return;
        }
        catch (NumberFormatException e) {
            if (commands.contains(args[0].toLowerCase()) && player.hasPermission("scs.command.claim." + args[0].toLowerCase())) {
                this.instance.getMain().getHelp(player, args[0], "claim");
            } else {
                player.sendMessage(this.instance.getLanguage().getMessage("cmd-no-permission"));
            }
            return;
        }
    }

    private void handleArgZero(Player player, String playerName, CPlayer cPlayer) {
        Chunk chunk = player.getLocation().getChunk();
        if (this.instance.getMain().checkIfClaimExists(chunk)) {
            Claim claim = this.instance.getMain().getClaim(chunk);
            String owner = claim.getOwner();
            if (owner.equals("*")) {
                player.sendMessage(this.instance.getLanguage().getMessage("create-error-protected-area"));
            } else if (owner.equals(player.getName())) {
                if (this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.main")) {
                    if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                        new BClaimMainGui(player, claim, this.instance);
                        return;
                    }
                    new ClaimMainGui(player, claim, this.instance);
                } else {
                    player.sendMessage(this.instance.getLanguage().getMessage("create-already-yours"));
                }
            } else {
                player.sendMessage(this.instance.getLanguage().getMessage("create-already-claim").replace("%player%", owner));
            }
            return;
        }
        String world = player.getWorld().getName();
        if (this.instance.getSettings().getWorldMode(world) == WorldMode.DISABLED) {
            player.sendMessage(this.instance.getLanguage().getMessage("world-disabled").replace("%world%", this.instance.getSettings().getWorldAliase(world)));
            return;
        }
        if (this.instance.getSettings().getBooleanSetting("worldguard") && !this.instance.getWorldGuard().checkFlagClaim(player)) {
            player.sendMessage(this.instance.getLanguage().getMessage("worldguard-cannot-claim-in-region"));
            return;
        }
        if (this.instance.getSettings().getBooleanSetting("claim-confirmation")) {
            ((CompletableFuture)this.instance.getMain().isAreaClaimFree(chunk, cPlayer.getClaimDistance(), playerName).thenAccept(successs -> {
                if (successs.booleanValue()) {
                    if (!cPlayer.canClaim()) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-anymore")));
                        return;
                    }
                    if (!cPlayer.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(playerName).size() + 1)) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks")));
                        return;
                    }
                    double[] price = new double[]{0.0};
                    if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("claim-cost")) {
                        price[0] = this.instance.getSettings().getBooleanSetting("claim-cost-multiplier") ? cPlayer.getMultipliedCost().doubleValue() : cPlayer.getCost();
                        double balance = this.instance.getVault().getPlayerBalance(playerName);
                        if (balance < price[0]) {
                            this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("buy-but-not-enough-money-claim").replace("%missing-price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round((price[0] - balance) * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                            return;
                        }
                    }
                    if (isOnCreate.containsKey(player)) {
                        isOnCreate.remove(player);
                        if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("claim-cost")) {
                            this.instance.getVault().removePlayerBalance(playerName, price[0]);
                            if (price[0] > 0.0) {
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("you-paid-claim").replace("%price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round(price[0] * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                            }
                        }
                        ((CompletableFuture)this.instance.getMain().createClaim(player, chunk).thenAccept(success -> {
                            if (success.booleanValue()) {
                                int remainingClaims = cPlayer.getMaxClaims() - cPlayer.getClaimsCount();
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("create-claim-success").replace("%remaining-claims%", this.instance.getMain().getNumberSeparate(String.valueOf(remainingClaims)))));
                                if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                                    this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)Set.of(chunk)), true, false);
                                }
                            } else {
                                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                            }
                        })).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                    } else {
                        isOnCreate.put(player, 0);
                        if (this.instance.getSettings().getBooleanSetting("floodgate") && FloodgateApi.getInstance().isFloodgatePlayer(player.getUniqueId())) {
                            new BClaimConfirmationGui(player, this.instance, price[0]);
                            return;
                        }
                        new ClaimConfirmationGui(player, this.instance, price[0]);
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cannot-claim-because-claim-near")));
                    return;
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        ((CompletableFuture)this.instance.getMain().isAreaClaimFree(chunk, cPlayer.getClaimDistance(), playerName).thenAccept(successs -> {
            if (successs.booleanValue()) {
                if (!cPlayer.canClaim()) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-anymore")));
                    return;
                }
                if (!cPlayer.canClaimTotalWithNumber(this.instance.getMain().getAllChunksFromAllClaims(playerName).size() + 1)) {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cant-claim-with-so-many-chunks")));
                    return;
                }
                if (this.instance.getSettings().getBooleanSetting("economy") && this.instance.getSettings().getBooleanSetting("claim-cost")) {
                    double price = this.instance.getSettings().getBooleanSetting("claim-cost-multiplier") ? cPlayer.getMultipliedCost().doubleValue() : cPlayer.getCost();
                    double balance = this.instance.getVault().getPlayerBalance(playerName);
                    if (balance < price) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("buy-but-not-enough-money-claim").replace("%missing-price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round((price - balance) * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                        return;
                    }
                    this.instance.getVault().removePlayerBalance(playerName, price);
                    if (price > 0.0) {
                        this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("you-paid-claim").replace("%price%", this.instance.getMain().getPrice(String.valueOf((double)Math.round(price * 100.0) / 100.0))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol"))));
                    }
                }
            } else {
                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("cannot-claim-because-claim-near")));
                return;
            }
            ((CompletableFuture)this.instance.getMain().createClaim(player, chunk).thenAccept(success -> {
                if (success.booleanValue()) {
                    int remainingClaims = cPlayer.getMaxClaims() - cPlayer.getClaimsCount();
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("create-claim-success").replace("%remaining-claims%", String.valueOf(remainingClaims))));
                    if (this.instance.getSettings().getBooleanSetting("claim-particles")) {
                        this.instance.getMain().displayChunks(player, new CustomSet<Chunk>((Collection<Chunk>)Set.of(chunk)), true, false);
                    }
                } else {
                    this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("error")));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    private List<String> getPrimaryCompletions(Player player, String partialInput) {
        ArrayList<String> completions = new ArrayList<String>();
        for (String command : commands) {
            if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim." + command)) continue;
            completions.add(command);
        }
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }

    private List<String> getSecondaryCompletions(Player player, String arg, String playerName, Chunk chunk, String partialInput) {
        ArrayList<String> completions = new ArrayList<String>();
        ClaimMain main = this.instance.getMain();
        if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim." + arg)) {
            return completions;
        }
        switch (arg.toLowerCase()) {
            case "accept": 
            case "deny": {
                completions.addAll(invitations.entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsKey(player)).map(entry -> ((Player)entry.getKey()).getName()).collect(Collectors.toList()));
                break;
            }
            case "cancelinv": {
                if (!invitations.containsKey(player) || invitations.get(player) == null) break;
                completions.addAll(invitations.get(player).keySet().stream().map(entry -> entry.getName()).collect(Collectors.toList()));
                break;
            }
            case "see": {
                if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.see.others")) break;
                completions.addAll(main.getClaimsOwners());
                break;
            }
            case "merge": 
            case "setname": 
            case "chat": 
            case "setdesc": 
            case "settings": 
            case "tp": 
            case "sell": 
            case "main": 
            case "addchunk": 
            case "delchunk": 
            case "chunks": 
            case "members": 
            case "bans": 
            case "autoaddchunk": 
            case "autodelchunk": {
                completions.addAll(main.getClaimsNameFromOwner(playerName));
                break;
            }
            case "cancel": {
                completions.addAll(this.instance.getMain().getClaimsNameInSaleFromOwner(playerName));
                break;
            }
            case "add": {
                if (main.checkIfClaimExists(chunk) && main.getClaim(chunk).getOwner().equals(playerName)) {
                    completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                    completions.remove(playerName);
                }
                completions.add("*");
                completions.addAll(main.getClaimsNameFromOwner(playerName));
                break;
            }
            case "ban": {
                if (main.checkIfClaimExists(chunk) && main.getClaim(chunk).getOwner().equals(playerName)) {
                    completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                    completions.remove(playerName);
                }
                completions.add("*");
                completions.addAll(main.getClaimsNameFromOwner(playerName));
                break;
            }
            case "unban": {
                Claim claim;
                if (main.checkIfClaimExists(chunk) && (claim = main.getClaim(chunk)).getOwner().equals(playerName)) {
                    completions.addAll(this.instance.getMain().convertUUIDSetToStringSet(claim.getBans()));
                }
                completions.add("*");
                completions.addAll(main.getClaimsNameFromOwner(playerName));
                break;
            }
            case "remove": {
                Claim claim;
                if (main.checkIfClaimExists(chunk) && (claim = main.getClaim(chunk)).getOwner().equals(playerName)) {
                    completions.addAll(this.instance.getMain().convertUUIDSetToStringSet(claim.getMembers()));
                    completions.remove(playerName);
                }
                completions.add("*");
                completions.addAll(main.getClaimsNameFromOwner(playerName));
                break;
            }
            case "owner": 
            case "kick": {
                if (main.checkIfClaimExists(chunk) && main.getClaim(chunk).getOwner().equals(playerName)) {
                    completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                    completions.remove(playerName);
                }
                completions.addAll(main.getClaimsNameFromOwner(playerName));
                completions.add("*");
                break;
            }
        }
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }

    private List<String> getTertiaryCompletions(Player player, String arg, String arg1, String playerName, String partialInput) {
        ArrayList<String> completions = new ArrayList<String>();
        ClaimMain main = this.instance.getMain();
        if (!this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim." + arg)) {
            return completions;
        }
        Claim claim = this.instance.getMain().getClaimByName(arg1, player);
        switch (arg.toLowerCase()) {
            case "remove": {
                if (!arg1.equals("*") && claim != null) {
                    completions.addAll(this.instance.getMain().convertUUIDSetToStringSet(claim.getMembers()));
                }
                completions.remove(playerName);
                break;
            }
            case "merge": {
                completions.add("*");
                completions.addAll(main.getClaimsNameFromOwner(playerName));
                completions.remove(arg1);
                break;
            }
            case "unban": {
                if (claim == null) break;
                completions.addAll(this.instance.getMain().convertUUIDSetToStringSet(claim.getBans()));
                break;
            }
            case "add": 
            case "ban": 
            case "owner": 
            case "kick": {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                completions.remove(playerName);
                break;
            }
            case "delchunk": {
                claim = main.getClaimByName(arg1, player);
                if (claim == null) break;
                completions.addAll(this.instance.getMain().getStringChunkFromClaim(claim));
                break;
            }
        }
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }

    public static CompletableFuture<Set<Chunk>> getChunksInRadius(Player player, Location center, int radius, SimpleClaimSystem instance) {
        player.sendMessage(instance.getLanguage().getMessage("chunk-are-loading").replace("%chunks-count%", instance.getMain().getNumberSeparate(String.valueOf(ClaimCommand.calculateNumberOfChunks(radius)))));
        ConcurrentHashMap.KeySetView chunks = ConcurrentHashMap.newKeySet();
        World world = center.getWorld();
        Chunk centerChunk = center.getChunk();
        int centerX = centerChunk.getX();
        int centerZ = centerChunk.getZ();
        AtomicInteger loadedChunks = new AtomicInteger(0);
        int totalChunks = ClaimCommand.calculateNumberOfChunks(radius);
        if (instance.isFolia()) {
            List<CompletableFuture> futures = IntStream.rangeClosed(centerX - radius, centerX + radius).parallel().boxed().flatMap(x -> IntStream.rangeClosed(centerZ - radius, centerZ + radius).mapToObj(z -> ((CompletableFuture)world.getChunkAtAsync(x.intValue(), z).thenAccept(chunk -> {
                chunks.add(chunk);
                int count = loadedChunks.incrementAndGet();
                if (count % 1000 == 0) {
                    instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("chunk-while-loading").replace("%loaded-chunks%", instance.getMain().getNumberSeparate(String.valueOf(count))).replace("%chunks-count%", instance.getMain().getNumberSeparate(String.valueOf(totalChunks)))));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            }))).collect(Collectors.toList());
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> chunks);
        }
        return CompletableFuture.runAsync(() -> IntStream.rangeClosed(centerX - radius, centerX + radius).parallel().boxed().flatMap(x -> IntStream.rangeClosed(centerZ - radius, centerZ + radius).mapToObj(z -> {
            Chunk chunk = world.getChunkAt(x.intValue(), z);
            chunks.add(chunk);
            int count = loadedChunks.incrementAndGet();
            if (count % 1000 == 0) {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("chunk-while-loading").replace("%loaded-chunks%", instance.getMain().getNumberSeparate(String.valueOf(count))).replace("%chunks-count%", instance.getMain().getNumberSeparate(String.valueOf(totalChunks)))));
            }
            return chunk;
        })).collect(Collectors.toList())).thenApply(v -> chunks);
    }

    public static int calculateNumberOfChunks(int radius) {
        int sideLength = 2 * radius + 1;
        return sideLength * sideLength;
    }

    public boolean areChunksLinked(Set<Chunk> chunks) {
        if (chunks.isEmpty()) {
            return true;
        }
        HashSet<ChunkCoord> chunkCoords = new HashSet<ChunkCoord>();
        for (Chunk chunk : chunks) {
            chunkCoords.add(new ChunkCoord(chunk.getX(), chunk.getZ()));
        }
        ChunkCoord start = (ChunkCoord)chunkCoords.iterator().next();
        HashSet<ChunkCoord> visited = new HashSet<ChunkCoord>();
        Stack<ChunkCoord> toVisit = new Stack<ChunkCoord>();
        toVisit.add(start);
        while (!toVisit.isEmpty()) {
            ChunkCoord current = (ChunkCoord)toVisit.pop();
            if (visited.contains(current)) continue;
            visited.add(current);
            for (ChunkCoord neighbor : current.getAdjacentChunks()) {
                if (!chunkCoords.contains(neighbor) || visited.contains(neighbor)) continue;
                toVisit.add(neighbor);
            }
        }
        return visited.size() == chunkCoords.size();
    }

    private /* synthetic */ void lambda$handleArgThree$60(Player player, Player target, LocalDateTime date, String playerName, String targetName) {
        if (player != null && target != null && invitations.containsKey(player) && invitations.get(player).containsKey(target) && invitations.get(player).get(target).equals("*") && invitationsTime.containsKey(player) && invitationsTime.get(player).containsKey(target) && invitationsTime.get(player).get(target) == date) {
            if (target.isOnline()) {
                this.instance.executeEntitySync(target, () -> target.sendMessage(this.instance.getLanguage().getMessage("player-invitation-expired-other").replace("%player%", playerName)));
            }
            if (player.isOnline()) {
                this.instance.executeEntitySync(player, () -> player.sendMessage(this.instance.getLanguage().getMessage("player-invitation-expired").replace("%player%", targetName)));
            }
            invitations.get(player).remove(target);
            if (invitations.get(player).isEmpty()) {
                invitations.remove(player);
            }
            invitationsTime.get(player).remove(target);
            if (invitationsTime.get(player).isEmpty()) {
                invitationsTime.remove(player);
            }
        }
    }

    private class ChunkCoord {
        private final int x;
        private final int z;

        public ChunkCoord(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public Set<ChunkCoord> getAdjacentChunks() {
            HashSet<ChunkCoord> adjacent = new HashSet<ChunkCoord>();
            adjacent.add(new ChunkCoord(this.x + 1, this.z));
            adjacent.add(new ChunkCoord(this.x - 1, this.z));
            adjacent.add(new ChunkCoord(this.x, this.z + 1));
            adjacent.add(new ChunkCoord(this.x, this.z - 1));
            return adjacent;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkCoord other = (ChunkCoord)obj;
            return this.x == other.x && this.z == other.z;
        }

        public int hashCode() {
            return 31 * this.x + this.z;
        }
    }
}

