/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Commands;

import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimMainGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionClaimsOwnerGui;
import fr.xyness.SCS.Guis.AdminGestion.AdminGestionMainGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ScsCommand
implements CommandExecutor,
TabCompleter {
    private SimpleClaimSystem instance;

    public ScsCommand(SimpleClaimSystem instance) {
        this.instance = instance;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        CompletableFuture<List> future = CompletableFuture.supplyAsync(() -> {
            ArrayList<String> completions = new ArrayList<String>();
            if (args.length == 1) {
                completions.addAll(this.getPrimaryCompletions(args));
            } else if (args.length == 2) {
                completions.addAll(this.getSecondaryCompletions(sender, args));
            } else if (args.length == 3) {
                completions.addAll(this.getTertiaryCompletions(sender, args));
            } else {
                if (args.length == 4 && args[0].equalsIgnoreCase("player") && (args[1].equalsIgnoreCase("tp") || args[1].equalsIgnoreCase("unclaim") || args[1].equalsIgnoreCase("main"))) {
                    String partialInput = args.length > 3 ? args[3].toLowerCase() : "";
                    completions.addAll(this.instance.getMain().getClaimsNameFromOwner(args[2]));
                    if (args[1].equalsIgnoreCase("unclaim")) {
                        completions.add("*");
                    }
                    return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
                }
                if (args.length == 4) {
                    completions.addAll(this.getFourCompletions(sender, args));
                }
            }
            return completions;
        });
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            return new ArrayList<String>();
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 1: {
                this.handleArgOne(sender, args);
                break;
            }
            case 2: {
                this.handleArgTwo(sender, args);
                break;
            }
            case 3: {
                this.handleArgThree(sender, args);
                break;
            }
            case 4: {
                this.handleArgFour(sender, args);
                break;
            }
            default: {
                this.instance.getMain().getHelp(sender, "no arg", "scs");
            }
        }
        return true;
    }

    private void handleArgOne(CommandSender sender, String[] args) {
        if (args[0].equalsIgnoreCase("reload")) {
            this.instance.loadConfig(true, sender);
            return;
        }
        if (args[0].equalsIgnoreCase("config-reload")) {
            this.instance.reloadOnlyConfig(sender);
            return;
        }
        if (args[0].equalsIgnoreCase("import-griefprevention")) {
            if (!this.instance.getSettings().getBooleanSetting("griefprevention")) {
                sender.sendMessage(this.instance.getLanguage().getMessage("griefprevention-needed"));
                return;
            }
            this.instance.getMain().importFromGriefPrevention(sender);
            return;
        }
        if (args[0].equalsIgnoreCase("import-xclaims")) {
            File file = new File("plugins/SimpleClaimSystem/xclaims.yml");
            if (!file.exists()) {
                sender.sendMessage(this.instance.getLanguage().getMessage("xclaims-needed"));
                return;
            }
            this.instance.getMain().importFromXClaims(sender);
            return;
        }
        if (args[0].equalsIgnoreCase("transfer")) {
            if (!this.instance.getSettings().getBooleanSetting("database")) {
                sender.sendMessage(this.instance.getLanguage().getMessage("not-using-database"));
                return;
            }
            this.instance.getMain().transferClaims();
            return;
        }
        if (args[0].equalsIgnoreCase("reset-all-player-claims-settings")) {
            ((CompletableFuture)this.instance.getMain().resetAllPlayerClaimsSettings().thenAccept(success -> {
                if (success.booleanValue()) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("reset-of-player-claims-settings-successful"));
                } else {
                    sender.sendMessage(this.instance.getLanguage().getMessage("error"));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (args[0].equalsIgnoreCase("reset-all-admin-claims-settings")) {
            ((CompletableFuture)this.instance.getMain().resetAllOwnerClaimsSettings("*").thenAccept(success -> {
                if (success.booleanValue()) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("reset-of-admin-claims-settings-successful"));
                } else {
                    sender.sendMessage(this.instance.getLanguage().getMessage("error"));
                }
            })).exceptionally(ex -> {
                ex.printStackTrace();
                return null;
            });
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args[0].equalsIgnoreCase("admin")) {
                new AdminGestionMainGui(player, this.instance);
                return;
            }
            if (args[0].equalsIgnoreCase("setexpulsionlocation")) {
                Location loc = player.getLocation();
                this.instance.setExpulsionLocation(loc);
                player.sendMessage(this.instance.getLanguage().getMessage("expulsion-set"));
                return;
            }
            if (args[0].equalsIgnoreCase("forceunclaim")) {
                Chunk chunk = player.getLocation().getChunk();
                if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                    player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                    return;
                }
                Claim claim = this.instance.getMain().getClaim(chunk);
                String owner = claim.getOwner();
                ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                    if (success.booleanValue()) {
                        player.sendMessage(this.instance.getLanguage().getMessage("forceunclaim-success").replace("%owner%", owner));
                    } else {
                        player.sendMessage(this.instance.getLanguage().getMessage("error"));
                    }
                })).exceptionally(ex -> {
                    ex.printStackTrace();
                    return null;
                });
                return;
            }
        }
        this.instance.getMain().getHelp(sender, args[0], "scs");
    }

    private void handleArgTwo(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args[0].equalsIgnoreCase("setowner")) {
                Player target = Bukkit.getPlayer((String)args[1]);
                String[] targetName = new String[]{""};
                Runnable task = () -> this.instance.executeSync(() -> {
                    Chunk chunk = player.getLocation().getChunk();
                    if (!this.instance.getMain().checkIfClaimExists(chunk)) {
                        player.sendMessage(this.instance.getLanguage().getMessage("free-territory"));
                        return;
                    }
                    Claim claim = this.instance.getMain().getClaim(chunk);
                    ((CompletableFuture)this.instance.getMain().setOwner(targetName[0], claim).thenAccept(success -> {
                        if (success.booleanValue()) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("setowner-success").replace("%owner%", targetName[0]));
                        }
                    })).exceptionally(ex -> null);
                });
                if (target == null) {
                    this.instance.getOfflinePlayer(args[1], otarget -> {
                        if (otarget == null || !otarget.hasPlayedBefore()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[1]));
                            return;
                        }
                        targetName[0] = otarget.getName();
                        task.run();
                    });
                } else {
                    targetName[0] = target.getName();
                    task.run();
                }
                return;
            }
        }
        if (args[0].equalsIgnoreCase("set-lang")) {
            this.instance.reloadLang(sender, args[1]);
            return;
        }
        this.instance.getMain().getHelp(sender, args[0], "scs");
    }

    private void handleArgThree(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args[0].equalsIgnoreCase("player") && args[1].equalsIgnoreCase("list")) {
                if (!this.instance.getMain().getClaimsOwners().contains(args[2])) {
                    player.sendMessage(this.instance.getLanguage().getMessage("player-does-not-have-claim"));
                    return;
                }
                new AdminGestionClaimsOwnerGui(player, 1, "all", args[2], this.instance);
                return;
            }
        }
        this.instance.getMain().getHelp(sender, args[0], "scs");
    }

    private void handleArgFour(CommandSender sender, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (args[0].equalsIgnoreCase("setowner")) {
                Player target = Bukkit.getPlayer((String)args[1]);
                String[] targetName = new String[]{""};
                UUID[] uuid = new UUID[]{null};
                Runnable task = () -> this.instance.executeSync(() -> {
                    if (!this.instance.getMain().getClaimsOwners().contains(targetName[0])) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-does-not-have-claim"));
                        return;
                    }
                    if (args[2].equals("*")) {
                        Player newOwner = Bukkit.getPlayer((String)args[3]);
                        String[] ownerName = new String[]{""};
                        Runnable subtask = () -> this.instance.executeSync(() -> ((CompletableFuture)this.instance.getMain().setOwner(ownerName[0], this.instance.getMain().getPlayerClaims(targetName[0]), targetName[0]).thenAccept(success -> {
                            if (success.booleanValue()) {
                                sender.sendMessage(this.instance.getLanguage().getMessage("setowner-all-other-success").replace("%owner%", ownerName[0]).replace("%old-owner%", targetName[0]));
                            }
                        })).exceptionally(ex -> null));
                        if (newOwner == null) {
                            this.instance.getOfflinePlayer(args[1], otarget -> {
                                if (otarget == null || !otarget.hasPlayedBefore()) {
                                    player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[1]));
                                    return;
                                }
                                ownerName[0] = otarget.getName();
                                subtask.run();
                            });
                        } else {
                            ownerName[0] = newOwner.getName();
                            subtask.run();
                        }
                    } else {
                        if (!this.instance.getMain().getClaimsNameFromOwner(targetName[0]).contains(args[2])) {
                            player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                            return;
                        }
                        Player newOwner = Bukkit.getPlayer((String)args[3]);
                        String[] ownerName = new String[]{""};
                        Runnable subtask = () -> this.instance.executeSync(() -> {
                            Claim claim = this.instance.getMain().getClaimByName(args[2], uuid[0]);
                            ((CompletableFuture)this.instance.getMain().setOwner(ownerName[0], claim).thenAccept(success -> {
                                if (success.booleanValue()) {
                                    sender.sendMessage(this.instance.getLanguage().getMessage("setowner-claim-other-success").replace("%owner%", ownerName[0]).replace("%old-owner%", targetName[0]).replace("%claim-name%", claim.getName()));
                                }
                            })).exceptionally(ex -> null);
                        });
                        if (newOwner == null) {
                            this.instance.getOfflinePlayer(args[1], otarget -> {
                                if (otarget == null || !otarget.hasPlayedBefore()) {
                                    player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[1]));
                                    return;
                                }
                                ownerName[0] = otarget.getName();
                                subtask.run();
                            });
                        } else {
                            ownerName[0] = newOwner.getName();
                            subtask.run();
                        }
                    }
                });
                if (target == null) {
                    this.instance.getOfflinePlayer(args[1], otarget -> {
                        if (otarget == null || !otarget.hasPlayedBefore()) {
                            player.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[1]));
                            return;
                        }
                        targetName[0] = otarget.getName();
                        uuid[0] = otarget.getUniqueId();
                        task.run();
                    });
                } else {
                    targetName[0] = target.getName();
                    uuid[0] = target.getUniqueId();
                    task.run();
                }
                return;
            }
            if (args[0].equalsIgnoreCase("player")) {
                if (args[1].equalsIgnoreCase("main")) {
                    if (!this.instance.getMain().getClaimsOwners().contains(args[2])) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-does-not-have-claim"));
                        return;
                    }
                    if (!this.instance.getMain().getClaimsNameFromOwner(args[2]).contains(args[3])) {
                        player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                        return;
                    }
                    this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                        Claim claim = this.instance.getMain().getClaimByName(args[3], p.getUniqueId());
                        new AdminGestionClaimMainGui(player, claim, this.instance);
                    }));
                    return;
                }
                if (args[1].equalsIgnoreCase("tp")) {
                    if (!this.instance.getMain().getClaimsOwners().contains(args[2])) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-does-not-have-claim"));
                        return;
                    }
                    if (!this.instance.getMain().getClaimsNameFromOwner(args[2]).contains(args[3])) {
                        player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                        return;
                    }
                    this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                        Claim claim = this.instance.getMain().getClaimByName(args[3], p.getUniqueId());
                        Location loc = claim.getLocation();
                        if (this.instance.isFolia()) {
                            player.teleportAsync(loc);
                        } else {
                            player.teleport(loc);
                        }
                        player.sendMessage(this.instance.getLanguage().getMessage("player-teleport-to-other-claim-aclaim").replace("%name%", args[3]).replace("%player%", args[2]));
                    }));
                    return;
                }
                if (args[1].equalsIgnoreCase("unclaim")) {
                    if (!this.instance.getMain().getClaimsOwners().contains(args[2])) {
                        player.sendMessage(this.instance.getLanguage().getMessage("player-does-not-have-claim"));
                        return;
                    }
                    if (args[3].equalsIgnoreCase("*")) {
                        ((CompletableFuture)this.instance.getMain().deleteAllClaims(args[2]).thenAccept(success -> {
                            if (success.booleanValue()) {
                                player.sendMessage(this.instance.getLanguage().getMessage("player-unclaim-other-all-claim-aclaim").replace("%player%", args[2]));
                                Player target = Bukkit.getPlayer((String)args[2]);
                                if (target != null) {
                                    target.sendMessage(this.instance.getLanguage().getMessage("player-all-claim-unclaimed-by-admin").replace("%player%", player.getName()));
                                }
                            } else {
                                player.sendMessage(this.instance.getLanguage().getMessage("error"));
                            }
                        })).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                        return;
                    }
                    if (!this.instance.getMain().getClaimsNameFromOwner(args[2]).contains(args[3])) {
                        player.sendMessage(this.instance.getLanguage().getMessage("claim-player-not-found"));
                        return;
                    }
                    this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                        Claim claim = this.instance.getMain().getClaimByName(args[3], p.getUniqueId());
                        ((CompletableFuture)this.instance.getMain().deleteClaim(claim).thenAccept(success -> {
                            if (success.booleanValue()) {
                                player.sendMessage(this.instance.getLanguage().getMessage("player-unclaim-other-claim-aclaim").replace("%name%", args[3]).replace("%player%", args[2]));
                                Player target = Bukkit.getPlayer((String)args[2]);
                                if (target != null) {
                                    target.sendMessage(this.instance.getLanguage().getMessage("player-claim-unclaimed-by-admin").replace("%name%", args[3]).replace("%player%", player.getName()));
                                }
                            } else {
                                player.sendMessage(this.instance.getLanguage().getMessage("error"));
                            }
                        })).exceptionally(ex -> {
                            ex.printStackTrace();
                            return null;
                        });
                    }));
                    return;
                }
            }
        }
        if (args[0].equalsIgnoreCase("cplayer")) {
            Player target;
            if (args[1].equalsIgnoreCase("set-claim-distance")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    Double amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Double.parseDouble(args[3]);
                        if (amount < 0.0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("claim-distance-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-distance-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".claim-distance", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "claim-distance", amount);
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-claim-distance-success").replace("%player%", targetName).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("set-max-chunks-total")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    Double amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Double.parseDouble(args[3]);
                        if (amount < 0.0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-total-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-total-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".max-chunks-total", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "max-chunks-total", amount);
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-max-chunks-total-success").replace("%player%", targetName).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("set-max-chunks-per-claim")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    Double amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Double.parseDouble(args[3]);
                        if (amount < 0.0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-per-claim-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-per-claim-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".max-chunks-per-claim", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "max-chunks-per-claim", amount);
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-max-chunks-per-claim-success").replace("%player%", targetName).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("set-claim-cost")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    Double amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Double.parseDouble(args[3]);
                        if (amount < 0.0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("claim-cost-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-cost-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".claim-cost", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "claim-cost", amount);
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-claim-cost-success").replace("%player%", targetName).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("set-chunk-cost")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    Double amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Double.parseDouble(args[3]);
                        if (amount < 0.0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("chunk-cost-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("chunk-cost-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".chunk-cost", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "chunk-cost", amount);
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-chunk-cost-success").replace("%player%", targetName).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("set-chunk-cost-multiplier")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    Double amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Double.parseDouble(args[3]);
                        if (amount < 0.0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("chunk-cost-multiplier-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("chunk-cost-multiplier-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".chunk-cost-multiplier", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "chunk-cost-multiplier", amount);
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-chunk-cost-multiplier-success").replace("%player%", targetName).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("set-claim-cost-multiplier")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    Double amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Double.parseDouble(args[3]);
                        if (amount < 0.0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("claim-cost-multiplier-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-cost-multiplier-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".claim-cost-multiplier", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "claim-cost-multiplier", amount);
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-claim-cost-multiplier-success").replace("%player%", targetName).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("set-members")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    int amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Integer.parseInt(args[3]);
                        if (amount < 0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("member-limit-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("member-limit-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".max-members", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "max-members", Double.valueOf(amount));
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-member-limit-success").replace("%player%", targetName).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("set-limit")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    int amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Integer.parseInt(args[3]);
                        if (amount < 0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".max-claims", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "max-claims", Double.valueOf(amount));
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-max-claim-success").replace("%player%", targetName).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("set-radius")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    int amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Integer.parseInt(args[3]);
                        if (amount < 0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-radius-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-radius-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".max-radius-claims", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "max-radius-claims", Double.valueOf(amount));
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-max-radius-claim-success").replace("%player%", targetName).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("set-delay")) {
                this.instance.getOfflinePlayer(args[2], p -> this.instance.executeSync(() -> {
                    int amount;
                    if (p == null || !p.hasPlayedBefore()) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("player-never-played").replace("%player%", args[2]));
                        return;
                    }
                    String targetName = p.getName();
                    try {
                        amount = Integer.parseInt(args[3]);
                        if (amount < 0) {
                            sender.sendMessage(this.instance.getLanguage().getMessage("teleportation-delay-must-be-positive"));
                            return;
                        }
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("teleportation-delay-must-be-number"));
                        return;
                    }
                    File configFile = new File(this.instance.getDataFolder(), "config.yml");
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                    config.set("players." + targetName + ".teleportation-delay", (Object)amount);
                    if (p.isOnline()) {
                        UUID targetId = p.getUniqueId();
                        this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "teleportation-delay", Double.valueOf(amount));
                    }
                    try {
                        config.save(configFile);
                        sender.sendMessage(this.instance.getLanguage().getMessage("set-player-teleportation-delay-success").replace("%player%", targetName).replace("%amount%", String.valueOf(args[3])));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }));
                return;
            }
            if (args[1].equalsIgnoreCase("add-limit")) {
                int amount;
                target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                    return;
                }
                String name = target.getName();
                UUID targetId = target.getUniqueId();
                CPlayer cTarget = this.instance.getPlayerMain().getCPlayer(targetId);
                try {
                    amount = Integer.parseInt(args[3]);
                    if (amount < 0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                int new_amount = cTarget.getMaxClaims() + amount;
                config.set("players." + name + ".max-claims", (Object)new_amount);
                this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "max-claims", Double.valueOf(new_amount));
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-player-max-claim-success").replace("%player%", name).replace("%amount%", this.instance.getMain().getNumberSeparate(String.valueOf(new_amount))));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("add-radius")) {
                int amount;
                target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                    return;
                }
                String name = target.getName();
                UUID targetId = target.getUniqueId();
                CPlayer cTarget = this.instance.getPlayerMain().getCPlayer(targetId);
                try {
                    amount = Integer.parseInt(args[3]);
                    if (amount < 0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-radius-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-radius-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                int new_amount = cTarget.getMaxRadiusClaims() + amount;
                config.set("players." + name + ".max-radius-claims", (Object)new_amount);
                this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "max-radius-claims", Double.valueOf(new_amount));
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-player-max-radius-claim-success").replace("%player%", name).replace("%amount%", this.instance.getMain().getNumberSeparate(String.valueOf(new_amount))));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("add-members")) {
                int amount;
                target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                    return;
                }
                String name = target.getName();
                UUID targetId = target.getUniqueId();
                CPlayer cTarget = this.instance.getPlayerMain().getCPlayer(targetId);
                try {
                    amount = Integer.parseInt(args[3]);
                    if (amount < 0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("member-limit-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("member-limit-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                int new_amount = cTarget.getMaxMembers() + amount;
                config.set("players." + name + ".max-members", (Object)new_amount);
                this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "max-members", Double.valueOf(new_amount));
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-player-member-limit-success").replace("%player%", name).replace("%amount%", this.instance.getMain().getNumberSeparate(String.valueOf(new_amount))));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("add-chunks-per-claim")) {
                int amount;
                target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                    return;
                }
                String name = target.getName();
                UUID targetId = target.getUniqueId();
                CPlayer cTarget = this.instance.getPlayerMain().getCPlayer(targetId);
                try {
                    amount = Integer.parseInt(args[3]);
                    if (amount < 0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-per-claim-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-per-claim-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                int new_amount = cTarget.getMaxChunksPerClaim() + amount;
                config.set("players." + name + ".max-chunks-per-claim", (Object)new_amount);
                this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "max-chunks-per-claim", Double.valueOf(new_amount));
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-player-max-chunks-per-claim-success").replace("%player%", name).replace("%amount%", this.instance.getMain().getNumberSeparate(String.valueOf(new_amount))));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("add-chunks-total")) {
                int amount;
                target = Bukkit.getPlayer((String)args[2]);
                if (target == null) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("player-not-online").replace("%player%", args[2]));
                    return;
                }
                String name = target.getName();
                UUID targetId = target.getUniqueId();
                CPlayer cTarget = this.instance.getPlayerMain().getCPlayer(targetId);
                try {
                    amount = Integer.parseInt(args[3]);
                    if (amount < 0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-total-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-total-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                int new_amount = cTarget.getMaxChunksTotal() + amount;
                config.set("players." + name + ".max-chunks-total", (Object)new_amount);
                this.instance.getPlayerMain().updatePlayerConfigSettings(targetId, "max-chunks-total", Double.valueOf(new_amount));
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-player-max-chunks-total-success").replace("%player%", name).replace("%amount%", this.instance.getMain().getNumberSeparate(String.valueOf(new_amount))));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            return;
        }
        if (args[0].equalsIgnoreCase("group")) {
            Double amount;
            if (!this.instance.getSettings().getGroups().contains(args[2])) {
                sender.sendMessage(this.instance.getLanguage().getMessage("group-does-not-exists"));
                return;
            }
            if (args[1].equalsIgnoreCase("set-claim-distance")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-distance-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("claim-distance-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".claim-distance", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("claim-distance", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-claim-distance-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set-max-chunks-total")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-total-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-total-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".max-chunks-total", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("max-chunks-total", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-max-chunks-total-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set-max-chunks-per-claim")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-per-claim-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("max-chunks-per-claim-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".max-chunks-per-claim", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("max-chunks-per-claim", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-max-chunks-per-claim-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set-claim-cost")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-cost-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("claim-cost-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".claim-cost", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("claim-cost", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-claim-cost-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set-chunk-cost")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("chunk-cost-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("chunk-cost-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".chunk-cost", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("chunk-cost", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-chunk-cost-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set-claim-cost-multiplier")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-cost-multiplier-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("claim-cost-multiplier-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".claim-cost-multiplier", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("claim-cost-multiplier", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-claim-cost-multiplier-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set-chunk-cost-multiplier")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("chunk-cost-multiplier-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("chunk-cost-multiplier-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".chunk-cost-multiplier", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("chunk-cost-multiplier", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-chunk-cost-multiplier-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set-members")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("member-limit-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("member-limit-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".max-members", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("max-members", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-member-limit-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set-limit")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".max-claims", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("max-claims", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-max-claim-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set-radius")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-radius-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("claim-limit-radius-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".max-radius-claims", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("max-radius-claims", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-max-radius-claim-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            if (args[1].equalsIgnoreCase("set-delay")) {
                try {
                    amount = Double.parseDouble(args[3]);
                    if (amount < 0.0) {
                        sender.sendMessage(this.instance.getLanguage().getMessage("teleportation-delay-must-be-positive"));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.instance.getLanguage().getMessage("teleportation-delay-must-be-number"));
                    return;
                }
                File configFile = new File(this.instance.getDataFolder(), "config.yml");
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
                config.set("groups." + args[2] + ".teleportation-delay", (Object)amount);
                this.instance.getSettings().getGroupsSettings().get(args[2]).put("teleportation-delay", amount);
                try {
                    config.save(configFile);
                    sender.sendMessage(this.instance.getLanguage().getMessage("set-group-teleportation-delay-success").replace("%group%", args[2]).replace("%amount%", this.instance.getMain().getNumberSeparate(args[3])));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
        this.instance.getMain().getHelp(sender, args[0], "scs");
    }

    private List<String> getPrimaryCompletions(String[] args) {
        String partialInput = args.length > 0 ? args[0].toLowerCase() : "";
        List<String> completions = List.of("reload", "config-reload", "transfer", "player", "cplayer", "group", "forceunclaim", "setowner", "set-lang", "reset-all-player-claims-settings", "reset-all-admin-claims-settings", "admin", "import-griefprevention", "import-xclaims", "setexpulsionlocation");
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }

    private List<String> getSecondaryCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        String command = args[0].toLowerCase();
        String partialInput = args.length > 1 ? args[1].toLowerCase() : "";
        switch (command) {
            case "setowner": {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                break;
            }
            case "group": 
            case "cplayer": {
                completions.addAll(List.of("add-limit", "add-radius", "add-members", "add-chunks-per-claim", "add-chunks-total", "set-limit", "set-radius", "set-delay", "set-members", "set-claim-cost", "set-claim-cost-multiplier", "set-max-chunks-per-claim", "set-claim-distance", "set-max-chunks-total", "set-chunk-cost", "set-chunk-cost-multiplier"));
                break;
            }
            case "player": {
                completions.addAll(List.of("tp", "unclaim", "main", "list"));
                break;
            }
        }
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }

    private List<String> getTertiaryCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        String command = args[0].toLowerCase();
        String secondArg = args[1].toLowerCase();
        String partialInput = args.length > 2 ? args[2].toLowerCase() : "";
        switch (command) {
            case "player": {
                if (!secondArg.equals("tp") && !secondArg.equals("unclaim") && !secondArg.equals("main") && !secondArg.equals("list")) break;
                completions.addAll(new HashSet<String>(this.instance.getMain().getClaimsOwners()));
                break;
            }
            case "cplayer": {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                break;
            }
            case "group": {
                completions.addAll(this.instance.getSettings().getGroups());
                break;
            }
            case "setowner": {
                completions.add("*");
                completions.addAll(this.instance.getMain().getClaimsNameFromOwner(args[1]));
                break;
            }
        }
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }

    private List<String> getFourCompletions(CommandSender sender, String[] args) {
        ArrayList completions = new ArrayList();
        String command = args[0].toLowerCase();
        String partialInput = args.length > 3 ? args[3].toLowerCase() : "";
        switch (command) {
            case "setowner": {
                completions.addAll(Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList()));
                break;
            }
        }
        return completions.stream().filter(c -> c.toLowerCase().startsWith(partialInput)).collect(Collectors.toList());
    }
}

