/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Config;

import fr.xyness.SCS.Types.WorldMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class ClaimSettings {
    private List<Material> restrictedItems = new ArrayList<Material>();
    private List<Material> restrictedInteractBlocks = new ArrayList<Material>();
    private List<EntityType> restrictedEntityType = new ArrayList<EntityType>();
    private List<Material> specialBlocks = new ArrayList<Material>();
    private List<Material> BreakBlocksIgnore = new ArrayList<Material>();
    private List<Material> PlaceBlocksIgnore = new ArrayList<Material>();
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, LinkedHashMap<String, Boolean>> defaultValues = new HashMap<String, LinkedHashMap<String, Boolean>>();
    private String defaultValuesCode_Natural;
    private String defaultValuesCode_Visitors;
    private String defaultValuesCode_Members;
    private Map<String, Boolean> enabledSettings = new HashMap<String, Boolean>();
    private Map<String, Boolean> SurvivalRequiringClaimsSettings = new HashMap<String, Boolean>();
    private Map<String, String> settings = new HashMap<String, String>();
    private LinkedHashMap<String, String> groups = new LinkedHashMap();
    private Map<String, Map<String, Double>> groupsSettings = new HashMap<String, Map<String, Double>>();
    private Map<String, WorldMode> worlds = new HashMap<String, WorldMode>();
    private Map<String, String> worldsAliases = new HashMap<String, String>();
    private Location expulsionLocation;

    public void clearAll() {
        this.restrictedItems.clear();
        this.restrictedInteractBlocks.clear();
        this.restrictedEntityType.clear();
        this.specialBlocks.clear();
        this.BreakBlocksIgnore.clear();
        this.PlaceBlocksIgnore.clear();
        this.defaultValues.clear();
        this.enabledSettings.clear();
        this.settings.clear();
        this.groups.clear();
        this.groupsSettings.clear();
        this.worlds.clear();
        this.aliases.clear();
        this.worldsAliases.clear();
    }

    public String getWorldAliase(String world) {
        return this.worldsAliases.getOrDefault(world, world);
    }

    public void setWorldAliases(Map<String, String> worldsAliases) {
        this.worldsAliases = worldsAliases;
    }

    public String getDefaultValuesCode(String role) {
        switch (role) {
            case "natural": {
                return this.defaultValuesCode_Natural;
            }
            case "visitors": {
                return this.defaultValuesCode_Visitors;
            }
            case "members": {
                return this.defaultValuesCode_Members;
            }
            case "all": {
                return "natural:" + this.defaultValuesCode_Natural + ";visitors:" + this.defaultValuesCode_Visitors + ";members:" + this.defaultValuesCode_Members;
            }
        }
        return "";
    }

    public void setDefaultValuesCode(String s, String role) {
        switch (role) {
            case "natural": {
                this.defaultValuesCode_Natural = s;
            }
            case "visitors": {
                this.defaultValuesCode_Visitors = s;
            }
            case "members": {
                this.defaultValuesCode_Members = s;
            }
        }
    }

    public void addAliase(String key, String value) {
        this.aliases.put(key, value);
    }

    public String getAliase(String key) {
        return this.aliases.get(key);
    }

    public Set<String> getAliasesFromCommand(String value) {
        return this.aliases.values().stream().filter(s -> s.equals(value)).collect(Collectors.toSet());
    }

    public boolean isRestrictedContainer(Material item) {
        return this.restrictedInteractBlocks.contains(item);
    }

    public boolean isRestrictedEntityType(EntityType e) {
        return this.restrictedEntityType.contains(e);
    }

    public boolean isRestrictedItem(Material item) {
        return this.restrictedItems.contains(item);
    }

    public boolean isBreakBlockIgnore(Material item) {
        return this.BreakBlocksIgnore.contains(item);
    }

    public boolean isPlaceBlockIgnore(Material item) {
        return this.PlaceBlocksIgnore.contains(item);
    }

    public boolean isSpecialBlock(Material item) {
        return this.specialBlocks.contains(item);
    }

    public void setWorlds(Map<String, WorldMode> w) {
        this.worlds = w;
    }

    public WorldMode getWorldMode(String world) {
        WorldMode mode = this.worlds.get(world);
        return mode == null ? WorldMode.SURVIVAL : mode;
    }

    public void setExpulsionLocation(Location expulsionLocation) {
        this.expulsionLocation = expulsionLocation;
    }

    public Location getExpulsionLocation() {
        return this.expulsionLocation;
    }

    public void setGroups(LinkedHashMap<String, String> g) {
        this.groups = g;
    }

    public void setGroupsSettings(Map<String, Map<String, Double>> g) {
        this.groupsSettings = g;
    }

    public Map<String, Map<String, Double>> getGroupsSettings() {
        return this.groupsSettings;
    }

    public Set<String> getGroups() {
        return this.groupsSettings.keySet();
    }

    public LinkedHashMap<String, String> getGroupsValues() {
        return this.groups;
    }

    public Map<String, LinkedHashMap<String, Boolean>> getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isEnabled(String p) {
        return this.enabledSettings.get(p);
    }

    public void addSetting(String s, String p) {
        this.settings.put(s, p);
    }

    public boolean getBooleanSetting(String s) {
        return Boolean.parseBoolean(this.settings.get(s));
    }

    public String getSetting(String s) {
        return this.settings.containsKey(s) ? this.settings.get(s) : "";
    }

    public List<Material> getRestrictedItems() {
        return this.restrictedItems;
    }

    public List<Material> getRestrictedContainers() {
        return this.restrictedInteractBlocks;
    }

    public List<EntityType> getRestrictedEntityType() {
        return this.restrictedEntityType;
    }

    public List<Material> getSpecialBlocks() {
        return this.specialBlocks;
    }

    public List<Material> getBreakBlocksIgnore() {
        return this.BreakBlocksIgnore;
    }

    public List<Material> getPlaceBlocksIgnore() {
        return this.PlaceBlocksIgnore;
    }

    public void setDefaultValues(Map<String, LinkedHashMap<String, Boolean>> v) {
        this.defaultValues = v;
    }

    public void setEnabledSettings(Map<String, Boolean> v) {
        this.enabledSettings = v;
    }

    public void setSurvivalRequiringClaimsSettings(Map<String, Boolean> v) {
        this.SurvivalRequiringClaimsSettings = v;
    }

    public boolean getSettingSRC(String setting) {
        return this.SurvivalRequiringClaimsSettings.get(setting);
    }

    public void setRestrictedItems(List<String> mat) {
        this.restrictedItems.clear();
        mat.stream().map(Material::matchMaterial).filter(Objects::nonNull).forEach(this.restrictedItems::add);
    }

    public void setRestrictedContainers(List<String> mat) {
        this.restrictedInteractBlocks.clear();
        mat.stream().map(Material::matchMaterial).filter(Objects::nonNull).forEach(this.restrictedInteractBlocks::add);
    }

    public void setRestrictedEntityType(List<String> mat) {
        this.restrictedEntityType.clear();
        mat.stream().map(EntityType::fromName).filter(Objects::nonNull).forEach(this.restrictedEntityType::add);
    }

    public void setSpecialBlocks(List<String> mat) {
        this.specialBlocks.clear();
        mat.stream().map(Material::matchMaterial).filter(Objects::nonNull).forEach(this.specialBlocks::add);
    }

    public void setBreakBlocksIgnore(List<String> mat) {
        this.BreakBlocksIgnore.clear();
        mat.stream().map(Material::matchMaterial).filter(Objects::nonNull).forEach(this.BreakBlocksIgnore::add);
    }

    public void setPlaceBlocksIgnore(List<String> mat) {
        this.PlaceBlocksIgnore.clear();
        mat.stream().map(Material::matchMaterial).filter(Objects::nonNull).forEach(this.PlaceBlocksIgnore::add);
    }

    public Map<String, Boolean> getStatusSettings() {
        return this.enabledSettings;
    }
}

