/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.AdminGestion;

import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AdminGestionClaimsProtectedAreasGui
implements InventoryHolder {
    private final Inventory inv;
    private SimpleClaimSystem instance;

    public AdminGestionClaimsProtectedAreasGui(Player player, int page, String filter, SimpleClaimSystem instance) {
        this.instance = instance;
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)("\u00a74[A]\u00a7r Protected areas (Page " + String.valueOf(page) + ")"));
        ((CompletableFuture)this.loadItems(player, page, filter).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    private CompletableFuture<Boolean> loadItems(Player player, int page, String filter) {
        return CompletableFuture.supplyAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
            cPlayer.setFilter(filter);
            cPlayer.clearMapClaim();
            cPlayer.clearMapLoc();
            cPlayer.setGuiPage(page);
            this.inv.setItem(48, this.backPage(page - 1, page <= 1));
            Set<Claim> claims = this.getClaims(filter, "*");
            ArrayList<Claim> claimList = new ArrayList<Claim>(claims);
            Collections.sort(claimList, (claim1, claim2) -> claim1.getName().compareTo(claim2.getName()));
            claims = new LinkedHashSet<Claim>(claimList);
            this.setFilterItem(filter);
            List<String> loreTemplate = this.instance.getGuis().getLore("\u00a77Chunks: \u00a7e%chunks_count%\n\u00a77Spawn location: \u00a7b%location%\n\u00a77%sale-status%\n \n\u00a77Members:\n%members%\n \n\u00a77Banned players:\n%bans%\n \n");
            this.fillClaimsItems(player, cPlayer, page, loreTemplate, claims);
            return true;
        });
    }

    private Set<Claim> getClaims(String filter, String owner) {
        return "sales".equals(filter) ? this.instance.getMain().getClaimsInSale(owner) : this.instance.getMain().getPlayerClaims(owner);
    }

    private ItemStack backPage(int page, boolean back) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7cPrevious page");
            meta.setLore(Arrays.asList(back ? "\u00a77Go back to admin main menu" : "\u00a77Go to the page " + String.valueOf(page), "\u00a77\u25b8 \u00a7fClick to access"));
            meta = this.instance.getGuis().setItemFlag(meta);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack nextPage(int page) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7cNext page");
            meta.setLore(Arrays.asList("\u00a77Go to the page " + String.valueOf(page), "\u00a77\u25b8 \u00a7fClick to access"));
            meta = this.instance.getGuis().setItemFlag(meta);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void setFilterItem(String filter) {
        this.inv.setItem(49, this.createFilterItem(filter));
    }

    private void fillClaimsItems(Player player, CPlayer cPlayer, int page, List<String> loreTemplate, Set<Claim> claims) {
        int minSlot = 0;
        int maxSlot = 44;
        int itemsPerPage = maxSlot - minSlot + 1;
        int startIndex = (page - 1) * itemsPerPage;
        int slotIndex = minSlot;
        int itemCount = 0;
        for (Claim claim : claims) {
            if (itemCount++ < startIndex) continue;
            if (slotIndex > maxSlot) {
                this.inv.setItem(50, this.nextPage(page + 1));
                break;
            }
            List<String> lore = this.prepareLore(loreTemplate, claim, player);
            ItemStack item = this.createClaimItem(claim, player, lore);
            cPlayer.addMapClaim(slotIndex, claim);
            cPlayer.addMapLoc(slotIndex, claim.getLocation());
            this.inv.setItem(slotIndex++, item);
        }
    }

    private List<String> prepareLore(List<String> template, Claim claim, Player player) {
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : template) {
            if ((line = line.replace("%name%", claim.getName()).replace("%chunks_count%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getChunks().size()))).replace("%location%", this.instance.getMain().getClaimCoords(claim)).replace("%sale-status%", claim.getSale() ? this.instance.getLanguage().getMessage("claim-info-lore-sale-status-true").replace("%price%", this.instance.getMain().getNumberSeparate(String.valueOf(claim.getPrice()))).replace("%money-symbol%", this.instance.getLanguage().getMessage("money-symbol")) : this.instance.getLanguage().getMessage("claim-info-lore-sale-status-false"))).contains("%members%")) {
                lore.addAll(Arrays.asList(this.getMembers(claim).split("\n")));
                continue;
            }
            if (line.contains("%bans%")) {
                lore.addAll(Arrays.asList(this.getBans(claim).split("\n")));
                continue;
            }
            lore.add(line);
        }
        lore.add("\u00a7c[Left-click]\u00a77 to manage");
        lore.add("\u00a7c[Shift-left-click]\u00a77 to quick delete");
        return lore;
    }

    private ItemStack createClaimItem(Claim claim, Player player, List<String> lore) {
        String displayName = "\u00a76" + claim.getName() + " \u00a77(" + claim.getDescription() + ")";
        return this.createPlayerHeadItem(claim, displayName, lore);
    }

    private ItemStack createPlayerHeadItem(Claim claim, String displayName, List<String> lore) {
        ItemStack item = new ItemStack(Material.FARMLAND);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(displayName);
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createFilterItem(String filter) {
        String loreFilter = this.getFilterLore(filter);
        return this.createItem(Material.END_CRYSTAL, "\u00a7eFilter", this.instance.getGuis().getLore(loreFilter));
    }

    private String getFilterLore(String filter) {
        String loreFilter = "\u00a77Change filter\n%status_color_1%\u27b2 All claims\n%status_color_2%\u27b2 Claims in sale\n\u00a77\u25b8 \u00a7fClick to change";
        loreFilter = "sales".equals(filter) ? loreFilter.replace("%status_color_1%", "\u00a78").replace("%status_color_2%", "\u00a7a") : loreFilter.replace("%status_color_1%", "\u00a7a").replace("%status_color_2%", "\u00a78");
        return loreFilter;
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material != null ? material : Material.STONE, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (name != null) {
                meta.setDisplayName(name);
            }
            if (lore != null) {
                meta.setLore(lore);
            }
            meta = this.instance.getGuis().setItemFlag(meta);
            AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), "generic.armor", 0.0, AttributeModifier.Operation.ADD_NUMBER);
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR, modifier);
            item.setItemMeta(meta);
        }
        return item;
    }

    public String getMembers(Claim claim) {
        CustomSet<String> members = this.instance.getMain().convertUUIDSetToStringSet(claim.getMembers());
        if (members.isEmpty()) {
            return "\u00a78no members";
        }
        StringBuilder membersList = new StringBuilder();
        int i = 0;
        for (String member : members) {
            if (member == null) continue;
            Player player = Bukkit.getPlayer((String)member);
            String memberName = player != null ? "\u00a7a" + member : "\u00a7c" + member;
            membersList.append(memberName);
            if (i < members.size() - 1) {
                membersList.append("\u00a77, ");
            }
            if ((i + 1) % 4 == 0 && i < members.size() - 1) {
                membersList.append("\n");
            }
            ++i;
        }
        return membersList.toString();
    }

    public String getBans(Claim claim) {
        CustomSet<String> members = this.instance.getMain().convertUUIDSetToStringSet(claim.getBans());
        if (members.isEmpty()) {
            return "\u00a78no banned players";
        }
        StringBuilder membersList = new StringBuilder();
        int i = 0;
        for (String member : members) {
            if (member == null) continue;
            Player player = Bukkit.getPlayer((String)member);
            String memberName = player != null ? "\u00a7a" + member : "\u00a7c" + member;
            membersList.append(memberName);
            if (i < members.size() - 1) {
                membersList.append("\u00a77, ");
            }
            if ((i + 1) % 4 == 0 && i < members.size() - 1) {
                membersList.append("\n");
            }
            ++i;
        }
        return membersList.toString();
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

