/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.Bedrock;

import fr.xyness.SCS.Guis.Bedrock.BClaimBansGui;
import fr.xyness.SCS.Guis.Bedrock.BClaimChunksGui;
import fr.xyness.SCS.Guis.Bedrock.BClaimMembersGui;
import fr.xyness.SCS.Guis.Bedrock.BClaimSettingsGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.Claim;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class BClaimMainGui {
    private final SimpleClaimSystem instance;
    private final FloodgatePlayer floodgatePlayer;

    public BClaimMainGui(Player player, Claim claim, SimpleClaimSystem instance) {
        this.instance = instance;
        this.floodgatePlayer = FloodgateApi.getInstance().getPlayer(player.getUniqueId());
        SimpleForm form = (SimpleForm)((SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(instance.getLanguage().getMessage("bedrock-gui-main-title").replace("%name%", claim.getName()))).button(instance.getLanguage().getMessage("bedrock-manage-bans-title").replace("%bans-count%", instance.getMain().getNumberSeparate(String.valueOf(claim.getBans().size()))), FormImage.Type.URL, "https://i.ibb.co/VWH3qdRs/banned.png").button(instance.getLanguage().getMessage("bedrock-manage-members-title").replace("%members-count%", instance.getMain().getNumberSeparate(String.valueOf(claim.getMembers().size()))), FormImage.Type.URL, "https://i.ibb.co/YTh2zjBT/members.png").button(instance.getLanguage().getMessage("bedrock-manage-chunks-title").replace("%chunks-count%", instance.getMain().getNumberSeparate(String.valueOf(claim.getChunks().size()))), FormImage.Type.URL, "https://i.ibb.co/kg1gN8V3/chunks.png").button(instance.getLanguage().getMessage("bedrock-manage-settings-title"), FormImage.Type.URL, "https://i.ibb.co/NgvGqQYt/settings.png").button(instance.getLanguage().getMessage("bedrock-teleport-claim-title"), FormImage.Type.URL, "https://i.ibb.co/jkxBH09F/tp.png").button(instance.getLanguage().getMessage("bedrock-unclaim-title"), FormImage.Type.URL, "https://i.ibb.co/PGqsh65n/unclaim.png").validResultHandler(response -> {
            int buttonId = response.clickedButtonId();
            switch (buttonId) {
                case 0: {
                    if (!this.checkPermButton(player, "manage-bans")) break;
                    new BClaimBansGui(player, claim, instance);
                    break;
                }
                case 1: {
                    if (!this.checkPermButton(player, "manage-members")) break;
                    new BClaimMembersGui(player, claim, instance);
                    break;
                }
                case 2: {
                    if (!this.checkPermButton(player, "manage-chunks")) break;
                    new BClaimChunksGui(player, claim, instance);
                    break;
                }
                case 3: {
                    if (!this.checkPermButton(player, "manage-settings")) break;
                    new BClaimSettingsGui(player, claim, instance);
                    break;
                }
                case 4: {
                    if (!this.checkPermButton(player, "teleport-claim")) break;
                    instance.getMain().goClaim(player, claim.getLocation());
                    break;
                }
                case 5: {
                    if (!this.checkPermButton(player, "unclaim")) break;
                    Bukkit.dispatchCommand((CommandSender)player, (String)("unclaim " + claim.getName()));
                }
            }
        })).build();
        this.floodgatePlayer.sendForm((Form)form);
    }

    public boolean checkPermButton(Player player, String key) {
        switch (key) {
            case "unclaim": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.unclaim");
            }
            case "manage-members": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.members");
            }
            case "manage-bans": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.bans");
            }
            case "manage-settings": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.settings");
            }
            case "manage-chunks": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.chunks");
            }
            case "claim-info": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.list");
            }
            case "teleport-claim": {
                return this.instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp");
            }
        }
        return false;
    }
}

