/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis.Bedrock;

import fr.xyness.SCS.Guis.Bedrock.BClaimsGui;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class BClaimsOwnerGui {
    private final SimpleClaimSystem instance;
    private final FloodgatePlayer floodgatePlayer;

    public BClaimsOwnerGui(Player player, SimpleClaimSystem instance, String owner, String filter) {
        this.instance = instance;
        this.floodgatePlayer = FloodgateApi.getInstance().getPlayer(player.getUniqueId());
        CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(player.getUniqueId());
        if (cPlayer == null) {
            return;
        }
        SimpleForm.Builder form = (SimpleForm.Builder)((SimpleForm.Builder)SimpleForm.builder().title(instance.getLanguage().getMessage("bedrock-gui-claims-owner-title").replace("%owner%", owner))).content(this.getContent(filter).replace("%owner%", owner)).button(instance.getLanguage().getMessage("bedrock-back-page-main")).button(instance.getLanguage().getMessage("bedrock-gui-claims-owner-filter")).validResultHandler(response -> {
            int clickedSlot = response.clickedButtonId();
            if (clickedSlot == 0) {
                new BClaimsGui(player, instance, filter);
                return;
            }
            if (clickedSlot == 1) {
                new BClaimsOwnerGui(player, instance, owner, this.getNextFilter(filter));
                return;
            }
            Claim claim = cPlayer.getMapClaim(clickedSlot);
            if (instance.getPlayerMain().checkPermPlayer(player, "scs.command.claim.tp")) {
                if (!(claim.getPermissionForPlayer("GuiTeleport", player) || claim.getOwner().equals(player.getName()) || instance.getPlayerMain().checkPermPlayer(player, "scs.bypass.guiteleport"))) {
                    return;
                }
                instance.executeEntitySync(player, () -> player.closeInventory());
                instance.getMain().goClaim(player, claim.getLocation());
                return;
            }
        });
        Set<Claim> claims = this.getClaims(filter, owner);
        ArrayList<Claim> claimList = new ArrayList<Claim>(claims);
        Collections.sort(claimList, (claim1, claim2) -> claim1.getName().compareTo(claim2.getName()));
        claims = new LinkedHashSet<Claim>(claimList);
        cPlayer.clearMapClaim();
        int i = 2;
        for (Claim claim : claims) {
            cPlayer.addMapClaim(i, claim);
            String ownerHeadUrl = "https://mc-heads.net/avatar/" + owner + "/150";
            form.button(claim.getName(), FormImage.Type.URL, ownerHeadUrl);
            ++i;
        }
        this.floodgatePlayer.sendForm(form.build());
    }

    public String getContent(String filter) {
        if (filter.equals("all")) {
            return this.instance.getLanguage().getMessage("bedrock-gui-claims-owner-click-1");
        }
        return this.instance.getLanguage().getMessage("bedrock-gui-claims-owner-click-2");
    }

    public String getNextFilter(String filter) {
        filter = filter.equals("all") ? "sales" : "all";
        return filter;
    }

    private Set<Claim> getClaims(String filter, String owner) {
        return "sales".equals(filter) ? this.instance.getMain().getClaimsInSale(owner) : this.instance.getMain().getPlayerClaims(owner);
    }
}

