/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis;

import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ClaimListGui
implements InventoryHolder {
    private final Inventory inv;
    private final Player player;
    private final SimpleClaimSystem instance;

    public ClaimListGui(Player player, int page, String filter, SimpleClaimSystem instance) {
        this.instance = instance;
        this.player = player;
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("list");
        String title = guiSettings.getTitle().replace("%page%", String.valueOf(page));
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(guiSettings.getRows() * 9), (String)title);
        ((CompletableFuture)this.loadItems(page, filter).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems(int page, String filter) {
        return CompletableFuture.supplyAsync(() -> {
            String playerName = this.player.getName();
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(this.player.getUniqueId());
            cPlayer.setFilter(filter);
            cPlayer.clearMapClaim();
            cPlayer.clearMapLoc();
            cPlayer.setGuiPage(page);
            HashSet<Claim> claims = new HashSet<Claim>(filter.equals("owner") ? this.instance.getMain().getPlayerClaims(playerName) : this.instance.getMain().getClaimsWhereMemberNotOwner(this.player));
            ArrayList<Claim> claimList = new ArrayList<Claim>(claims);
            Collections.sort(claimList, (claim1, claim2) -> claim1.getName().compareTo(claim2.getName()));
            claims = new LinkedHashSet<Claim>(claimList);
            int claimsCount = claims.size();
            GuiSettings guiSettings = ClaimGuis.gui_settings.get("list");
            int max = guiSettings.getSlots().size();
            ArrayList slots = new ArrayList(ClaimGuis.gui_slots.get("list"));
            for (GuiSlot slot : slots) {
                Material mat;
                int slot_int = slot.getSlot();
                String key = slot.getKey();
                String title = slot.getTitle();
                String lore_string = slot.getLore();
                if (key.equals("BackPage")) {
                    if (page == 1) continue;
                    title = title.replace("%page%", String.valueOf(page - 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page - 1));
                }
                if (key.equals("NextPage")) {
                    if (claimsCount <= page * max) continue;
                    title = title.replace("%page%", String.valueOf(page + 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page + 1));
                }
                if (key.equals("Filter")) {
                    lore_string = filter.equals("not_owner") ? lore_string.replace("%status_color_1%", this.instance.getLanguage().getMessage("status_color_inactive_filter")).replace("%status_color_2%", this.instance.getLanguage().getMessage("status_color_active_filter")) : lore_string.replace("%status_color_1%", this.instance.getLanguage().getMessage("status_color_active_filter")).replace("%status_color_2%", this.instance.getLanguage().getMessage("status_color_inactive_filter"));
                }
                List<String> lore = this.instance.getGuis().getLore(lore_string);
                if (title.isBlank()) {
                    title = null;
                }
                if (lore.isEmpty()) {
                    lore = null;
                }
                if (slot.isCustomModel()) {
                    mat = slot.getMaterial();
                    this.inv.setItem(slot_int, this.instance.getGuis().createCustomItem(mat, title, lore, slot.getCustomModelData()));
                    continue;
                }
                if (slot.isCustomHead()) {
                    SkullMeta meta;
                    ItemStack head;
                    if (slot.getCustomTextures().equalsIgnoreCase("%player%")) {
                        head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        meta.setOwningPlayer((OfflinePlayer)this.player);
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    if (slot.getCustomTextures().length() < 17) {
                        head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        OfflinePlayer targetP = Bukkit.getOfflinePlayer((String)slot.getCustomTextures());
                        if (targetP != null) {
                            meta.setOwningPlayer(targetP);
                        }
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    this.inv.setItem(slot_int, this.instance.getPlayerMain().createPlayerHeadWithTexture(slot.getCustomTextures(), title, lore));
                    continue;
                }
                mat = slot.getMaterial();
                this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
            }
            ArrayList<String> lore = new ArrayList<String>(this.instance.getGuis().getLore(filter.equals("owner") ? this.instance.getLanguage().getMessage("access-claim-lore") : this.instance.getLanguage().getMessage("access-claim-not-owner-lore")));
            String lore_tp = this.instance.getPlayerMain().checkPermPlayer(this.player, "scs.command.claim.tp") ? this.instance.getLanguage().getMessage("access-claim-clickable-tp") : this.instance.getLanguage().getMessage("gui-button-no-permission") + this.instance.getLanguage().getMessage("to-teleport");
            String lore_remove = this.instance.getPlayerMain().checkPermPlayer(this.player, "scs.command.claim.remove") ? this.instance.getLanguage().getMessage("access-claim-clickable-remove") : this.instance.getLanguage().getMessage("gui-button-no-permission") + this.instance.getLanguage().getMessage("to-remove");
            String lore_settings = this.instance.getPlayerMain().checkPermPlayer(this.player, "scs.command.claim.main") ? this.instance.getLanguage().getMessage("access-claim-clickable-manage") : this.instance.getLanguage().getMessage("gui-button-no-permission") + this.instance.getLanguage().getMessage("to-manage");
            int startItem = (page - 1) * max;
            List<Integer> slots_i = guiSettings.getSlots();
            int i = slots_i.get(0);
            int count = 0;
            int count2 = 0;
            for (Claim claim : claims) {
                if (count++ < startItem) continue;
                if (count2 > max - 1) break;
                i = slots_i.get(count2);
                ++count2;
                cPlayer.addMapClaim(i, claim);
                cPlayer.addMapLoc(i, claim.getLocation());
                ArrayList<String> used_lore = new ArrayList<String>(this.processLore(lore, claim));
                if (filter.equals("owner")) {
                    used_lore.addAll(Arrays.asList(lore_tp, lore_remove, lore_settings));
                } else {
                    used_lore.add(lore_tp);
                }
                ItemStack item = this.instance.getPlayerMain().getPlayerHead(playerName);
                if (item == null) {
                    item = new ItemStack(Material.PLAYER_HEAD);
                }
                if (item.hasItemMeta() && item.getItemMeta() != null) {
                    ItemMeta patt0$temp = item.getItemMeta();
                    if (patt0$temp instanceof SkullMeta) {
                        SkullMeta meta = (SkullMeta)patt0$temp;
                        meta.setDisplayName(this.instance.getLanguage().getMessage("access-claim-title").replace("%name%", claim.getName()).replace("%coords%", this.instance.getMain().getClaimCoords(claim)));
                        meta.setLore(used_lore);
                        item.setItemMeta((ItemMeta)meta);
                    } else {
                        ItemMeta meta = item.getItemMeta();
                        meta.setDisplayName(this.instance.getLanguage().getMessage("access-claim-title").replace("%name%", claim.getName()).replace("%coords%", this.instance.getMain().getClaimCoords(claim)));
                        meta.setLore(used_lore);
                        item.setItemMeta(meta);
                    }
                }
                this.inv.setItem(i, item);
                ++i;
            }
            return true;
        });
    }

    public List<String> processLore(List<String> lore, Claim claim) {
        ArrayList<String> used_lore = new ArrayList<String>();
        String owner = claim.getOwner();
        String description = claim.getDescription();
        String name = claim.getName();
        String coords = this.instance.getMain().getClaimCoords(claim);
        String members = this.getMembers(claim);
        String bans = this.getBans(claim);
        for (String s : lore) {
            if ((s = s.replace("%owner%", owner).replace("%description%", description).replace("%name%", name).replace("%coords%", coords)).contains("%members%")) {
                if (members.contains("\n")) {
                    for (String member : members.split("\n")) {
                        used_lore.add(s.replace("%members%", member));
                    }
                    continue;
                }
                used_lore.add(s.replace("%members%", members));
                continue;
            }
            if (s.contains("%bans%")) {
                if (bans.contains("\n")) {
                    for (String ban : bans.split("\n")) {
                        used_lore.add(s.replace("%bans%", ban));
                    }
                    continue;
                }
                used_lore.add(s.replace("%bans%", bans));
                continue;
            }
            used_lore.add(s);
        }
        return used_lore;
    }

    public String getMembers(Claim claim) {
        CustomSet<String> members = this.instance.getMain().convertUUIDSetToStringSet(claim.getMembers());
        if (members.isEmpty()) {
            return this.instance.getLanguage().getMessage("claim-list-no-member");
        }
        StringBuilder membersList = new StringBuilder();
        int i = 0;
        for (String membre : members) {
            if (membre == null) continue;
            Player p = Bukkit.getPlayer((String)membre);
            String fac = p != null ? "\u00a7a" + membre : "\u00a7c" + membre;
            membersList.append(fac);
            if (i < members.size() - 1) {
                membersList.append("\u00a77, ");
            }
            if ((i + 1) % 4 == 0 && i < members.size() - 1) {
                membersList.append("\n");
            }
            ++i;
        }
        return membersList.toString();
    }

    public String getBans(Claim claim) {
        CustomSet<String> bans = this.instance.getMain().convertUUIDSetToStringSet(claim.getBans());
        if (bans.isEmpty()) {
            return this.instance.getLanguage().getMessage("claim-list-no-ban");
        }
        StringBuilder bansList = new StringBuilder();
        int i = 0;
        for (String ban : bans) {
            if (ban == null) continue;
            Player player = Bukkit.getPlayer((String)ban);
            String banName = player != null ? "\u00a7a" + ban : "\u00a7c" + ban;
            bansList.append(banName);
            if (i < bans.size() - 1) {
                bansList.append("\u00a77, ");
            }
            if ((i + 1) % 4 == 0 && i < bans.size() - 1) {
                bansList.append("\n");
            }
            ++i;
        }
        return bansList.toString();
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

