/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis;

import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ClaimSettingsGui
implements InventoryHolder {
    private final Inventory inv;
    private final Player player;
    private final SimpleClaimSystem instance;

    public ClaimSettingsGui(Player player, Claim claim, SimpleClaimSystem instance, String role) {
        this.instance = instance;
        this.player = player;
        String role_displayed = switch (role) {
            case "members" -> instance.getLanguage().getMessage("role-members");
            case "natural" -> instance.getLanguage().getMessage("role-natural");
            default -> instance.getLanguage().getMessage("role-visitors");
        };
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("settings");
        String title = guiSettings.getTitle().replace("%name%", claim.getName()).replace("%role%", role_displayed);
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(guiSettings.getRows() * 9), (String)title);
        ((CompletableFuture)this.loadItems(claim, role).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    public CompletableFuture<Boolean> loadItems(Claim claim, String role) {
        return CompletableFuture.supplyAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(this.player.getUniqueId());
            cPlayer.setClaim(claim);
            cPlayer.setFilter(role);
            String default_statut_disabled = this.instance.getLanguage().getMessage("status-disabled");
            String default_statut_enabled = this.instance.getLanguage().getMessage("status-enabled");
            String default_choix_disabled = this.instance.getLanguage().getMessage("choice-disabled");
            String default_choix_enabled = this.instance.getLanguage().getMessage("choice-enabled");
            ArrayList slots = new ArrayList(ClaimGuis.gui_slots.get("settings"));
            for (GuiSlot slot : slots) {
                int slot_int = slot.getSlot();
                String key = slot.getKey();
                String title = slot.getTitle();
                String lore_string = slot.getLore();
                List<String> lore = this.instance.getGuis().getLore(lore_string);
                if (this.instance.getGuis().isAPerm(key)) {
                    String choix;
                    if (!this.instance.getGuis().isAPerm(key, role)) continue;
                    boolean permission = claim.getPermission(key, role);
                    String statut = permission ? default_statut_enabled : default_statut_disabled;
                    String string = choix = permission ? default_choix_enabled : default_choix_disabled;
                    lore.add((String)(this.instance.getSettings().isEnabled(key) ? (this.checkPermPerm(this.player, key) ? choix : this.instance.getLanguage().getMessage("gui-button-no-permission") + this.instance.getLanguage().getMessage("to-use-setting")) : this.instance.getLanguage().getMessage("choice-setting-disabled")));
                    title = title.replace("%status%", statut);
                } else if (key.equals("Filter")) {
                    String loreFilter = this.instance.getLanguage().getMessage("role-lore").replaceAll("%status_color_" + this.getStatusIndex(role) + "%", this.instance.getLanguage().getMessage("status_color_active_filter")).replaceAll("%status_color_[^" + this.getStatusIndex(role) + "]%", this.instance.getLanguage().getMessage("status_color_inactive_filter"));
                    lore = this.instance.getGuis().getLore(loreFilter);
                }
                if (title.isBlank()) {
                    title = null;
                }
                if (lore.isEmpty()) {
                    lore = null;
                }
                if (slot.isCustomModel()) {
                    Material mat = slot.getMaterial();
                    this.inv.setItem(slot_int, this.instance.getGuis().createCustomItem(mat, title, lore, slot.getCustomModelData()));
                    continue;
                }
                if (slot.isCustomHead()) {
                    SkullMeta meta;
                    if (slot.getCustomTextures().equalsIgnoreCase("%player%")) {
                        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        meta.setOwningPlayer((OfflinePlayer)this.player);
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    if (slot.getCustomTextures().length() < 17) {
                        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        OfflinePlayer targetP = Bukkit.getOfflinePlayer((String)slot.getCustomTextures());
                        if (targetP != null) {
                            meta.setOwningPlayer(targetP);
                        }
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    this.inv.setItem(slot_int, this.instance.getPlayerMain().createPlayerHeadWithTexture(slot.getCustomTextures(), title, lore));
                    continue;
                }
                Material mat = slot.getMaterial();
                this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
            }
            return true;
        });
    }

    public boolean checkPermPerm(Player player, String perm) {
        String specificPerm = "scs.setting." + perm;
        String wildcardPerm = "scs.setting.*";
        if (player.isPermissionSet(specificPerm) && !player.hasPermission(specificPerm)) {
            return false;
        }
        return player.hasPermission(specificPerm) || player.hasPermission(wildcardPerm);
    }

    private int getStatusIndex(String role) {
        switch (role) {
            case "members": {
                return 2;
            }
            case "natural": {
                return 3;
            }
        }
        return 1;
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

