/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Guis;

import fr.xyness.SCS.Config.ClaimGuis;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.CPlayer;
import fr.xyness.SCS.Types.GuiSettings;
import fr.xyness.SCS.Types.GuiSlot;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ClaimsGui
implements InventoryHolder {
    private final Inventory inv;
    private final Player player;
    private final SimpleClaimSystem instance;

    public ClaimsGui(Player player, int page, String filter, SimpleClaimSystem instance) {
        this.instance = instance;
        this.player = player;
        GuiSettings guiSettings = ClaimGuis.gui_settings.get("claims");
        String title = guiSettings.getTitle().replace("%page%", String.valueOf(page));
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)(guiSettings.getRows() * 9), (String)title);
        ((CompletableFuture)this.loadItems(page, filter).thenAccept(success -> {
            if (success.booleanValue()) {
                instance.executeEntitySync(player, () -> player.openInventory(this.inv));
            } else {
                instance.executeEntitySync(player, () -> player.sendMessage(instance.getLanguage().getMessage("error")));
            }
        })).exceptionally(ex -> {
            ex.printStackTrace();
            return null;
        });
    }

    private CompletableFuture<Boolean> loadItems(int page, String filter) {
        return CompletableFuture.supplyAsync(() -> {
            CPlayer cPlayer = this.instance.getPlayerMain().getCPlayer(this.player.getUniqueId());
            Map<String, Integer> owners = this.getOwnersByFilter(filter);
            LinkedHashMap sortedOwners = owners.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            int ownersCount = owners.size();
            cPlayer.setFilter(filter);
            cPlayer.clearMapString();
            cPlayer.setGuiPage(page);
            GuiSettings guiSettings = ClaimGuis.gui_settings.get("claims");
            int max = guiSettings.getSlots().size();
            ArrayList slots = new ArrayList(ClaimGuis.gui_slots.get("claims"));
            for (GuiSlot slot : slots) {
                Material mat;
                int slot_int = slot.getSlot();
                String key = slot.getKey();
                String title = slot.getTitle();
                String lore_string = slot.getLore();
                if (key.equals("BackPage")) {
                    if (page == 1) continue;
                    title = title.replace("%page%", String.valueOf(page - 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page - 1));
                }
                if (key.equals("NextPage")) {
                    if (ownersCount <= page * max) continue;
                    title = title.replace("%page%", String.valueOf(page + 1));
                    lore_string = lore_string.replace("%page%", String.valueOf(page + 1));
                }
                if (key.equals("Filter")) {
                    lore_string = lore_string.replaceAll("%status_color_" + this.getStatusIndex(filter) + "%", this.instance.getLanguage().getMessage("status_color_active_filter")).replaceAll("%status_color_[^" + this.getStatusIndex(filter) + "]%", this.instance.getLanguage().getMessage("status_color_inactive_filter"));
                }
                List<String> lore = this.instance.getGuis().getLore(lore_string);
                if (title.isBlank()) {
                    title = null;
                }
                if (lore.isEmpty()) {
                    lore = null;
                }
                if (slot.isCustomModel()) {
                    mat = slot.getMaterial();
                    this.inv.setItem(slot_int, this.instance.getGuis().createCustomItem(mat, title, lore, slot.getCustomModelData()));
                    continue;
                }
                if (slot.isCustomHead()) {
                    SkullMeta meta;
                    ItemStack head;
                    if (slot.getCustomTextures().equalsIgnoreCase("%player%")) {
                        head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        meta.setOwningPlayer((OfflinePlayer)this.player);
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    if (slot.getCustomTextures().length() < 17) {
                        head = new ItemStack(Material.PLAYER_HEAD);
                        meta = (SkullMeta)head.getItemMeta();
                        OfflinePlayer targetP = Bukkit.getOfflinePlayer((String)slot.getCustomTextures());
                        if (targetP != null) {
                            meta.setOwningPlayer(targetP);
                        }
                        meta.setDisplayName(title);
                        meta.setLore(lore);
                        head.setItemMeta((ItemMeta)meta);
                        this.inv.setItem(slot_int, head);
                        continue;
                    }
                    this.inv.setItem(slot_int, this.instance.getPlayerMain().createPlayerHeadWithTexture(slot.getCustomTextures(), title, lore));
                    continue;
                }
                mat = slot.getMaterial();
                this.inv.setItem(slot_int, this.instance.getGuis().createItem(mat, title, lore));
            }
            List<String> loreTemplate = this.instance.getGuis().getLore(this.instance.getLanguage().getMessage("owner-claim-lore"));
            int startItem = (page - 1) * max;
            List<Integer> slots_i = guiSettings.getSlots();
            int i = slots_i.get(0);
            int count = 0;
            int count2 = 0;
            for (Map.Entry entry : sortedOwners.entrySet()) {
                if (count++ < startItem) continue;
                if (count2 > max - 1) break;
                i = slots_i.get(count2);
                ++count2;
                String owner = (String)entry.getKey();
                int claimAmount = (Integer)entry.getValue();
                ArrayList<String> lore = new ArrayList<String>();
                loreTemplate.forEach(s -> {
                    String l = s.replace("%claim-amount%", this.instance.getMain().getNumberSeparate(String.valueOf(claimAmount)));
                    lore.add(l);
                });
                lore.add(this.instance.getLanguage().getMessage("owner-claim-access"));
                ItemStack item = this.instance.getPlayerMain().getPlayerHead(owner);
                if (item == null) {
                    item = new ItemStack(Material.PLAYER_HEAD);
                }
                if (item.hasItemMeta() && item.getItemMeta() != null) {
                    ItemMeta patt0$temp = item.getItemMeta();
                    if (patt0$temp instanceof SkullMeta) {
                        SkullMeta meta = (SkullMeta)patt0$temp;
                        meta.setDisplayName(this.instance.getLanguage().getMessage("owner-claim-title").replace("%owner%", owner));
                        meta.setLore(lore);
                        item.setItemMeta((ItemMeta)meta);
                    } else {
                        ItemMeta meta = item.getItemMeta();
                        meta.setDisplayName(this.instance.getLanguage().getMessage("owner-claim-title").replace("%owner%", owner));
                        meta.setLore(lore);
                        item.setItemMeta(meta);
                    }
                }
                this.inv.setItem(i, item);
                cPlayer.addMapString(i, owner);
                ++i;
            }
            return true;
        });
    }

    private Map<String, Integer> getOwnersByFilter(String filter) {
        switch (filter) {
            case "sales": {
                return this.instance.getMain().getClaimsOwnersWithSales();
            }
            case "online": {
                return this.instance.getMain().getClaimsOnlineOwners();
            }
            case "offline": {
                return this.instance.getMain().getClaimsOfflineOwners();
            }
        }
        return this.instance.getMain().getClaimsOwnersGui();
    }

    private int getStatusIndex(String filter) {
        switch (filter) {
            case "sales": {
                return 2;
            }
            case "online": {
                return 3;
            }
            case "offline": {
                return 4;
            }
        }
        return 1;
    }

    public Inventory getInventory() {
        return this.inv;
    }
}

