/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Support;

import com.flowpowered.math.vector.Vector2d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class ClaimBluemap {
    private BlueMapAPI api;
    private Map<World, MarkerSet> markerSets = new HashMap<World, MarkerSet>();
    private SimpleClaimSystem instance;

    public ClaimBluemap(BlueMapAPI api, SimpleClaimSystem instance) {
        this.api = api;
        this.instance = instance;
        this.load();
    }

    public void load() {
        CustomSet<Claim> claims = this.instance.getMain().getAllClaims();
        this.instance.executeAsync(() -> {
            for (World w : Bukkit.getWorlds()) {
                MarkerSet markerSet = MarkerSet.builder().label("Claims").build();
                this.markerSets.put(w, markerSet);
                for (Claim claim : claims) {
                    if (!claim.getLocation().getWorld().equals((Object)w)) continue;
                    this.createClaimZone(claim);
                }
                this.api.getWorld((Object)w).ifPresent(world -> {
                    for (BlueMapMap map : world.getMaps()) {
                        map.getMarkerSets().put("Claims", markerSet);
                    }
                });
            }
        });
        this.instance.getLogger().info("Claims added to BlueMap.");
    }

    public void createClaimZone(Claim claim) {
        String name = claim.getName();
        String owner = claim.getOwner();
        Set<Chunk> chunks = claim.getChunks();
        String hoverText = this.instance.getSettings().getSetting("bluemap-claim-hover-text").replace("%claim-name%", name).replace("%owner%", owner);
        String fcolor = "80" + this.instance.getSettings().getSetting("bluemap-claim-fill-color");
        String lcolor = "80" + this.instance.getSettings().getSetting("bluemap-claim-border-color");
        Color fillColor = new Color((int)Long.parseLong(fcolor, 16));
        Color strokeColor = new Color((int)Long.parseLong(lcolor, 16));
        chunks.forEach(chunk -> {
            String markerId = "chunk_" + chunk.getX() + "_" + chunk.getZ();
            MarkerSet markerSet = this.markerSets.get(chunk.getWorld());
            if (markerSet == null) {
                return;
            }
            Location loc1 = new Location(chunk.getWorld(), (double)(chunk.getX() * 16), 0.0, (double)(chunk.getZ() * 16));
            Location loc2 = new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 16), 0.0, (double)(chunk.getZ() * 16));
            Location loc3 = new Location(chunk.getWorld(), (double)(chunk.getX() * 16 + 16), 0.0, (double)(chunk.getZ() * 16 + 16));
            Location loc4 = new Location(chunk.getWorld(), (double)(chunk.getX() * 16), 0.0, (double)(chunk.getZ() * 16 + 16));
            Shape shape = new Shape(new Vector2d[]{new Vector2d(loc1.getX(), loc1.getZ()), new Vector2d(loc2.getX(), loc2.getZ()), new Vector2d(loc3.getX(), loc3.getZ()), new Vector2d(loc4.getX(), loc4.getZ())});
            ExtrudeMarker marker = ((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)ExtrudeMarker.builder().label(hoverText)).detail(hoverText)).depthTestEnabled(false).shape(shape, -64.0f, 320.0f).position(loc1.getX(), -64.0, loc1.getZ())).fillColor(fillColor).lineColor(strokeColor).lineWidth(5).build();
            markerSet.getMarkers().put(markerId, marker);
        });
    }

    public void updateName(Claim claim) {
        String t = this.instance.getSettings().getSetting("bluemap-claim-hover-text").replace("%claim-name%", claim.getName()).replace("%owner%", claim.getOwner());
        claim.getChunks().forEach(chunk -> {
            String markerId = "chunk_" + chunk.getX() + "_" + chunk.getZ();
            MarkerSet markerSet = this.markerSets.get(chunk.getWorld());
            if (markerSet == null) {
                return;
            }
            ExtrudeMarker marker = (ExtrudeMarker)markerSet.get(markerId);
            if (marker != null) {
                marker.setLabel(t);
                marker.setDetail(t);
            }
        });
    }

    public void deleteMarker(Set<Chunk> chunks) {
        chunks.parallelStream().forEach(chunk -> {
            String markerId = "chunk_" + chunk.getX() + "_" + chunk.getZ();
            MarkerSet markerSet = this.markerSets.get(chunk.getWorld());
            if (markerSet == null) {
                return;
            }
            markerSet.remove(markerId);
        });
    }
}

