/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Support;

import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.Claim;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.MarkerSet;

public class ClaimDynmap {
    private MarkerSet markerSet;
    private SimpleClaimSystem instance;

    public ClaimDynmap(MarkerSet m2, SimpleClaimSystem instance) {
        this.markerSet = m2;
        this.instance = instance;
    }

    public void createClaimZone(Claim claim) {
        if (this.markerSet == null) {
            return;
        }
        String t = this.instance.getSettings().getSetting("dynmap-claim-hover-text").replace("%claim-name%", claim.getName()).replace("%owner%", claim.getOwner());
        int linestyle = Integer.parseInt(this.instance.getSettings().getSetting("dynmap-claim-border-color"), 16);
        int fillstyle = Integer.parseInt(this.instance.getSettings().getSetting("dynmap-claim-fill-color"), 16);
        claim.getChunks().parallelStream().forEach(chunk -> {
            String markerId = "chunk_" + chunk.getX() + "_" + chunk.getZ();
            AreaMarker existingMarker = this.markerSet.findAreaMarker(markerId);
            if (existingMarker != null) {
                return;
            }
            World world = chunk.getWorld();
            int x = chunk.getX() * 16;
            int z = chunk.getZ() * 16;
            double[] xCorners = new double[]{x, x + 16, x + 16, x};
            double[] zCorners = new double[]{z, z, z + 16, z + 16};
            AreaMarker marker = this.markerSet.createAreaMarker(markerId, t, false, world.getName(), xCorners, zCorners, false);
            marker.setLineStyle(3, 1.0, linestyle);
            marker.setFillStyle(0.5, fillstyle);
        });
    }

    public void updateName(Claim claim) {
        if (this.markerSet == null) {
            return;
        }
        String t = this.instance.getSettings().getSetting("dynmap-claim-hover-text").replace("%claim-name%", claim.getName()).replace("%owner%", claim.getOwner());
        claim.getChunks().parallelStream().forEach(chunk -> {
            String markerId = "chunk_" + chunk.getX() + "_" + chunk.getZ();
            AreaMarker marker = this.markerSet.findAreaMarker(markerId);
            if (marker != null) {
                marker.setLabel(t);
            }
        });
    }

    public void deleteMarker(Set<Chunk> chunks) {
        if (this.markerSet == null) {
            return;
        }
        chunks.forEach(chunk -> {
            String markerId = "chunk_" + chunk.getX() + "_" + chunk.getZ();
            AreaMarker marker = this.markerSet.findAreaMarker(markerId);
            if (marker != null) {
                marker.deleteMarker();
            }
        });
    }
}

