/*
 * Decompiled with CFR 0.152.
 */
package fr.xyness.SCS.Support;

import fr.xyness.SCS.SimpleClaimSystem;
import fr.xyness.SCS.Types.Claim;
import fr.xyness.SCS.Types.CustomSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.EventHandler;
import net.pl3x.map.core.event.EventListener;
import net.pl3x.map.core.event.server.Pl3xMapEnabledEvent;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.layer.SimpleLayer;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Rectangle;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.registry.WorldRegistry;
import net.pl3x.map.core.util.Colors;
import net.pl3x.map.core.world.World;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;

public class ClaimPl3xMap
implements EventListener {
    private final Map<org.bukkit.World, SimpleLayer> layers = new HashMap<org.bukkit.World, SimpleLayer>();
    private SimpleClaimSystem instance;

    public ClaimPl3xMap(SimpleClaimSystem instance) {
        this.instance = instance;
        Pl3xMap.api().getEventRegistry().register((EventListener)this);
    }

    @EventHandler
    public void onPl3xMapEnabled(Pl3xMapEnabledEvent event) {
        this.instance.executeAsync(() -> {
            WorldRegistry worldRegistry = Pl3xMap.api().getWorldRegistry();
            CustomSet<Claim> claims = this.instance.getMain().getAllClaims();
            for (org.bukkit.World world : Bukkit.getWorlds()) {
                String worldName = world.getName();
                String layerId = "claims_" + world.getName();
                World mapWorld = (World)worldRegistry.get(worldName);
                if (mapWorld == null) continue;
                SimpleLayer layer = new SimpleLayer(layerId, () -> "Claims");
                layer.setPriority(1);
                layer.setZIndex(Integer.valueOf(1));
                layer.setLiveUpdate(true);
                mapWorld.getLayerRegistry().register((Keyed)layer);
                this.layers.put(world, layer);
                for (Claim claim : claims) {
                    if (!claim.getLocation().getWorld().equals((Object)world)) continue;
                    this.createClaimZone(claim);
                }
            }
            this.instance.getLogger().info("Claims added to Pl3xMap.");
        });
    }

    public void createClaimZone(Claim claim) {
        String hoverText = this.instance.getSettings().getSetting("pl3xmap-claim-hover-text").replace("%claim-name%", claim.getName()).replace("%owner%", claim.getOwner());
        String fillColor = this.instance.getSettings().getSetting("pl3xmap-claim-fill-color");
        String strokeColor = this.instance.getSettings().getSetting("pl3xmap-claim-border-color");
        claim.getChunks().parallelStream().forEach(chunk -> {
            String markerId = "chunk_" + chunk.getX() + "_" + chunk.getZ();
            Point point1 = Point.of((int)(chunk.getX() * 16), (int)(chunk.getZ() * 16));
            Point point2 = Point.of((int)(chunk.getX() * 16 + 16), (int)(chunk.getZ() * 16 + 16));
            Rectangle rectangle = new Rectangle(markerId, point1, point2);
            Options options = Options.builder().tooltipContent(hoverText).fillColor(Integer.valueOf(Colors.setAlpha((int)255, (int)Integer.parseInt(fillColor, 16)))).strokeColor(Integer.valueOf(Colors.setAlpha((int)255, (int)Integer.parseInt(strokeColor, 16)))).strokeWeight(Integer.valueOf(2)).fill(Boolean.valueOf(true)).stroke(Boolean.valueOf(true)).build();
            rectangle.setOptions(options);
            org.bukkit.World world = chunk.getWorld();
            SimpleLayer targetLayer = this.layers.get(world);
            if (targetLayer == null) {
                String worldName = world.getName();
                String layerId = "claims_" + world.getName();
                WorldRegistry worldRegistry = Pl3xMap.api().getWorldRegistry();
                World mapWorld = (World)worldRegistry.get(worldName);
                if (mapWorld != null) {
                    SimpleLayer layer = new SimpleLayer(layerId, () -> "Claims");
                    layer.setPriority(1);
                    layer.setZIndex(Integer.valueOf(1));
                    layer.setLiveUpdate(true);
                    mapWorld.getLayerRegistry().register((Keyed)layer);
                    this.layers.put(world, layer);
                    this.layers.get(world).addMarker((Marker)rectangle);
                }
            } else {
                this.layers.get(chunk.getWorld()).addMarker((Marker)rectangle);
            }
        });
    }

    public void updateName(Claim claim) {
        String hoverText = this.instance.getSettings().getSetting("pl3xmap-claim-hover-text").replace("%claim-name%", claim.getName()).replace("%owner%", claim.getOwner());
        String fillColor = this.instance.getSettings().getSetting("pl3xmap-claim-fill-color");
        String strokeColor = this.instance.getSettings().getSetting("pl3xmap-claim-border-color");
        claim.getChunks().parallelStream().forEach(chunk -> {
            String markerId = "chunk_" + chunk.getX() + "_" + chunk.getZ();
            Collection markers = this.layers.get(chunk.getWorld()).getMarkers();
            for (Marker marker : markers) {
                if (!marker.getKey().equals(markerId)) continue;
                Options newOptions = Options.builder().tooltipContent(hoverText).fillColor(Integer.valueOf(Colors.setAlpha((int)255, (int)Integer.parseInt(fillColor, 16)))).strokeColor(Integer.valueOf(Colors.setAlpha((int)255, (int)Integer.parseInt(strokeColor, 16)))).strokeWeight(Integer.valueOf(2)).fill(Boolean.valueOf(true)).stroke(Boolean.valueOf(true)).build();
                marker.setOptions(newOptions);
                break;
            }
        });
    }

    public void deleteMarker(Set<Chunk> chunks) {
        chunks.parallelStream().forEach(chunk -> {
            String markerId = "chunk_" + chunk.getX() + "_" + chunk.getZ();
            SimpleLayer layer = this.layers.get(chunk.getWorld());
            if (layer != null) {
                layer.getMarkers().removeIf(marker -> marker.getKey().equals(markerId));
            }
        });
    }
}

