/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.bexla.orevolution.OrevolutionConfig;
import net.bexla.orevolution.compatibility.ModCompat;
import net.bexla.orevolution.compatibility.farmersdelight.RegItemsFD;
import net.bexla.orevolution.compatibility.spelunkery.RegBlocksSK;
import net.bexla.orevolution.compatibility.spelunkery.RegItemsSK;
import net.bexla.orevolution.content.data.AddLootModifier;
import net.bexla.orevolution.content.data.DataRegistries;
import net.bexla.orevolution.datagens.GENLootDrops;
import net.bexla.orevolution.datagens.GENRecipes;
import net.bexla.orevolution.datagens.OrevolutionSpriteSourceProvider;
import net.bexla.orevolution.datagens.langs.GENLangENUS;
import net.bexla.orevolution.datagens.langs.GENLangESAR;
import net.bexla.orevolution.datagens.models.GENBlockStateModels;
import net.bexla.orevolution.datagens.models.GENItemModels;
import net.bexla.orevolution.datagens.tags.GENBlockTags;
import net.bexla.orevolution.datagens.tags.GENItemTags;
import net.bexla.orevolution.init.RegBlocks;
import net.bexla.orevolution.init.RegFeatures;
import net.bexla.orevolution.init.RegItems;
import net.bexla.orevolution.init.RegMisc;
import net.bexla.orevolution.init.RegMobEffects;
import net.minecraft.DetectedVersion;
import net.minecraft.WorldVersion;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;
import vectorwing.farmersdelight.common.registry.ModItems;

@Mod(value="orevolution")
public class Orevolution {
    public static final String MODID = "orevolution";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("orevolution");
    private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"orevolution");

    public Orevolution(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        OrevolutionConfig.register();
        RegMobEffects.EFFECTS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        LOOT_MODIFIERS.register("loot_item", () -> AddLootModifier.CODEC);
        REGISTRY_HELPER.register(modEventBus);
        RegFeatures.FEATURES.register(modEventBus);
        RegMisc.RegisterAll();
        LOOT_MODIFIERS.register(modEventBus);
        if (ModCompat.isModLoaded(ModCompat.FARMERSDELIGHT)) {
            RegItemsFD.register(modEventBus);
        }
        if (ModCompat.isModLoaded(ModCompat.SPELUNKERY)) {
            RegItemsSK.register(modEventBus);
        }
        RegBlocksSK.register(modEventBus);
        modEventBus.addListener(this::gatherData);
        modEventBus.addListener(this::addCreative);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture future = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        GENLangENUS lang = new GENLangENUS(output);
        generator.addProvider(client, (DataProvider)new GENBlockStateModels(output, helper));
        generator.addProvider(client, (DataProvider)new GENItemModels(output, helper));
        GENBlockTags blockTags = new GENBlockTags(output, future, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(client, (DataProvider)new GENItemTags(output, future, blockTags.m_274426_(), helper));
        generator.addProvider(client, (DataProvider)new OrevolutionSpriteSourceProvider(output, helper));
        generator.addProvider(client, (DataProvider)new GENLootDrops(output));
        generator.addProvider(client, (DataProvider)new GENRecipes(output));
        DataRegistries datapackProvider = new DataRegistries(output, future);
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(server, (DataProvider)datapackProvider);
        generator.addProvider(client, (DataProvider)lang);
        generator.addProvider(client, (DataProvider)new GENLangESAR(output));
        generator.addProvider(server, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Orevolution resources"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
    }

    @SubscribeEvent
    public void addCreative(BuildCreativeModeTabContentsEvent event) {
        ResourceKey tab = event.getTabKey();
        MutableHashedLinkedMap entries = event.getEntries();
        if (tab == CreativeModeTabs.f_256797_) {
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42425_, RegItems.TIN_SWORD);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.TIN_SWORD.get(), RegItems.LIVINGSTONE_SWORD);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.LIVINGSTONE_SWORD.get(), RegItems.VERDITE_SWORD);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42383_, RegItems.STEEL_SCYTHE);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42388_, RegItems.PLATINUM_SWORD);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42393_, RegItems.AETHERSTEEL_SWORD);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42428_, RegItems.TIN_AXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.TIN_AXE.get(), RegItems.LIVINGSTONE_AXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.LIVINGSTONE_AXE.get(), RegItems.VERDITE_AXE);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42391_, RegItems.PLATINUM_AXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42396_, RegItems.AETHERSTEEL_AXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42467_, RegItems.BRONZE_CROWN);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.BRONZE_CROWN.get(), RegItems.BRONZE_CROWN_EMERALD);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.BRONZE_CROWN_EMERALD.get(), RegItems.BRONZE_CROWN_LAPIS);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.BRONZE_CROWN_LAPIS.get(), RegItems.BRONZE_CROWN_REDSTONE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.BRONZE_CROWN_REDSTONE.get(), RegItems.BRONZE_CROWN_DIAMOND);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42471_, RegItems.PLATINUM_HELMET);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.PLATINUM_HELMET.get(), RegItems.PLATINUM_CHESTPLATE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.PLATINUM_CHESTPLATE.get(), RegItems.PLATINUM_LEGGINGS);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.PLATINUM_LEGGINGS.get(), RegItems.PLATINUM_BOOTS);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42483_, RegItems.REINFORCED_NETHERITE_HELMET);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.REINFORCED_NETHERITE_HELMET.get(), RegItems.REINFORCED_NETHERITE_CHESTPLATE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.REINFORCED_NETHERITE_CHESTPLATE.get(), RegItems.REINFORCED_NETHERITE_LEGGINGS);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.REINFORCED_NETHERITE_LEGGINGS.get(), RegItems.REINFORCED_NETHERITE_BOOTS);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.REINFORCED_NETHERITE_BOOTS.get(), RegItems.AETHERSTEEL_HELMET);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.AETHERSTEEL_HELMET.get(), RegItems.AETHERSTEEL_CHESTPLATE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.AETHERSTEEL_CHESTPLATE.get(), RegItems.AETHERSTEEL_LEGGINGS);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.AETHERSTEEL_LEGGINGS.get(), RegItems.AETHERSTEEL_BOOTS);
        } else if (tab == CreativeModeTabs.f_256869_) {
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42421_, RegItems.LIVINGSTONE_SHOVEL);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.LIVINGSTONE_SHOVEL.get(), RegItems.LIVINGSTONE_PICKAXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.LIVINGSTONE_PICKAXE.get(), RegItems.LIVINGSTONE_AXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.LIVINGSTONE_AXE.get(), RegItems.LIVINGSTONE_HOE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.LIVINGSTONE_HOE.get(), RegItems.VERDITE_SHOVEL);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.VERDITE_SHOVEL.get(), RegItems.VERDITE_PICKAXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.VERDITE_PICKAXE.get(), RegItems.VERDITE_AXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.VERDITE_AXE.get(), RegItems.VERDITE_HOE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42429_, RegItems.TIN_SHOVEL);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.TIN_SHOVEL.get(), RegItems.TIN_PICKAXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.TIN_PICKAXE.get(), RegItems.TIN_AXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.TIN_AXE.get(), RegItems.TIN_HOE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42387_, RegItems.STEEL_DIGGER);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.STEEL_DIGGER.get(), RegItems.STEEL_HAMMER);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.STEEL_HAMMER.get(), RegItems.STEEL_SCYTHE);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42389_, RegItems.PLATINUM_SHOVEL);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.PLATINUM_SHOVEL.get(), RegItems.PLATINUM_PICKAXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.PLATINUM_PICKAXE.get(), RegItems.PLATINUM_AXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.PLATINUM_AXE.get(), RegItems.PLATINUM_HOE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42397_, RegItems.AETHERSTEEL_SHOVEL);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.AETHERSTEEL_SHOVEL.get(), RegItems.AETHERSTEEL_PICKAXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.AETHERSTEEL_PICKAXE.get(), RegItems.AETHERSTEEL_AXE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.AETHERSTEEL_AXE.get(), RegItems.AETHERSTEEL_HOE);
        } else if (tab == CreativeModeTabs.f_256968_) {
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.VERDITE_INGOT.get(), RegItems.LIVINGSTONE_SHARD);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.TIN_INGOT.get(), RegItems.VERDITE_INGOT);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42416_, RegItems.TIN_INGOT);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42416_, RegItems.PLATINUM_INGOT);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.PLATINUM_INGOT.get(), RegItems.TUNGSTEN_INGOT);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.TUNGSTEN_INGOT.get(), RegItems.BRONZE_ALLOY);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42418_, RegItems.AETHERSTEEL_INGOT);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.BRONZE_ALLOY.get(), RegItems.STEEL_ALLOY);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42749_, RegItems.TIN_NUGGET);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42749_, RegItems.PLATINUM_NUGGET);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42587_, RegItems.TUNGSTEN_NUGGET);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42587_, RegItems.VERDITE_NUGGET);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151050_, RegItems.RAW_TIN);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_151050_, RegItems.RAW_PLATINUM);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.RAW_PLATINUM.get(), RegItems.RAW_TUNGSTEN);
        } else if (tab == CreativeModeTabs.f_256788_) {
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.VERDITE_BLOCK.get(), RegBlocks.LIVINGSTONE_BLOCK);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.TIN_BLOCK.get(), RegBlocks.VERDITE_BLOCK);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41913_, RegBlocks.TIN_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41913_, RegBlocks.PLATINUM_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.PLATINUM_BLOCK.get(), RegBlocks.TUNGSTEN_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42791_, RegBlocks.AETHERSTEEL_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.AETHERSTEEL_BLOCK.get(), RegBlocks.BRONZE_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.BRONZE_BLOCK.get(), RegBlocks.BRONZE_TILES);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.BRONZE_BLOCK.get(), RegBlocks.STEEL_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50612_, RegBlocks.AETHERROCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.AETHERROCK.get(), RegBlocks.POLISHED_AETHERROCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.POLISHED_AETHERROCK.get(), RegBlocks.POLISHED_AETHERROCK_STAIR);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.POLISHED_AETHERROCK_STAIR.get(), RegBlocks.POLISHED_AETHERROCK_SLAB);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.POLISHED_AETHERROCK_SLAB.get(), RegBlocks.POLISHED_AETHERROCK_WALL);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.POLISHED_AETHERROCK_WALL.get(), RegBlocks.AETHERROCK_BRICKS);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.AETHERROCK_BRICKS.get(), RegBlocks.CRACKED_AETHERROCK_BRICKS);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.CRACKED_AETHERROCK_BRICKS.get(), RegBlocks.AETHERROCK_TILES);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.TUNGSTEN_BLOCK.get(), RegBlocks.POLISHED_TUNGSTEN);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.POLISHED_TUNGSTEN.get(), RegBlocks.CUT_TUNGSTEN_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.CUT_TUNGSTEN_BLOCK.get(), RegBlocks.CHISELED_TUNGSTEN_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.CHISELED_TUNGSTEN_BLOCK.get(), RegBlocks.CHISELED_TUNGSTEN_BRICKS);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.STEEL_BLOCK.get(), RegBlocks.CUT_STEEL_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.CUT_STEEL_BLOCK.get(), RegBlocks.STEEL_PILLAR);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.STEEL_PILLAR.get(), RegBlocks.STEEL_DOOR);
        } else if (tab == CreativeModeTabs.f_256776_) {
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41834_, RegBlocks.DEEPSLATE_TIN_ORE);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.DEEPSLATE_TIN_ORE.get(), RegBlocks.TIN_ORE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150964_, RegBlocks.PLATINUM_ORE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.PLATINUM_ORE.get(), RegBlocks.DEEPSLATE_PLATINUM_ORE);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_41835_, RegBlocks.NETHER_XP_ORE);
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.END_XP_ORE.get(), RegBlocks.NETHER_XP_ORE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_42154_, RegBlocks.NETHER_TUNGSTEN_ORE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Blocks.f_50722_, RegBlocks.PRIMITIVE_AETHERROCK);
            if (ModCompat.isModLoaded(ModCompat.SPELUNKERY)) {
                Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.DEEPSLATE_PLATINUM_ORE.get(), RegBlocksSK.PLATINUM_ORE_ANDESITE);
                Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocksSK.PLATINUM_ORE_ANDESITE.get(), RegBlocksSK.PLATINUM_ORE_GRANITE);
                Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocksSK.PLATINUM_ORE_GRANITE.get(), RegBlocksSK.PLATINUM_ORE_DIORITE);
                Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocksSK.PLATINUM_ORE_DIORITE.get(), RegBlocksSK.PLATINUM_ORE_TUFF);
                Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.DEEPSLATE_TIN_ORE.get(), RegBlocksSK.TIN_ORE_ANDESITE);
                Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocksSK.TIN_ORE_ANDESITE.get(), RegBlocksSK.TIN_ORE_GRANITE);
                Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocksSK.TIN_ORE_GRANITE.get(), RegBlocksSK.TIN_ORE_DIORITE);
                Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocksSK.TIN_ORE_DIORITE.get(), RegBlocksSK.TIN_ORE_TUFF);
            }
            Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150995_, RegBlocks.RAW_TIN_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_150995_, RegBlocks.RAW_PLATINUM_BLOCK);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegBlocks.RAW_PLATINUM_BLOCK.get(), RegBlocks.RAW_TUNGSTEN_BLOCK);
        }
        Orevolution.putBefore((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_265918_, RegItems.BASIC_TEMPLATE);
        Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)Items.f_265918_, RegItems.REINFORCED_TEMPLATE);
        Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItems.REINFORCED_TEMPLATE.get(), RegItems.AETHERSTEEL_TEMPLATE);
        ResourceLocation FD_TAB = new ResourceLocation(ModCompat.FARMERSDELIGHT.getId(), ModCompat.FARMERSDELIGHT.getId());
        if (ModCompat.isModLoaded(ModCompat.FARMERSDELIGHT) && tab.m_135782_().equals((Object)FD_TAB)) {
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)ModItems.FLINT_KNIFE.get(), RegItemsFD.TIN_KNIFE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItemsFD.TIN_KNIFE.get(), RegItemsFD.LIVINGSTONE_KNIFE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)RegItemsFD.LIVINGSTONE_KNIFE.get(), RegItemsFD.VERDITE_KNIFE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)ModItems.IRON_KNIFE.get(), RegItemsFD.PLATINUM_KNIFE);
            Orevolution.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)ModItems.NETHERITE_KNIFE.get(), RegItemsFD.AETHERSTEEL_KNIFE);
        }
    }

    private static void putAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, ItemLike after, Supplier<? extends ItemLike> supplier) {
        ItemLike key = supplier.get();
        if (!entries.contains((Object)new ItemStack(after))) {
            return;
        }
        entries.putAfter((Object)new ItemStack(after), (Object)new ItemStack(key), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void putBefore(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, ItemLike before, Supplier<? extends ItemLike> supplier) {
        ItemLike key = supplier.get();
        if (!entries.contains((Object)new ItemStack(before))) {
            return;
        }
        entries.putBefore((Object)new ItemStack(before), (Object)new ItemStack(key), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }
}

