/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.data;

import net.bexla.orevolution.content.types.interfaces.Conditional;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Conditionals {
    @Contract(pure=true)
    @NotNull
    public static Conditional byChance(double chance) {
        return (stack, state, level, player, possibleTarget) -> level.m_213780_().m_188500_() < chance;
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional isTargetHPPercentage(float percentage) {
        return (stack, state, level, player, possibleTarget) -> possibleTarget != null && possibleTarget.m_21223_() / possibleTarget.m_21233_() <= percentage;
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional isTargetHPAmount(float amount) {
        return (stack, state, level, player, possibleTarget) -> possibleTarget != null && possibleTarget.m_21223_() <= amount;
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional isTargetMobType(MobType type) {
        return (stack, state, level, player, possibleTarget) -> possibleTarget != null && possibleTarget.m_6336_() == type;
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional isSubmergedInLiquid(TagKey<Fluid> fluidTag) {
        return (stack, state, level, player, target) -> player.m_204029_(fluidTag);
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional isCurrentHPPercentage(float percentage) {
        return (stack, state, level, player, possibleTarget) -> player.m_21223_() / player.m_21233_() <= percentage;
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional toolHasEnchantment(Enchantment enchantment) {
        return (stack, state, level, player, possibleTarget) -> !stack.getAllEnchantments().isEmpty() && stack.getAllEnchantments().containsKey(enchantment);
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional toolHasAnyEnchantment() {
        return (stack, state, level, player, possibleTarget) -> !stack.getAllEnchantments().isEmpty();
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional isCurrentHPAmount(int amount) {
        return (stack, state, level, player, possibleTarget) -> player.m_21223_() <= (float)amount;
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional isReceivingDayLight() {
        return (stack, state, level, player, possibleTarget) -> level.m_45527_(player.m_20183_()) && level.m_46461_();
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional isBlockstateTaggedAs(TagKey<Block> blockTag) {
        return (stack, state, level, player, possibleTarget) -> state != null && state.m_204336_(blockTag);
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional and(Conditional a, Conditional b) {
        return (stack, state, level, player, possibleTarget) -> a.shouldActivate(stack, state, level, player, possibleTarget) && b.shouldActivate(stack, state, level, player, possibleTarget);
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional or(Conditional a, Conditional b) {
        return (stack, state, level, player, possibleTarget) -> a.shouldActivate(stack, state, level, player, possibleTarget) || b.shouldActivate(stack, state, level, player, possibleTarget);
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional listConditionals(Conditional ... conditionals) {
        int n = 0;
        Conditional[] conditionalArray = conditionals;
        int n2 = conditionalArray.length;
        if (n < n2) {
            Conditional conditional = conditionalArray[n];
            return conditional;
        }
        return (stack, state, level, player, possibleTarget) -> false;
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional not(Conditional a) {
        return (stack, state, level, player, possibleTarget) -> !a.shouldActivate(stack, state, level, player, possibleTarget);
    }

    @Contract(pure=true)
    @NotNull
    public static Conditional always() {
        return (stack, state, level, player, possibleTarget) -> true;
    }
}

