/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.data.powers.armors;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.bexla.orevolution.content.types.OrevolutionArmorPower;
import net.bexla.orevolution.content.types.interfaces.Conditional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ArmorCauseEffectsOnHit
extends OrevolutionArmorPower {
    private final List<Supplier<MobEffect>> effectsTarget;
    private final List<Supplier<MobEffect>> effectsWearer;
    private final int duration;
    private final int amplifier;
    private final String tooltip_wearer_id;

    public ArmorCauseEffectsOnHit(String tooltip_target_id, String tooltip_wearer_id, Conditional conditional, int duration, int amplifier, List<Supplier<MobEffect>> effectsTarget, List<Supplier<MobEffect>> effectsWearer) {
        super(tooltip_target_id, conditional);
        this.effectsTarget = effectsTarget;
        this.effectsWearer = effectsWearer;
        this.duration = duration;
        this.amplifier = amplifier;
        this.tooltip_wearer_id = tooltip_wearer_id;
    }

    public ArmorCauseEffectsOnHit(String tooltip_target_id, String tooltip_wearer_id, Conditional conditional, int duration, int amplifier, Supplier<MobEffect> effectTarget, Supplier<MobEffect> effectWearer) {
        super(tooltip_target_id, conditional);
        this.effectsTarget = effectTarget != null ? List.of(effectTarget) : null;
        this.effectsWearer = effectWearer != null ? List.of(effectWearer) : null;
        this.duration = duration;
        this.amplifier = amplifier;
        this.tooltip_wearer_id = tooltip_wearer_id;
    }

    @Override
    public List<Component> appendTooltip(ItemStack stack, Level level, List<Component> lines) {
        ArrayList<Component> tips = new ArrayList<Component>();
        if (this.effectsTarget != null) {
            tips.add((Component)Component.m_237115_((String)("tooltip.orevolution." + this.getTooltipID())).m_130940_(ChatFormatting.GREEN));
            for (Supplier<MobEffect> p : this.effectsTarget) {
                tips.add((Component)Component.m_237113_((String)(" - " + p.get().m_19482_().getString() + (String)(this.amplifier > 0 ? " " + Component.m_237115_((String)("potion.potency." + this.amplifier)).getString() : ""))).m_130940_(ChatFormatting.AQUA));
            }
        }
        if (this.effectsWearer != null) {
            tips.add((Component)Component.m_237115_((String)("tooltip.orevolution." + this.tooltip_wearer_id)).m_130940_(ChatFormatting.GREEN));
            for (Supplier<MobEffect> p : this.effectsWearer) {
                tips.add((Component)Component.m_237113_((String)(" - " + p.get().m_19482_().getString() + (String)(this.amplifier > 0 ? " " + Component.m_237115_((String)("potion.potency." + this.amplifier)).getString() : ""))).m_130940_(ChatFormatting.AQUA));
            }
        }
        return tips;
    }

    @Override
    public void onAttackTarget(LivingEntity wearer, LivingEntity target) {
        if (!this.getCondition(null, wearer.m_9236_(), wearer, target)) {
            return;
        }
        if (this.effectsTarget != null) {
            for (Supplier<MobEffect> p : this.effectsTarget) {
                if (target.m_21023_(p.get())) {
                    target.m_21124_(p.get()).m_19558_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
                    continue;
                }
                target.m_7292_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
            }
        }
        if (this.effectsWearer != null) {
            for (Supplier<MobEffect> p : this.effectsWearer) {
                if (wearer.m_21023_(p.get())) {
                    wearer.m_21124_(p.get()).m_19558_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
                    continue;
                }
                wearer.m_7292_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
            }
        }
    }
}

