/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.data.powers.armors;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.bexla.orevolution.content.types.OrevolutionArmorPower;
import net.bexla.orevolution.content.types.interfaces.Conditional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ArmorGrantEffects
extends OrevolutionArmorPower {
    private final List<Supplier<MobEffect>> effects;
    private final int duration;
    private final int amplifier;

    public ArmorGrantEffects(String tooltipId, Conditional conditional, int duration, int amplifier, List<Supplier<MobEffect>> effect) {
        super(tooltipId, conditional);
        this.effects = effect;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public ArmorGrantEffects(String tooltipId, Conditional conditional, int duration, int amplifier, Supplier<MobEffect> effect) {
        super(tooltipId, conditional);
        this.effects = effect != null ? List.of(effect) : null;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public List<Component> appendTooltip(ItemStack stack, Level level, List<Component> lines) {
        ArrayList<Component> tips = new ArrayList<Component>();
        tips.add((Component)Component.m_237115_((String)("tooltip.orevolution." + this.getTooltipID())).m_130940_(ChatFormatting.GREEN));
        for (Supplier<MobEffect> p : this.effects) {
            tips.add((Component)Component.m_237113_((String)(" - " + p.get().m_19482_().getString() + (String)(this.amplifier > 0 ? " " + Component.m_237115_((String)("potion.potency." + this.amplifier)).getString() : ""))).m_130940_(ChatFormatting.AQUA));
        }
        return tips;
    }

    @Override
    public void onTickWhileWorn(ItemStack stack, LivingEntity wearer, EquipmentSlot slot) {
        if (!this.getCondition(stack, wearer.m_9236_(), wearer, null)) {
            return;
        }
        for (Supplier<MobEffect> p : this.effects) {
            if (wearer.m_21023_(p.get())) {
                wearer.m_21124_(p.get()).m_19558_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
                continue;
            }
            wearer.m_7292_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
        }
    }
}

