/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.data.powers.armors;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.bexla.orevolution.content.types.OrevolutionArmorPower;
import net.bexla.orevolution.content.types.interfaces.Conditional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ArmorGrantImmunityEffects
extends OrevolutionArmorPower {
    private final List<Supplier<MobEffect>> effects;

    public ArmorGrantImmunityEffects(String tooltipId, Conditional conditional, List<Supplier<MobEffect>> effects) {
        super(tooltipId, conditional);
        this.effects = effects;
    }

    public ArmorGrantImmunityEffects(String tooltipId, Conditional conditional, Supplier<MobEffect> effect) {
        super(tooltipId, conditional);
        this.effects = effect != null ? List.of(effect) : null;
    }

    @Override
    public List<Component> appendTooltip(ItemStack stack, Level level, List<Component> lines) {
        ArrayList<Component> tips = new ArrayList<Component>();
        tips.add((Component)Component.m_237115_((String)("tooltip.orevolution." + this.getTooltipID())).m_130940_(ChatFormatting.GREEN));
        for (Supplier<MobEffect> p : this.effects) {
            tips.add((Component)Component.m_237113_((String)(" - " + p.get().m_19482_().getString())).m_130940_(ChatFormatting.AQUA));
        }
        return tips;
    }

    @Override
    public void onTickWhileWorn(ItemStack stack, LivingEntity wearer, EquipmentSlot slot) {
        if (!this.getCondition(stack, wearer.m_9236_(), wearer, null)) {
            return;
        }
        for (Supplier<MobEffect> p : this.effects) {
            wearer.m_21195_(p.get());
        }
    }
}

