/*
 * Decompiled with CFR 0.152.
 */
package net.bexla.orevolution.content.data.powers.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.bexla.orevolution.content.types.OrevolutionToolPower;
import net.bexla.orevolution.content.types.interfaces.Conditional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ToolCauseMultipleEffectsOnHit
extends OrevolutionToolPower {
    protected final List<Supplier<MobEffect>> effectTarget;
    protected final List<Supplier<MobEffect>> effectAttacker;
    private final int duration;
    private final int amplifier;
    private final String tooltip_attacker_id;

    public ToolCauseMultipleEffectsOnHit(String tooltip_target_id, String tooltip_attacker_id, Conditional conditional, int duration, int amplifier, List<Supplier<MobEffect>> effectTarget, List<Supplier<MobEffect>> effectAttacker) {
        super(tooltip_target_id, conditional);
        this.tooltip_attacker_id = tooltip_attacker_id;
        this.effectTarget = effectTarget;
        this.effectAttacker = effectAttacker;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    @Override
    public List<Component> appendTooltip(ItemStack stack, Level level, List<Component> lines) {
        ArrayList<Component> tips = new ArrayList<Component>();
        if (this.effectTarget != null) {
            tips.add((Component)Component.m_237115_((String)("tooltip.orevolution." + this.getTooltipID())).m_130940_(ChatFormatting.GREEN));
            for (Supplier<MobEffect> p : this.effectTarget) {
                tips.add((Component)Component.m_237113_((String)(" - " + p.get().m_19482_().getString() + (this.amplifier > 0 ? Component.m_237115_((String)("potion.potency." + this.amplifier)).toString() : ""))).m_130940_(ChatFormatting.AQUA));
            }
        }
        if (this.effectAttacker != null) {
            tips.add((Component)Component.m_237115_((String)("tooltip.orevolution." + this.tooltip_attacker_id)).m_130940_(ChatFormatting.GREEN));
            for (Supplier<MobEffect> p : this.effectAttacker) {
                tips.add((Component)Component.m_237113_((String)(" - " + p.get().m_19482_().getString() + (this.amplifier > 0 ? Component.m_237115_((String)("potion.potency." + this.amplifier)).toString() : ""))).m_130940_(ChatFormatting.AQUA));
            }
        }
        return tips;
    }

    @Override
    public void onHitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.getCondition(stack, null, attacker.m_9236_(), attacker, target)) {
            return;
        }
        if (this.effectTarget != null) {
            for (Supplier<MobEffect> p : this.effectTarget) {
                if (target.m_21023_(p.get())) {
                    target.m_21124_(p.get()).m_19558_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
                    continue;
                }
                target.m_7292_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
            }
        }
        if (this.effectAttacker != null) {
            for (Supplier<MobEffect> p : this.effectAttacker) {
                if (attacker.m_21023_(p.get())) {
                    attacker.m_21124_(p.get()).m_19558_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
                    continue;
                }
                attacker.m_7292_(new MobEffectInstance(p.get(), this.duration, this.amplifier));
            }
        }
    }
}

